/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.util;

import com.github.sculkhorde.common.block.SculkBeeNestBlock;
import com.github.sculkhorde.common.block.SculkFloraBlock;
import com.github.sculkhorde.common.block.VeinBlock;
import com.github.sculkhorde.common.entity.SculkBeeHarvesterEntity;
import com.github.sculkhorde.common.entity.SculkBeeInfectorEntity;
import com.github.sculkhorde.common.procedural.structures.PlannedBlock;
import com.github.sculkhorde.common.tileentity.SculkBeeNestTile;
import com.github.sculkhorde.core.BlockRegistry;
import com.github.sculkhorde.core.SculkHorde;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BlockAlgorithms {
    public static float getSudoRNGFromPosition(BlockPos position, int min, int max) {
        int range = max - min;
        long seed = (long)position.func_177958_n() * (long)position.func_177956_o() * (long)position.func_177952_p() + (long)(position.func_177958_n() + position.func_177956_o() + position.func_177952_p());
        int rng = (int)((double)seed % ((double)range + 1.0));
        return rng += min;
    }

    public static ArrayList<BlockPos> getNeighborsCube(BlockPos origin) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        list.addAll(BlockAlgorithms.getNeighborsXZPlane(origin, false));
        list.addAll(BlockAlgorithms.getNeighborsXZPlane(origin.func_177984_a(), true));
        list.addAll(BlockAlgorithms.getNeighborsXZPlane(origin.func_177977_b(), true));
        return list;
    }

    public static ArrayList<BlockPos> getAdjacentNeighbors(BlockPos origin) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        list.addAll(BlockAlgorithms.getNeighborsXZPlane(origin, false));
        list.addAll(BlockAlgorithms.getNeighborsXZPlane(origin.func_177984_a(), true));
        list.addAll(BlockAlgorithms.getNeighborsXZPlane(origin.func_177977_b(), true));
        return list;
    }

    public static ArrayList<BlockPos> getNeighborsXZPlane(BlockPos origin, boolean includeOrigin) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        list.add(origin.func_177978_c());
        list.add(origin.func_177978_c().func_177974_f());
        list.add(origin.func_177978_c().func_177976_e());
        list.add(origin.func_177974_f());
        list.add(origin.func_177968_d());
        list.add(origin.func_177968_d().func_177974_f());
        list.add(origin.func_177968_d().func_177976_e());
        list.add(origin.func_177976_e());
        if (includeOrigin) {
            list.add(origin);
        }
        return list;
    }

    public static float getBlockDistance(BlockPos pos1, BlockPos pos2) {
        return (float)Math.sqrt(Math.pow(pos2.func_177958_n() - pos1.func_177958_n(), 2.0) + Math.pow(pos2.func_177956_o() - pos1.func_177956_o(), 2.0) + Math.pow(pos2.func_177952_p() - pos1.func_177952_p(), 2.0));
    }

    public static ArrayList<BlockPos> getBlockPosInCube(BlockPos origin, int length, boolean includeOrigin) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        int center_x = origin.func_177958_n();
        int center_y = origin.func_177956_o();
        int center_z = origin.func_177952_p();
        int start_pos_x = center_x - length / 2 - 1;
        int start_pos_y = center_y - length / 2 - 1;
        int start_pos_z = center_z - length / 2 - 1;
        for (int y_offset = 0; y_offset < length; ++y_offset) {
            int current_pos_y = start_pos_y + y_offset;
            for (int z_offset = 0; z_offset < length; ++z_offset) {
                int current_pos_z = start_pos_z + z_offset;
                for (int x_offset = 0; x_offset < length; ++x_offset) {
                    int current_pos_x = start_pos_x + x_offset;
                    boolean shouldWeAddThisPosition = true;
                    BlockPos targetPos = new BlockPos(current_pos_x, current_pos_y, current_pos_z);
                    if (!includeOrigin && targetPos.func_177958_n() == origin.func_177958_n() && targetPos.func_177956_o() == origin.func_177956_o() && targetPos.func_177952_p() == origin.func_177952_p()) {
                        shouldWeAddThisPosition = false;
                    }
                    if (!shouldWeAddThisPosition) continue;
                    positions.add(targetPos);
                }
            }
        }
        return positions;
    }

    public static ArrayList<BlockPos> getBlockPosInCircle(BlockPos origin, int radius, boolean includeOrigin) {
        if (radius <= 0) {
            throw new IllegalArgumentException("Radius must be greater than 0. Radius given was " + radius + ".");
        }
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        int center_x = origin.func_177958_n();
        int center_y = origin.func_177956_o();
        int center_z = origin.func_177952_p();
        int start_pos_x = center_x - radius - 1;
        int start_pos_y = center_y - radius - 1;
        int start_pos_z = center_z - radius - 1;
        for (int y_offset = 0; y_offset < radius * 2 + 2; ++y_offset) {
            int current_pos_y = start_pos_y + y_offset;
            for (int z_offset = 0; z_offset < radius * 2 + 2; ++z_offset) {
                int current_pos_z = start_pos_z + z_offset;
                for (int x_offset = 0; x_offset < radius * 2 + 2; ++x_offset) {
                    int current_pos_x = start_pos_x + x_offset;
                    boolean shouldWeAddThisPosition = true;
                    BlockPos targetPos = new BlockPos(current_pos_x, current_pos_y, current_pos_z);
                    double distance = BlockAlgorithms.getBlockDistance(origin, targetPos);
                    if (distance > (double)radius) {
                        shouldWeAddThisPosition = false;
                    }
                    if (!includeOrigin && targetPos.func_177958_n() == origin.func_177958_n() && targetPos.func_177956_o() == origin.func_177956_o() && targetPos.func_177952_p() == origin.func_177952_p()) {
                        shouldWeAddThisPosition = false;
                    }
                    if (!shouldWeAddThisPosition) continue;
                    positions.add(targetPos);
                }
            }
        }
        return positions;
    }

    public static Optional<BlockPos> findNearestBlock(ServerWorld worldIn, BlockPos origin, Predicate<BlockState> predicateIn, double pDistance) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        int i = 0;
        while ((double)i <= pDistance) {
            int j = 0;
            while ((double)j < pDistance) {
                int k = 0;
                while (k <= j) {
                    int l;
                    int n = l = k < j && k > -j ? j : 0;
                    while (l <= j) {
                        blockpos$mutable.func_239621_a_((Vector3i)origin, k, i - 1, l);
                        if (origin.func_218141_a((Vector3i)blockpos$mutable, pDistance) && predicateIn.test(worldIn.func_180495_p((BlockPos)blockpos$mutable))) {
                            return Optional.of(blockpos$mutable);
                        }
                        l = l > 0 ? -l : 1 - l;
                    }
                    k = k > 0 ? -k : 1 - k;
                }
                ++j;
            }
            i = i > 0 ? -i : 1 - i;
        }
        return Optional.empty();
    }

    public static ArrayList<BlockPos> getBlocksInArea(ServerWorld worldIn, BlockPos origin, Predicate<BlockState> predicateIn, double pDistance) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        int i = 0;
        while ((double)i <= pDistance) {
            int j = 0;
            while ((double)j < pDistance) {
                int k = 0;
                while (k <= j) {
                    int l;
                    int n = l = k < j && k > -j ? j : 0;
                    while (l <= j) {
                        BlockPos temp = new BlockPos(origin.func_177958_n() + k, origin.func_177956_o() + i - 1, origin.func_177952_p() + l);
                        if (origin.func_218141_a((Vector3i)temp, pDistance) && predicateIn.test(worldIn.func_180495_p(temp))) {
                            list.add(temp);
                        }
                        l = l > 0 ? -l : 1 - l;
                    }
                    k = k > 0 ? -k : 1 - k;
                }
                ++j;
            }
            i = i > 0 ? -i : 1 - i;
        }
        return list;
    }

    public static ArrayList<BlockPos> getBlocksInCube(ServerWorld worldIn, BlockPos origin, Predicate<BlockPos> predicateIn, double pDistance) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        int i = 0;
        while ((double)i <= pDistance) {
            int j = 0;
            while ((double)j < pDistance) {
                int k = 0;
                while (k <= j) {
                    int l;
                    int n = l = k < j && k > -j ? j : 0;
                    while (l <= j) {
                        BlockPos temp = new BlockPos(origin.func_177958_n() + k, origin.func_177956_o() + i - 1, origin.func_177952_p() + l);
                        if (origin.func_218141_a((Vector3i)temp, pDistance) && predicateIn.test(temp)) {
                            list.add(temp);
                        }
                        l = l > 0 ? -l : 1 - l;
                    }
                    k = k > 0 ? -k : 1 - k;
                }
                ++j;
            }
            i = i > 0 ? -i : 1 - i;
        }
        return list;
    }

    public static BlockPos getRandomNeighbor(ServerWorld serverWorld, BlockPos origin) {
        ArrayList<BlockPos> positions = BlockAlgorithms.getNeighborsCube(origin);
        return positions.get(serverWorld.field_73012_v.nextInt(positions.size()));
    }

    public static boolean isExposedToAir(ServerWorld serverWorld, BlockPos targetPos) {
        ArrayList<BlockPos> list = BlockAlgorithms.getAdjacentNeighbors(targetPos);
        for (BlockPos position : list) {
            if (!serverWorld.func_180495_p(position).func_196958_f()) continue;
            return true;
        }
        return false;
    }

    public static void placeSculkBeeHive(ServerWorld world, BlockPos targetPos) {
        if (new Random().nextInt(4000) <= 1 && world.func_226660_f_(targetPos)) {
            world.func_175656_a(targetPos, ((SculkBeeNestBlock)BlockRegistry.SCULK_BEE_NEST_BLOCK.get()).func_176223_P());
            SculkBeeNestTile nest = (SculkBeeNestTile)world.func_175625_s(targetPos);
            nest.addOccupant((Entity)new SculkBeeHarvesterEntity((World)world));
            nest.addOccupant((Entity)new SculkBeeHarvesterEntity((World)world));
            nest.addOccupant((Entity)new SculkBeeInfectorEntity((World)world));
            nest.addOccupant((Entity)new SculkBeeInfectorEntity((World)world));
        }
    }

    public static void placeSculkFlora(BlockPos targetPos, ServerWorld world) {
        ((SculkFloraBlock)SculkHorde.randomSculkFlora.getRandomEntry()).placeBlockHere(world, targetPos);
    }

    public static void placeFloraAroundLog(ServerWorld serverWorld, BlockPos origin) {
        BlockPos[] possiblePositions;
        VeinBlock vein = (VeinBlock)BlockRegistry.VEIN.get();
        for (BlockPos pos : possiblePositions = new BlockPos[]{origin.func_177978_c(), origin.func_177974_f(), origin.func_177968_d(), origin.func_177976_e()}) {
            if (serverWorld.field_73012_v.nextInt(10) >= 3 || !serverWorld.func_180495_p(pos).func_196958_f()) continue;
            vein.placeBlock((World)serverWorld, pos);
        }
    }

    public static void placePatchesOfVeinAbove(ServerWorld serverWorld, BlockPos origin) {
        int OFFSET_MAX = 3;
        int LENGTH_MAX = 5;
        int LENGTH_MIN = 3;
        Random rng = new Random();
        int offset = rng.nextInt(OFFSET_MAX);
        int length = rng.nextInt(LENGTH_MAX - LENGTH_MIN) + LENGTH_MIN;
        VeinBlock vein = (VeinBlock)BlockRegistry.VEIN.get();
        BlockPos indexPos = origin.func_177981_b(offset);
        for (int i = 0; i < length; ++i) {
            indexPos = indexPos.func_177984_a();
            if (serverWorld.field_73012_v.nextInt(4) > 2) continue;
            vein.placeBlock((World)serverWorld, indexPos);
        }
    }

    public static void replaceSculkFlora(ServerWorld serverWorld, BlockPos targetPos) {
        if (serverWorld.func_180495_p(targetPos).func_177230_c() instanceof SculkFloraBlock) {
            serverWorld.func_175656_a(targetPos, Blocks.field_150349_c.func_176223_P());
        } else if (serverWorld.func_180495_p(targetPos).func_177230_c() instanceof VeinBlock) {
            serverWorld.func_217377_a(targetPos, false);
        }
    }

    public static ArrayList<PlannedBlock> generate2DCirclePlan(BlockPos centerPos, int diameter, ServerWorld world, BlockState plannedBlock) {
        ArrayList<PlannedBlock> circleBlocks = new ArrayList<PlannedBlock>();
        int radius = diameter / 2;
        for (int x = centerPos.func_177958_n() - radius; x <= centerPos.func_177958_n() + radius; ++x) {
            for (int z = centerPos.func_177952_p() - radius; z <= centerPos.func_177952_p() + radius; ++z) {
                double distance = Math.sqrt((x - centerPos.func_177958_n()) * (x - centerPos.func_177958_n()) + (z - centerPos.func_177952_p()) * (z - centerPos.func_177952_p()));
                if (!(distance <= (double)radius)) continue;
                BlockPos pos = new BlockPos(x, centerPos.func_177956_o(), z);
                circleBlocks.add(new PlannedBlock(world, plannedBlock, pos));
            }
        }
        return circleBlocks;
    }

    public static ArrayList<BlockPos> getPointsOnCircumference(BlockPos origin, int numPoints, int radius) {
        ArrayList<BlockPos> points = new ArrayList<BlockPos>();
        double angleIncrement = Math.PI * 2 / (double)numPoints;
        for (int i = 0; i < numPoints; ++i) {
            double angle = (double)i * angleIncrement;
            int x = (int)((double)origin.func_177958_n() + (double)radius * Math.cos(angle));
            int z = (int)((double)origin.func_177952_p() + (double)radius * Math.sin(angle));
            points.add(new BlockPos(x, origin.func_177956_o(), z));
        }
        return points;
    }

    public static Vector3d scalarMultiply(Vector3d vector, double t) {
        return new Vector3d(vector.field_72450_a + t, vector.field_72448_b * t, vector.field_72449_c + t);
    }
}

