/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.util;

import com.github.sculkhorde.common.entity.SculkBeeHarvesterEntity;
import com.github.sculkhorde.common.entity.SculkBeeInfectorEntity;
import com.github.sculkhorde.common.entity.SculkHatcherEntity;
import com.github.sculkhorde.common.entity.SculkMiteAggressorEntity;
import com.github.sculkhorde.common.entity.SculkMiteEntity;
import com.github.sculkhorde.common.entity.SculkRavagerEntity;
import com.github.sculkhorde.common.entity.SculkSpitterEntity;
import com.github.sculkhorde.common.entity.SculkSporeSpewerEntity;
import com.github.sculkhorde.common.entity.SculkZombieEntity;
import com.github.sculkhorde.core.EffectRegistry;
import com.github.sculkhorde.core.SculkHorde;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.server.ServerWorld;

public class EntityAlgorithms {
    public static Predicate<LivingEntity> isSculkLivingEntity = e -> e instanceof SculkMiteEntity || e instanceof SculkMiteAggressorEntity || e instanceof SculkZombieEntity || e instanceof SculkSpitterEntity || e instanceof SculkSporeSpewerEntity || e instanceof SculkBeeHarvesterEntity || e instanceof SculkBeeInfectorEntity || e instanceof SculkHatcherEntity || e instanceof SculkRavagerEntity;

    @Nullable
    public static BlockPos playerTargetBlockPos(PlayerEntity player, boolean isFluid) {
        RayTraceResult block = player.func_213324_a(200.0, 0.0f, isFluid);
        if (block.func_216346_c() == RayTraceResult.Type.BLOCK) {
            return ((BlockRayTraceResult)block).func_216350_a();
        }
        return null;
    }

    public static AxisAlignedBB getSearchAreaRectangle(double originX, double originY, double originZ, double w, double h, double l) {
        double x1 = originX - w;
        double y1 = originY - h;
        double z1 = originZ - l;
        double x2 = originX + w;
        double y2 = originY + h;
        double z2 = originZ + l;
        return new AxisAlignedBB(x1, y1, z1, x2, y2, z2);
    }

    public static boolean isLivingEntityInfected(LivingEntity e) {
        return e.func_70644_a((Effect)EffectRegistry.SCULK_INFECTION.get());
    }

    public static boolean isLivingEntityHostile(LivingEntity entity) {
        return SculkHorde.gravemind.getGravemindMemory().getHostileEntries().get(entity.func_200600_R().toString()) != null;
    }

    public static boolean isLivingEntitySwimmer(LivingEntity entity) {
        return entity instanceof WaterMobEntity;
    }

    public static List<LivingEntity> getLivingEntitiesInBoundingBox(ServerWorld serverWorld, AxisAlignedBB boundingBox) {
        List livingEntitiesInRange = serverWorld.func_225316_b(LivingEntity.class, boundingBox, (Predicate)null);
        return livingEntitiesInRange;
    }

    public static List<BlockPos> createPathToBlockPos(ServerWorld world, BlockPos start, BlockPos end, int maxRange, Predicate<BlockState> obstaclePredicate) {
        ArrayList path = new ArrayList();
        return null;
    }
}

