/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.util;

import com.github.sculkhorde.common.block.SculkMassBlock;
import com.github.sculkhorde.core.BlockRegistry;
import com.github.sculkhorde.core.EffectRegistry;
import com.github.sculkhorde.core.EntityRegistry;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.core.gravemind.Gravemind;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="sculkhorde", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEventSubscriber {
    private static long time_save_point;
    private static int sculkMassCheck;

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().func_201670_d() && event.getWorld().equals(ServerLifecycleHooks.getCurrentServer().func_241755_D_())) {
            SculkHorde.gravemind = new Gravemind();
            time_save_point = 0L;
            sculkMassCheck = 0;
        }
    }

    @SubscribeEvent
    public static void WorldTickEvent(TickEvent.WorldTickEvent event) {
        if (!event.world.func_201670_d() && SculkHorde.gravemind != null && event.world.equals(ServerLifecycleHooks.getCurrentServer().func_241755_D_())) {
            int ticks_per_second = 20;
            int seconds_between_intervals = 300;
            SculkHorde.infestationConversionTable.processDeInfectionQueue((ServerWorld)event.world);
            if (event.world.func_82737_E() - time_save_point > (long)(seconds_between_intervals * ticks_per_second)) {
                time_save_point = event.world.func_82737_E();
                SculkHorde.gravemind.enableAmountOfBeeHives((ServerWorld)event.world, 20);
                SculkHorde.gravemind.getGravemindMemory().validateNodeEntries((ServerWorld)event.world);
                SculkHorde.gravemind.getGravemindMemory().validateBeeNestEntries((ServerWorld)event.world);
                SculkHorde.gravemind.calulateCurrentState();
                if (SculkHorde.DEBUG_MODE) {
                    System.out.println("Gravemind Evolution State: " + SculkHorde.gravemind.getEvolutionState().toString());
                }
                if (SculkHorde.DEBUG_MODE) {
                    System.out.println("Accumulated Mass Since Last Check: " + (SculkHorde.gravemind.getGravemindMemory().getSculkAccumulatedMass() - sculkMassCheck));
                }
                sculkMassCheck = SculkHorde.gravemind.getGravemindMemory().getSculkAccumulatedMass();
                if (SculkHorde.DEBUG_MODE) {
                    System.out.println("\n Known Nodes: " + SculkHorde.gravemind.getGravemindMemory().getNodeEntries().size() + "\n Known Nests: " + SculkHorde.gravemind.getGravemindMemory().getBeeNestEntries().size() + "\n Known Hostiles: " + SculkHorde.gravemind.getGravemindMemory().getHostileEntries().size() + "\n");
                }
                if (SculkHorde.DEBUG_MODE) {
                    System.out.println("Accumulated Mass Since Last Check: " + (SculkHorde.gravemind.getGravemindMemory().getSculkAccumulatedMass() - sculkMassCheck));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPotionExpireEvent(PotionEvent.PotionExpiryEvent event) {
        if (!event.getEntity().field_70170_p.func_201670_d() && SculkHorde.gravemind != null && event.getEntity().field_70170_p.equals(ServerLifecycleHooks.getCurrentServer().func_241755_D_())) {
            LivingEntity entity;
            EffectInstance effectInstance = event.getPotionEffect();
            assert (effectInstance != null);
            if (effectInstance.func_188419_a() == EffectRegistry.SCULK_INFECTION.get() && (entity = event.getEntityLiving()) != null) {
                int infectionDamage = 4;
                for (int i = 0; i < effectInstance.func_76458_c() + 1; ++i) {
                    World entityLevel = entity.field_70170_p;
                    BlockPos entityPosition = entity.func_233580_cy_();
                    float entityHealth = entity.func_110138_aP();
                    EntityRegistry.SCULK_MITE.func_220331_a((ServerWorld)event.getEntity().field_70170_p, null, null, entityPosition, SpawnReason.SPAWNER, true, true);
                    SculkMassBlock sculkMass = (SculkMassBlock)BlockRegistry.SCULK_MASS.get();
                    sculkMass.spawn(entityLevel, entityPosition, entityHealth);
                    entity.func_70097_a(DamageSource.field_76377_j, (float)infectionDamage);
                }
            }
        }
    }
}

