/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.util;

import com.github.sculkhorde.common.entity.InfestationPurifierEntity;
import com.github.sculkhorde.util.EntityAlgorithms;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.MathHelper;

public class TargetParameters {
    private MobEntity mob;
    private boolean targetHostiles = false;
    private boolean targetPassives = false;
    private boolean targetInfected = false;
    private boolean targetBelow50PercentHealth = true;
    private boolean targetSwimmers = false;
    private boolean mustSeeTarget = false;
    private long lastTargetSeenTime = System.currentTimeMillis();
    private long MAX_TARGET_UNSEEN_TIME_MILLIS = TimeUnit.SECONDS.toMillis(30L);
    private boolean mustReachTarget = false;
    private HashMap<UUID, Long> blacklist = new HashMap();
    public final Predicate<LivingEntity> isPossibleNewTargetValid = e -> this.isEntityValidTarget((LivingEntity)e, false);

    public TargetParameters() {
        this.mob = null;
    }

    public TargetParameters(MobEntity mob) {
        this.mob = mob;
    }

    public boolean isEntityValidTarget(LivingEntity e, boolean validatingExistingTarget) {
        if (e == null) {
            return false;
        }
        if (!(e instanceof MobEntity) && !(e instanceof PlayerEntity)) {
            return false;
        }
        if (EntityAlgorithms.isSculkLivingEntity.test(e)) {
            return false;
        }
        if (e instanceof CreeperEntity) {
            return false;
        }
        if (e instanceof InfestationPurifierEntity) {
            return true;
        }
        if (!e.func_70075_an() || e.func_190530_aW() || !e.func_70089_S() || e.func_175149_v()) {
            return false;
        }
        if (e instanceof PlayerEntity && (((PlayerEntity)e).func_184812_l_() || ((PlayerEntity)e).func_175149_v())) {
            return false;
        }
        if (this.blacklist.containsKey(e.func_110124_au())) {
            return false;
        }
        if (!this.targetInfected && EntityAlgorithms.isLivingEntityInfected(e)) {
            return false;
        }
        if (!this.targetPassives && !EntityAlgorithms.isLivingEntityHostile(e)) {
            return false;
        }
        if (!this.targetHostiles && EntityAlgorithms.isLivingEntityHostile(e)) {
            return false;
        }
        if (!this.targetSwimmers && EntityAlgorithms.isLivingEntitySwimmer(e)) {
            return false;
        }
        if (!this.targetBelow50PercentHealth && e.func_110143_aJ() < e.func_110138_aP() / 2.0f) {
            return false;
        }
        return validatingExistingTarget || !this.mustReachTarget() || this.canReach(e);
    }

    public TargetParameters enableTargetHostiles() {
        this.targetHostiles = true;
        return this;
    }

    public boolean isTargetingHostiles() {
        return this.targetHostiles;
    }

    public TargetParameters enableTargetPassives() {
        this.targetPassives = true;
        return this;
    }

    public boolean isTargetingPassives() {
        return this.targetPassives;
    }

    public TargetParameters enableTargetInfected() {
        this.targetInfected = true;
        return this;
    }

    public boolean isTargetingInfected() {
        return this.targetInfected;
    }

    public TargetParameters ignoreTargetBelow50PercentHealth() {
        this.targetBelow50PercentHealth = false;
        return this;
    }

    public boolean isIgnoringTargetBelow50PercentHealth() {
        return this.targetBelow50PercentHealth;
    }

    public TargetParameters enableTargetSwimmers() {
        this.targetSwimmers = true;
        return this;
    }

    public boolean isTargetingSwimmers() {
        return this.targetSwimmers;
    }

    public TargetParameters enableMustReachTarget() {
        if (this.mob == null) {
            throw new IllegalStateException("Cannot enable must reach target without a mob");
        }
        this.mustReachTarget = true;
        return this;
    }

    public boolean mustReachTarget() {
        return this.mustReachTarget;
    }

    private boolean canReach(LivingEntity pTarget) {
        int j;
        Path path = this.mob.func_70661_as().func_75494_a((Entity)pTarget, 0);
        if (path == null) {
            return false;
        }
        PathPoint pathpoint = path.func_75870_c();
        if (pathpoint == null) {
            return false;
        }
        int i = pathpoint.field_75839_a - MathHelper.func_76128_c((double)pTarget.func_226277_ct_());
        return (double)(i * i + (j = pathpoint.field_75838_c - MathHelper.func_76128_c((double)pTarget.func_226281_cx_())) * j) <= 50.0;
    }

    public void addToBlackList(MobEntity entity) {
        this.blacklist.put(entity.func_110124_au(), System.currentTimeMillis());
    }

    public boolean isOnBlackList(MobEntity entity) {
        return this.blacklist.containsKey(entity.func_110124_au());
    }
}

