/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.block.BlockInfestation;

import com.github.sculkhorde.common.block.InfestedLogBlock;
import com.github.sculkhorde.core.BlockRegistry;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.util.BlockAlgorithms;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class InfestationConversionHandler {
    public ArrayList<BlockPos> convertToVictimNodeQueue = new ArrayList();
    public ArrayList<BlockPos> convertToInfectedNodeQueue = new ArrayList();
    public final int conversionAmountPerInterval = 1;
    public ArrayList<ConversionRequest> conversionQueue = new ArrayList();
    public InfestationTable infestationTable = new InfestationTable();

    public boolean infectBlock(ServerLevel world, BlockPos targetPos) {
        if (world == null) {
            return false;
        }
        BlockState targetBlock = world.m_8055_(targetPos);
        BlockState newBlock = null;
        newBlock = this.infestationTable.getInfestedVariant(targetBlock);
        if (targetBlock.m_204336_(BlockTags.f_13106_)) {
            newBlock = ((InfestedLogBlock)((Object)BlockRegistry.INFESTED_LOG.get())).m_49966_();
        }
        if (newBlock == null) {
            return false;
        }
        world.m_46597_(targetPos, newBlock);
        world.m_8767_((ParticleOptions)ParticleTypes.f_235900_, (double)targetPos.m_123341_() + 0.5, (double)targetPos.m_123342_() + 1.15, (double)targetPos.m_123343_() + 0.5, 2, 0.2, 0.0, 0.2, 0.0);
        world.m_5594_((Player)null, targetPos, SoundEvents.f_215753_, SoundSource.BLOCKS, 2.0f, 1.6f);
        ArrayList<BlockPos> adjacentBlockPos = BlockAlgorithms.getAdjacentNeighbors(targetPos);
        for (BlockPos pos : adjacentBlockPos) {
            BlockState blockState = world.m_8055_(pos);
            if (blockState.m_60734_() != BlockRegistry.TENDRILS.get() || blockState.m_60734_().m_7898_(blockState, (LevelReader)world, pos)) continue;
            world.m_46961_(pos, false);
        }
        if (world.f_46441_.m_188503_(4) <= 0) {
            BlockAlgorithms.tryPlaceSculkFlora(targetPos.m_7494_(), world);
        } else if (world.f_46441_.m_188503_(1000) <= 0) {
            BlockAlgorithms.tryPlaceLivingRockRoot(targetPos.m_7494_(), world);
        }
        if (newBlock.m_60734_() == BlockRegistry.INFESTED_LOG.get()) {
            BlockAlgorithms.placeFloraAroundLog(world, targetPos);
        }
        SculkHorde.gravemind.placeSculkNode(world, targetPos.m_7494_(), true);
        BlockAlgorithms.placePatchesOfVeinAbove(world, targetPos);
        BlockAlgorithms.tryPlaceSculkBeeHive(world, targetPos.m_7494_());
        return true;
    }

    public boolean deinfectBlock(ServerLevel world, BlockPos targetPos) {
        if (world == null) {
            return false;
        }
        BlockState targetBlock = world.m_8055_(targetPos);
        Block victimBlock = this.infestationTable.getNormalVariant(targetBlock);
        if (victimBlock == null) {
            return false;
        }
        BlockState victimVariant = victimBlock.m_49966_();
        if (targetBlock.m_60713_((Block)BlockRegistry.INFESTED_LOG.get())) {
            victimVariant = Blocks.f_49999_.m_49966_();
        }
        if (victimVariant != null) {
            world.m_46597_(targetPos, victimVariant);
            return true;
        }
        return false;
    }

    public void processDeInfectionQueue(ServerLevel world) {
        if (!world.m_5776_()) {
            for (int i = 0; i < 1 && i < this.convertToVictimNodeQueue.size(); ++i) {
                BlockAlgorithms.replaceSculkFlora(world, this.convertToVictimNodeQueue.get(i));
                this.deinfectBlock(world, this.convertToVictimNodeQueue.get(i));
                this.convertToVictimNodeQueue.remove(i);
                --i;
            }
        }
    }

    public class InfestationTable {
        private List<InfestationTableEntry> entries = new ArrayList<InfestationTableEntry>();

        public void addEntry(Block normalVariant, BlockState infectedVariant) {
            this.entries.add(new InfestationTableEntry(normalVariant, infectedVariant));
        }

        public BlockState getInfestedVariant(BlockState normalVariant) {
            for (InfestationTableEntry entry : this.entries) {
                if (entry.getNormalVariant() != normalVariant.m_60734_()) continue;
                return entry.getInfectedVariant();
            }
            return null;
        }

        public Block getNormalVariant(BlockState infectedVariant) {
            for (InfestationTableEntry entry : this.entries) {
                if (entry.getInfectedVariant() != infectedVariant) continue;
                return entry.getNormalVariant();
            }
            return null;
        }

        public boolean isNormalVariant(BlockState blockState) {
            if (blockState.m_204336_(BlockTags.f_13106_)) {
                return true;
            }
            for (InfestationTableEntry entry : this.entries) {
                if (entry.getNormalVariant() != blockState.m_60734_() || entry.getNormalVariant() == null) continue;
                return true;
            }
            return false;
        }

        public boolean isInfectedVariant(BlockState blockState) {
            if (blockState.m_60713_((Block)BlockRegistry.INFESTED_LOG.get())) {
                return true;
            }
            for (InfestationTableEntry entry : this.entries) {
                if (entry.getInfectedVariant() != blockState || entry.getInfectedVariant() == null) continue;
                return true;
            }
            return false;
        }
    }

    public class InfestationTableEntry {
        private Block normalVariant;
        private BlockState infectedVariant;

        public InfestationTableEntry(Block normalVariantIn, BlockState infectedVariantIn) {
            this.normalVariant = normalVariantIn;
            this.infectedVariant = infectedVariantIn;
        }

        public Block getNormalVariant() {
            return this.normalVariant;
        }

        public BlockState getInfectedVariant() {
            return this.infectedVariant;
        }
    }

    public class ConversionRequest {
        private BlockPos position;
        private boolean convertToInfested;
        private boolean convertToNormal;

        public ConversionRequest(BlockPos positionIn) {
            this.position = positionIn;
        }

        public BlockPos getPosition() {
            return this.position;
        }
    }
}

