/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.block;

import com.github.sculkhorde.common.blockentity.SculkNodeBlockEntity;
import com.github.sculkhorde.core.BlockEntityRegistry;
import com.github.sculkhorde.core.BlockRegistry;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.util.ChunkLoaderHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeBlock;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

public class SculkNodeBlock
extends BaseEntityBlock
implements IForgeBlock {
    public static Material MATERIAL = Material.f_76300_;
    public static MaterialColor MAP_COLOR = MaterialColor.f_76415_;
    public static float HARDNESS = 50.0f;
    public static float BLAST_RESISTANCE = 10.0f;

    public SculkNodeBlock(BlockBehaviour.Properties prop) {
        super(prop);
    }

    public SculkNodeBlock() {
        this(SculkNodeBlock.getProperties());
    }

    public static void FindAreaAndPlaceNode(ServerLevel level, BlockPos searchOrigin) {
        BlockPos newOrigin = new BlockPos(searchOrigin.m_123341_(), level.m_141937_() + 35, searchOrigin.m_123343_());
        level.m_46597_(newOrigin, ((SculkNodeBlock)((Object)BlockRegistry.SCULK_NODE_BLOCK.get())).m_49966_());
        SculkHorde.savedData.addNodeToMemory(newOrigin);
        EntityType.f_20465_.m_262496_(level, newOrigin, MobSpawnType.SPAWNER);
        level.m_6907_().forEach(player -> player.m_5661_((Component)Component.m_237113_((String)"A Sculk Node has spawned!"), true));
        level.m_6907_().forEach(player -> level.m_5594_(null, player.m_20183_(), SoundEvents.f_215781_, SoundSource.HOSTILE, 1.0f, 1.0f));
    }

    public void m_6402_(Level world, BlockPos bp, BlockState blockState, @javax.annotation.Nullable LivingEntity entity, ItemStack itemStack) {
        super.m_6402_(world, bp, blockState, entity, itemStack);
        if (!world.m_5776_() && world.equals(ServerLifecycleHooks.getCurrentServer().m_129783_())) {
            SculkHorde.savedData.addNodeToMemory(bp);
        }
    }

    public boolean m_6724_(BlockState blockState) {
        return false;
    }

    public static BlockBehaviour.Properties getProperties() {
        BlockBehaviour.Properties prop = BlockBehaviour.Properties.m_60944_((Material)MATERIAL, (MaterialColor)MAP_COLOR).m_60913_(HARDNESS, BLAST_RESISTANCE).m_60918_(SoundType.f_56740_);
        return prop;
    }

    public void m_6807_(BlockState state2, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        ChunkLoaderHelper.forceLoadChunksInRadius((ServerLevel)worldIn, pos, worldIn.m_46865_((BlockPos)pos).m_7697_().f_45578_, worldIn.m_46865_((BlockPos)pos).m_7697_().f_45579_, 15);
        if (worldIn.m_5776_()) {
            worldIn.m_5594_(null, pos, SoundEvents.f_11700_, SoundSource.BLOCKS, 1.0f, 1.0f);
            for (Player player : worldIn.m_6907_()) {
                player.m_5661_((Component)Component.m_237115_((String)"message.sculk_horde.node_placed"), true);
            }
        }
    }

    public void m_6810_(BlockState state2, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        ChunkLoaderHelper.unloadChunksInRadius((ServerLevel)worldIn, pos, worldIn.m_46865_((BlockPos)pos).m_7697_().f_45578_, worldIn.m_46865_((BlockPos)pos).m_7697_().f_45579_, 15);
        SculkHorde.savedData.resetTicksSinceSculkNodeDestruction();
        super.m_6810_(state2, worldIn, pos, newState, isMoving);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @javax.annotation.Nullable BlockGetter iBlockReader, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, iBlockReader, tooltip, flagIn);
        tooltip.add((Component)Component.m_237115_((String)"tooltip.sculkhorde.sculk_node"));
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return SculkNodeBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)BlockEntityRegistry.SCULK_NODE_BLOCK_ENTITY.get()), SculkNodeBlockEntity::tick);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState state2) {
        return new SculkNodeBlockEntity(blockPos, state2);
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }
}

