/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.block;

import com.github.sculkhorde.common.block.SculkFloraBlock;
import com.github.sculkhorde.core.EffectRegistry;
import com.github.sculkhorde.util.EntityAlgorithms;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeBlock;

public class SpikeBlock
extends SculkFloraBlock
implements IForgeBlock {
    public static Material MATERIAL = Material.f_76278_;
    public static MaterialColor MAP_COLOR = MaterialColor.f_76372_;
    public static float HARDNESS = 4.0f;
    public static float BLAST_RESISTANCE = 6.0f;
    public static int HARVEST_LEVEL = 3;
    public static int INFECT_DURATION = 500;
    public static int INFECT_LEVEL = 1;

    public SpikeBlock(BlockBehaviour.Properties prop) {
        super(prop);
    }

    public SpikeBlock() {
        this(SpikeBlock.getProperties());
    }

    public static BlockBehaviour.Properties getProperties() {
        return BlockBehaviour.Properties.m_60944_((Material)MATERIAL, (MaterialColor)MAP_COLOR).m_60913_(HARDNESS, BLAST_RESISTANCE).m_60999_().m_60918_(SoundType.f_56750_).m_60910_();
    }

    public void m_7892_(BlockState blockState, Level world, BlockPos blockPos, Entity entity) {
        if (!(entity instanceof LivingEntity) || world.f_46443_) {
            return;
        }
        if (EntityAlgorithms.isSculkLivingEntity.test((LivingEntity)entity)) {
            return;
        }
        entity.m_7601_(blockState, new Vec3((double)0.8f, 0.75, (double)0.8f));
        if (entity.f_19790_ != entity.m_20185_() || entity.f_19792_ != entity.m_20189_()) {
            double d0 = Math.abs(entity.m_20185_() - entity.f_19790_);
            double d1 = Math.abs(entity.m_20189_() - entity.f_19792_);
            if (d0 >= (double)0.003f || d1 >= (double)0.003f) {
                entity.m_6469_(entity.m_269291_().m_269264_(), 1.0f);
                ((LivingEntity)entity).m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.SCULK_INFECTION.get(), INFECT_DURATION, INFECT_LEVEL));
                world.m_46961_(blockPos, false);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter iBlockReader, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, iBlockReader, tooltip, flagIn);
        tooltip.add((Component)Component.m_237115_((String)"tooltip.sculkhorde.spike"));
    }
}

