/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.blockentity;

import com.github.sculkhorde.common.procedural.structures.ProceduralStructure;
import com.github.sculkhorde.common.procedural.structures.SculkNodeCaveHallwayProceduralStructure;
import com.github.sculkhorde.core.BlockEntityRegistry;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class DevStructureTesterBlockEntity
extends BlockEntity {
    private long tickedAt = System.nanoTime();
    private ProceduralStructure proceduralStructure;

    public DevStructureTesterBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)BlockEntityRegistry.DEV_STRUCTURE_TESTER_BLOCK_ENTITY.get(), blockPos, blockState);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, DevStructureTesterBlockEntity blockEntity) {
        long timeElapsed = TimeUnit.SECONDS.convert(System.nanoTime() - blockEntity.tickedAt, TimeUnit.NANOSECONDS);
        if (timeElapsed < 1L) {
            return;
        }
        blockEntity.tickedAt = System.nanoTime();
        if (blockEntity.proceduralStructure == null) {
            blockEntity.proceduralStructure = new SculkNodeCaveHallwayProceduralStructure((ServerLevel)level, blockPos, 5, 10, Direction.NORTH);
            blockEntity.proceduralStructure.generatePlan();
        }
        if (!blockEntity.proceduralStructure.isStructureComplete() && blockEntity.proceduralStructure.isCurrentlyBuilding()) {
            blockEntity.proceduralStructure.buildTick();
        }
        if (!blockEntity.proceduralStructure.isStructureComplete() && !blockEntity.proceduralStructure.isCurrentlyBuilding()) {
            blockEntity.proceduralStructure.startBuildProcedure();
        }
    }
}

