/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.blockentity;

import com.github.sculkhorde.common.block.SculkBeeNestBlock;
import com.github.sculkhorde.common.entity.SculkBeeHarvesterEntity;
import com.github.sculkhorde.common.entity.SculkBeeInfectorEntity;
import com.github.sculkhorde.common.entity.infection.CursorSurfaceInfectorEntity;
import com.github.sculkhorde.common.procedural.structures.SculkBeeNestProceduralStructure;
import com.github.sculkhorde.core.BlockEntityRegistry;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.util.TickUnits;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class SculkBeeNestBlockEntity
extends BlockEntity {
    public static final String TAG_FLOWER_POS = "FlowerPos";
    public static final String MIN_OCCUPATION_TICKS = "MinOccupationTicks";
    public static final String ENTITY_DATA = "EntityData";
    public static final String TICKS_IN_HIVE = "TicksInHive";
    public static final String HAS_NECTAR = "HasNectar";
    public static final String BEES = "Bees";
    private static final List<String> IGNORED_BEE_TAGS = Arrays.asList("Air", "ArmorDropChances", "ArmorItems", "Brain", "CanPickUpLoot", "DeathTime", "FallDistance", "FallFlying", "Fire", "HandDropChances", "HandItems", "HurtByTimestamp", "HurtTime", "LeftHanded", "Motion", "NoGravity", "OnGround", "PortalCooldown", "Pos", "Rotation", "CannotEnterHiveTicks", "TicksSincePollination", "CropsGrownSincePollination", "HivePos", "Passengers", "Leash", "UUID");
    public static final int MAX_OCCUPANTS = 4;
    private static final int MIN_TICKS_BEFORE_REENTERING_HIVE = 400;
    private static final int MIN_OCCUPATION_TICKS_NECTAR = 2400;
    public static final int MIN_OCCUPATION_TICKS_NECTARLESS = 600;
    private final List<BeeData> stored = Lists.newArrayList();
    @Nullable
    private BlockPos savedFlowerPos;
    private SculkBeeNestProceduralStructure beeNestStructure;
    private int tickTracker = 0;
    private long lastTimeSinceRepair = -1L;

    public SculkBeeNestBlockEntity(BlockPos p_155134_, BlockState p_155135_) {
        super((BlockEntityType)BlockEntityRegistry.SCULK_BEE_NEST_BLOCK_ENTITY.get(), p_155134_, p_155135_);
    }

    public void m_6596_() {
        if (this.isFireNearby()) {
            this.emptyAllLivingFromHive(null, this.f_58857_.m_8055_(this.m_58899_()), BeeReleaseStatus.EMERGENCY);
        }
        super.m_6596_();
    }

    public boolean isFireNearby() {
        if (this.f_58857_ == null) {
            return false;
        }
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)this.f_58858_.m_7918_(-1, -1, -1), (BlockPos)this.f_58858_.m_7918_(1, 1, 1))) {
            if (!(this.f_58857_.m_8055_(blockpos).m_60734_() instanceof FireBlock)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.stored.isEmpty();
    }

    public boolean isFull() {
        return this.stored.size() == 4;
    }

    public void emptyAllLivingFromHive(@Nullable Player p_58749_, BlockState p_58750_, BeeReleaseStatus p_58751_) {
        List<Entity> list = this.releaseAllOccupants(p_58750_, p_58751_);
        if (p_58749_ != null) {
            for (Entity entity : list) {
                if (!(entity instanceof Bee)) continue;
                Bee bee = (Bee)entity;
                if (!(p_58749_.m_20182_().m_82557_(entity.m_20182_()) <= 16.0)) continue;
                if (!this.isSedated()) {
                    bee.m_6710_((LivingEntity)p_58749_);
                    continue;
                }
                bee.m_27915_(400);
            }
        }
    }

    private List<Entity> releaseAllOccupants(BlockState p_58760_, BeeReleaseStatus p_58761_) {
        ArrayList list = Lists.newArrayList();
        this.stored.removeIf(p_272556_ -> SculkBeeNestBlockEntity.releaseOccupant(this.f_58857_, this.f_58858_, p_58760_, p_272556_, list, p_58761_, this.savedFlowerPos));
        if (!list.isEmpty()) {
            super.m_6596_();
        }
        return list;
    }

    public void addFreshHarvesterOccupant() {
        this.addOccupantWithPresetTicks((Entity)new SculkBeeHarvesterEntity(this.f_58857_), false, 0);
    }

    public void addFreshInfectorOccupant() {
        this.addOccupantWithPresetTicks((Entity)new SculkBeeInfectorEntity(this.f_58857_), false, 0);
    }

    public void addOccupant(Entity entity, boolean hasNectar) {
        this.addOccupantWithPresetTicks(entity, hasNectar, 0);
    }

    @VisibleForDebug
    public int getOccupantCount() {
        return this.stored.size();
    }

    public static int getHoneyLevel(BlockState p_58753_) {
        return (Integer)p_58753_.m_61143_((Property)BeehiveBlock.f_49564_);
    }

    @VisibleForDebug
    public boolean isSedated() {
        return CampfireBlock.m_51248_((Level)this.f_58857_, (BlockPos)this.m_58899_());
    }

    public void addOccupantWithPresetTicks(Entity entity, boolean hasNectar, int ticks) {
        if (this.stored.size() < 4) {
            entity.m_8127_();
            entity.m_20153_();
            CompoundTag compoundtag = new CompoundTag();
            entity.m_20223_(compoundtag);
            this.storeBee(compoundtag, ticks, hasNectar);
            if (this.f_58857_ != null) {
                Bee bee;
                if (entity instanceof Bee && (bee = (Bee)entity).m_27852_() && (!this.hasSavedFlowerPos() || this.f_58857_.f_46441_.m_188499_())) {
                    this.savedFlowerPos = bee.m_27851_();
                }
                BlockPos blockpos = this.m_58899_();
                this.f_58857_.m_6263_((Player)null, (double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), SoundEvents.f_11695_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.f_58857_.m_220407_(GameEvent.f_157792_, blockpos, GameEvent.Context.m_223719_((Entity)entity, (BlockState)this.m_58900_()));
                SculkHorde.savedData.addSculkAccumulatedMass(5);
                CursorSurfaceInfectorEntity cursor = new CursorSurfaceInfectorEntity(this.f_58857_);
                cursor.m_6034_(blockpos.m_123341_(), blockpos.m_123342_() - 1, blockpos.m_123343_());
                cursor.setMaxInfections(100);
                cursor.setMaxRange(100);
                cursor.setTickIntervalMilliseconds(500L);
                cursor.setSearchIterationsPerTick(10);
                this.f_58857_.m_7967_((Entity)cursor);
            }
            entity.m_146870_();
            super.m_6596_();
        }
    }

    public void storeBee(CompoundTag p_155158_, int p_155159_, boolean p_155160_) {
        this.stored.add(new BeeData(p_155158_, p_155159_, p_155160_ ? 2400 : 600));
    }

    private static boolean releaseOccupant(Level level, BlockPos blockPos, BlockState blockState, BeeData beeData, @Nullable List<Entity> entities, BeeReleaseStatus beeReleaseStatus, @Nullable BlockPos blockPos1) {
        boolean flag;
        if (beeReleaseStatus == BeeReleaseStatus.EMERGENCY) {
            return false;
        }
        CompoundTag compoundtag = beeData.entityData.m_6426_();
        SculkBeeNestBlockEntity.removeIgnoredBeeTags(compoundtag);
        compoundtag.m_128365_("HivePos", (Tag)NbtUtils.m_129224_((BlockPos)blockPos));
        compoundtag.m_128379_("NoGravity", true);
        Direction direction = (Direction)blockState.m_61143_((Property)BeehiveBlock.f_49563_);
        BlockPos blockpos = blockPos.m_121945_(direction);
        boolean bl = flag = !level.m_8055_(blockpos).m_60812_((BlockGetter)level, blockpos).m_83281_();
        if (flag && beeReleaseStatus != BeeReleaseStatus.EMERGENCY) {
            return false;
        }
        Entity entity = EntityType.m_20645_((CompoundTag)compoundtag, (Level)level, p_58740_ -> p_58740_);
        if (entity == null || ((Boolean)blockState.m_61143_((Property)SculkBeeNestBlock.CLOSED)).booleanValue()) {
            return false;
        }
        if (!(entity instanceof SculkBeeHarvesterEntity)) {
            return false;
        }
        SculkBeeHarvesterEntity bee = (SculkBeeHarvesterEntity)entity;
        if (blockPos1 != null && !bee.hasSavedFlowerPos() && level.f_46441_.m_188501_() < 0.9f) {
            bee.setSavedFlowerPos(blockPos1);
        }
        if (beeReleaseStatus == BeeReleaseStatus.HONEY_DELIVERED) {
            int i;
            bee.dropOffNectar();
            if (blockState.m_204338_(BlockTags.f_13072_, p_202037_ -> p_202037_.m_61138_((Property)BeehiveBlock.f_49564_)) && (i = SculkBeeNestBlockEntity.getHoneyLevel(blockState)) < 5) {
                int j;
                int n = j = level.f_46441_.m_188503_(100) == 0 ? 2 : 1;
                if (i + j > 5) {
                    --j;
                }
                level.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)BeehiveBlock.f_49564_, (Comparable)Integer.valueOf(i + j)));
            }
        }
        SculkBeeNestBlockEntity.setBeeReleaseData(beeData.ticksInHive, bee);
        if (entities != null) {
            entities.add((Entity)bee);
        }
        float f = entity.m_20205_();
        double d3 = flag ? 0.0 : 0.55 + (double)(f / 2.0f);
        double d0 = (double)blockPos.m_123341_() + 0.5 + d3 * (double)direction.m_122429_();
        double d1 = (double)blockPos.m_123342_() + 0.5 - (double)(entity.m_20206_() / 2.0f);
        double d2 = (double)blockPos.m_123343_() + 0.5 + d3 * (double)direction.m_122431_();
        entity.m_7678_(d0, d1, d2, entity.m_146908_(), entity.m_146909_());
        level.m_5594_((Player)null, blockPos, SoundEvents.f_11696_, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.m_220407_(GameEvent.f_157792_, blockPos, GameEvent.Context.m_223719_((Entity)entity, (BlockState)level.m_8055_(blockPos)));
        return level.m_7967_(entity);
    }

    static void removeIgnoredBeeTags(CompoundTag p_155162_) {
        for (String s : IGNORED_BEE_TAGS) {
            p_155162_.m_128473_(s);
        }
    }

    private static void setBeeReleaseData(int p_58737_, SculkBeeHarvesterEntity p_58738_) {
    }

    private boolean hasSavedFlowerPos() {
        return this.savedFlowerPos != null;
    }

    private static void tickOccupants(Level p_155150_, BlockPos p_155151_, BlockState p_155152_, List<BeeData> p_155153_, @Nullable BlockPos p_155154_) {
        boolean flag = false;
        Iterator<BeeData> iterator = p_155153_.iterator();
        while (iterator.hasNext()) {
            BeeData beehiveblockentity$beedata = iterator.next();
            if (beehiveblockentity$beedata.ticksInHive > beehiveblockentity$beedata.minOccupationTicks) {
                BeeReleaseStatus beehiveblockentity$beereleasestatus;
                BeeReleaseStatus beeReleaseStatus = beehiveblockentity$beereleasestatus = beehiveblockentity$beedata.entityData.m_128471_(HAS_NECTAR) ? BeeReleaseStatus.HONEY_DELIVERED : BeeReleaseStatus.BEE_RELEASED;
                if (SculkBeeNestBlockEntity.releaseOccupant(p_155150_, p_155151_, p_155152_, beehiveblockentity$beedata, null, beehiveblockentity$beereleasestatus, p_155154_)) {
                    flag = true;
                    iterator.remove();
                }
            }
            ++beehiveblockentity$beedata.ticksInHive;
        }
        if (flag) {
            SculkBeeNestBlockEntity.m_155232_((Level)p_155150_, (BlockPos)p_155151_, (BlockState)p_155152_);
        }
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState p_155147_, SculkBeeNestBlockEntity blockEntity) {
        SculkBeeNestBlockEntity.tickOccupants(level, blockPos, p_155147_, blockEntity.stored, blockEntity.savedFlowerPos);
        if (!blockEntity.stored.isEmpty() && level.m_213780_().m_188500_() < 0.005) {
            double d0 = (double)blockPos.m_123341_() + 0.5;
            double d1 = blockPos.m_123342_();
            double d2 = (double)blockPos.m_123343_() + 0.5;
            level.m_6263_((Player)null, d0, d1, d2, SoundEvents.f_11698_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        ++blockEntity.tickTracker;
        if (blockEntity.tickTracker < TickUnits.convertMinutesToTicks(1)) {
            return;
        }
        blockEntity.tickTracker = 0;
        long timeElapsed = TimeUnit.MINUTES.convert(System.nanoTime() - blockEntity.lastTimeSinceRepair, TimeUnit.NANOSECONDS);
        if (blockEntity.beeNestStructure == null) {
            blockEntity.beeNestStructure = new SculkBeeNestProceduralStructure((ServerLevel)level, blockPos);
            blockEntity.beeNestStructure.generatePlan();
        }
        long repairIntervalInMinutes = 30L;
        if (blockEntity.beeNestStructure.isCurrentlyBuilding()) {
            blockEntity.beeNestStructure.buildTick();
            blockEntity.lastTimeSinceRepair = System.nanoTime();
        } else if ((timeElapsed >= repairIntervalInMinutes || blockEntity.lastTimeSinceRepair == -1L) && blockEntity.beeNestStructure.canStartToBuild()) {
            blockEntity.beeNestStructure.startBuildProcedure();
        }
    }

    public void m_142466_(CompoundTag p_155156_) {
        super.m_142466_(p_155156_);
        this.stored.clear();
        ListTag listtag = p_155156_.m_128437_(BEES, 10);
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.m_128728_(i);
            BeeData beehiveblockentity$beedata = new BeeData(compoundtag.m_128469_(ENTITY_DATA), compoundtag.m_128451_(TICKS_IN_HIVE), compoundtag.m_128451_(MIN_OCCUPATION_TICKS));
            this.stored.add(beehiveblockentity$beedata);
        }
        this.savedFlowerPos = null;
        if (p_155156_.m_128441_(TAG_FLOWER_POS)) {
            this.savedFlowerPos = NbtUtils.m_129239_((CompoundTag)p_155156_.m_128469_(TAG_FLOWER_POS));
        }
    }

    protected void m_183515_(CompoundTag p_187467_) {
        super.m_183515_(p_187467_);
        p_187467_.m_128365_(BEES, (Tag)this.writeBees());
        if (this.hasSavedFlowerPos()) {
            p_187467_.m_128365_(TAG_FLOWER_POS, (Tag)NbtUtils.m_129224_((BlockPos)this.savedFlowerPos));
        }
    }

    public ListTag writeBees() {
        ListTag listtag = new ListTag();
        for (BeeData beehiveblockentity$beedata : this.stored) {
            CompoundTag compoundtag = beehiveblockentity$beedata.entityData.m_6426_();
            compoundtag.m_128473_("UUID");
            CompoundTag compoundtag1 = new CompoundTag();
            compoundtag1.m_128365_(ENTITY_DATA, (Tag)compoundtag);
            compoundtag1.m_128405_(TICKS_IN_HIVE, beehiveblockentity$beedata.ticksInHive);
            compoundtag1.m_128405_(MIN_OCCUPATION_TICKS, beehiveblockentity$beedata.minOccupationTicks);
            listtag.add((Object)compoundtag1);
        }
        return listtag;
    }

    public static enum BeeReleaseStatus {
        HONEY_DELIVERED,
        BEE_RELEASED,
        EMERGENCY;

    }

    static class BeeData {
        final CompoundTag entityData;
        int ticksInHive;
        final int minOccupationTicks;

        BeeData(CompoundTag p_58786_, int p_58787_, int p_58788_) {
            SculkBeeNestBlockEntity.removeIgnoredBeeTags(p_58786_);
            this.entityData = p_58786_;
            this.ticksInHive = p_58787_;
            this.minOccupationTicks = p_58788_;
        }
    }
}

