/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.blockentity;

import com.github.sculkhorde.common.procedural.structures.SculkLivingRockProceduralStructure;
import com.github.sculkhorde.core.BlockEntityRegistry;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class SculkLivingRockRootBlockEntity
extends BlockEntity {
    private long tickedAt = System.nanoTime();
    private SculkLivingRockProceduralStructure proceduralStructure;
    private final long repairIntervalInMinutes = 60L;
    private long lastTimeSinceRepair = -1L;

    public SculkLivingRockRootBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)BlockEntityRegistry.SCULK_LIVING_ROCK_ROOT_BLOCK_ENTITY.get(), blockPos, blockState);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, SculkLivingRockRootBlockEntity blockEntity) {
        long timeElapsed = TimeUnit.SECONDS.convert(System.nanoTime() - blockEntity.tickedAt, TimeUnit.NANOSECONDS);
        if ((double)timeElapsed < 0.1) {
            return;
        }
        blockEntity.tickedAt = System.nanoTime();
        long repairTimeElapsed = TimeUnit.MINUTES.convert(System.nanoTime() - blockEntity.lastTimeSinceRepair, TimeUnit.NANOSECONDS);
        if (blockEntity.proceduralStructure == null) {
            blockEntity.proceduralStructure = new SculkLivingRockProceduralStructure((ServerLevel)level, blockPos);
            blockEntity.proceduralStructure.generatePlan();
        }
        if (blockEntity.proceduralStructure.isCurrentlyBuilding()) {
            blockEntity.proceduralStructure.buildTick();
            blockEntity.lastTimeSinceRepair = System.nanoTime();
        } else if (repairTimeElapsed >= blockEntity.repairIntervalInMinutes || blockEntity.lastTimeSinceRepair == -1L) {
            blockEntity.proceduralStructure.startBuildProcedure();
        }
    }
}

