/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.blockentity;

import com.github.sculkhorde.common.entity.infection.CursorSurfaceInfectorEntity;
import com.github.sculkhorde.core.BlockEntityRegistry;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.core.gravemind.entity_factory.EntityFactory;
import com.github.sculkhorde.core.gravemind.entity_factory.ReinforcementRequest;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class SculkMassBlockEntity
extends BlockEntity {
    private int storedSculkMass = 0;
    private String storedSculkMassIdentifier = "storedSculkMass";

    public SculkMassBlockEntity(BlockPos pos, BlockState state2) {
        super((BlockEntityType)BlockEntityRegistry.SCULK_MASS_BLOCK_ENTITY.get(), pos, state2);
    }

    public void m_142466_(CompoundTag compoundNBT) {
        super.m_142466_(compoundNBT);
        this.storedSculkMass = compoundNBT.m_128451_(this.storedSculkMassIdentifier);
    }

    public void m_183515_(CompoundTag compoundNBT) {
        compoundNBT.m_128405_(this.storedSculkMassIdentifier, this.storedSculkMass);
        super.m_183515_(compoundNBT);
    }

    public int getStoredSculkMass() {
        return this.storedSculkMass;
    }

    public void setStoredSculkMass(int value) {
        this.storedSculkMass = value;
    }

    public void addStoredSculkMass(int value) {
        this.storedSculkMass += value;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, SculkMassBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        if (level.m_46467_() % 100L != 0L) {
            return;
        }
        if (!(blockEntity instanceof SculkMassBlockEntity)) {
            return;
        }
        if (blockEntity.getStoredSculkMass() <= 0) {
            level.m_46961_(blockPos, false);
        }
        EntityFactory entityFactory = SculkHorde.entityFactory;
        ReinforcementRequest context = new ReinforcementRequest(blockPos);
        context.sender = ReinforcementRequest.senderType.SculkMass;
        context.budget = blockEntity.getStoredSculkMass();
        entityFactory.requestReinforcementSculkMass(level, blockPos, context);
        if (context.isRequestViewed && context.isRequestApproved) {
            blockEntity.setStoredSculkMass(context.remaining_balance);
            CursorSurfaceInfectorEntity cursor = new CursorSurfaceInfectorEntity(level);
            cursor.m_6034_(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
            cursor.setMaxInfections(blockEntity.getStoredSculkMass());
            cursor.setMaxRange(blockEntity.getStoredSculkMass() / 4);
            level.m_7967_((Entity)cursor);
        }
    }
}

