/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.blockentity;

import com.github.sculkhorde.common.entity.infection.SculkNodeInfectionHandler;
import com.github.sculkhorde.common.procedural.structures.SculkNodeProceduralStructure;
import com.github.sculkhorde.core.BlockEntityRegistry;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class SculkNodeBlockEntity
extends BlockEntity {
    private long tickedAt = System.nanoTime();
    private SculkNodeProceduralStructure nodeProceduralStructure;
    private final long repairIntervalInMinutes = 60L;
    private long lastTimeSinceRepair = -1L;
    public static final int tickIntervalSeconds = 1;
    private SculkNodeInfectionHandler infectionHandler;
    private long heartBeatDelayMillis = TimeUnit.SECONDS.toMillis(10L);
    private long lastHeartBeat = System.currentTimeMillis();

    public SculkNodeBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)BlockEntityRegistry.SCULK_NODE_BLOCK_ENTITY.get(), blockPos, blockState);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, SculkNodeBlockEntity blockEntity) {
        if (level.f_46443_) {
            if (System.currentTimeMillis() - blockEntity.lastHeartBeat > blockEntity.heartBeatDelayMillis) {
                blockEntity.lastHeartBeat = System.currentTimeMillis();
                level.m_7785_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), SoundEvents.f_215762_, SoundSource.BLOCKS, 5.0f, 1.0f, false);
            }
            return;
        }
        long timeElapsed = TimeUnit.SECONDS.convert(System.nanoTime() - blockEntity.tickedAt, TimeUnit.NANOSECONDS);
        if (timeElapsed < 1L) {
            return;
        }
        blockEntity.tickedAt = System.nanoTime();
        long repairTimeElapsed = TimeUnit.MINUTES.convert(System.nanoTime() - blockEntity.lastTimeSinceRepair, TimeUnit.NANOSECONDS);
        if (blockEntity.nodeProceduralStructure == null) {
            blockEntity.nodeProceduralStructure = new SculkNodeProceduralStructure((ServerLevel)level, blockPos);
            blockEntity.nodeProceduralStructure.generatePlan();
        }
        if (blockEntity.nodeProceduralStructure.isCurrentlyBuilding()) {
            blockEntity.nodeProceduralStructure.buildTick();
            blockEntity.lastTimeSinceRepair = System.nanoTime();
        } else if ((repairTimeElapsed >= blockEntity.repairIntervalInMinutes || blockEntity.lastTimeSinceRepair == -1L) && blockEntity.nodeProceduralStructure.canStartToBuild()) {
            blockEntity.nodeProceduralStructure.startBuildProcedure();
        }
        if (blockEntity.infectionHandler == null) {
            blockEntity.infectionHandler = new SculkNodeInfectionHandler(blockEntity);
        } else {
            blockEntity.infectionHandler.tick();
        }
    }
}

