/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.blockentity;

import com.github.sculkhorde.common.block.SculkSummonerBlock;
import com.github.sculkhorde.core.BlockEntityRegistry;
import com.github.sculkhorde.core.BlockRegistry;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.core.gravemind.entity_factory.ReinforcementRequest;
import com.github.sculkhorde.util.EntityAlgorithms;
import com.github.sculkhorde.util.TargetParameters;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationListener;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import org.slf4j.Logger;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SculkSummonerBlockEntity
extends BlockEntity
implements VibrationListener.VibrationListenerConfig,
GeoBlockEntity {
    AABB searchArea;
    private final int ACTIVATION_DISTANCE = 32;
    private List<LivingEntity> possibleLivingEntityTargets;
    private List<LivingEntity> possibleAggressorTargets;
    private long lastTimeOfSpawn = System.currentTimeMillis();
    private long timeElapsedSinceSpawn = 0L;
    private final long spawningCoolDownMilis = TimeUnit.SECONDS.toMillis(20L);
    private final int MAX_SPAWNED_ENTITIES = 4;
    ReinforcementRequest request;
    private final TargetParameters hostileTargetParameters = new TargetParameters().enableTargetHostiles().enableTargetInfected();
    private final TargetParameters infectableTargetParameters = new TargetParameters().enableTargetPassives();
    private VibrationListener listener = new VibrationListener((PositionSource)new BlockPositionSource(this.f_58858_), 8, (VibrationListener.VibrationListenerConfig)this);
    private final int STATE_COOLDOWN_VALUE = 0;
    private final int STATE_READY_TO_SPAWN_VALUE = 1;
    private final int STATE_SPAWNING_VALUE = 2;
    private final Predicate<BlockPos> VALID_SPAWN_BLOCKS = blockPos -> this.isValidSpawnPosition((ServerLevel)this.f_58857_, (BlockPos)blockPos);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation SCULK_SUMMONER_COOLDOWN_ANIMATION = RawAnimation.begin().thenPlayAndHold("cooldown");
    private static final RawAnimation SCULK_SUMMONER_READY_ANIMATION = RawAnimation.begin().thenPlay("powerup").thenLoop("idle");

    public SculkSummonerBlockEntity(BlockPos blockPos2, BlockState blockState) {
        super((BlockEntityType)BlockEntityRegistry.SCULK_SUMMONER_BLOCK_ENTITY.get(), blockPos2, blockState);
        this.searchArea = EntityAlgorithms.getSearchAreaRectangle(this.m_58899_().m_123341_(), this.m_58899_().m_123342_(), this.m_58899_().m_123343_(), 32.0, 5.0, 32.0);
        this.possibleLivingEntityTargets = new ArrayList<LivingEntity>();
        this.possibleAggressorTargets = new ArrayList<LivingEntity>();
    }

    private boolean isOnCooldown() {
        return this.getState() == 0;
    }

    private void setToCooldown() {
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)SculkSummonerBlock.STATE, (Comparable)Integer.valueOf(0)));
    }

    private boolean isReadyToSpawn() {
        return this.getState() == 1;
    }

    private void setReadyToSpawn() {
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)SculkSummonerBlock.STATE, (Comparable)Integer.valueOf(1)));
    }

    private boolean isSpawning() {
        return this.getState() == 2;
    }

    private void setSpawning() {
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)SculkSummonerBlock.STATE, (Comparable)Integer.valueOf(2)));
    }

    public int getState() {
        return (Integer)this.m_58900_().m_61143_((Property)SculkSummonerBlock.STATE);
    }

    public boolean hasSpawningCoolDownEnded() {
        return this.timeElapsedSinceSpawn >= this.spawningCoolDownMilis;
    }

    private boolean areAllReinforcementsDead() {
        if (this.request == null) {
            return true;
        }
        for (LivingEntity entity : this.request.spawnedEntities) {
            if (entity == null || !entity.m_6084_()) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void spawnReinforcementsTick(Level level, BlockPos blockPos, BlockState blockState, SculkSummonerBlockEntity blockEntity) {
        if (level == null || level.f_46443_) {
            return;
        }
        blockEntity.timeElapsedSinceSpawn = System.currentTimeMillis() - blockEntity.lastTimeOfSpawn;
        if (blockEntity.isOnCooldown()) {
            if (!blockEntity.hasSpawningCoolDownEnded()) return;
            blockEntity.setReadyToSpawn();
            return;
        } else if (blockEntity.isReadyToSpawn()) {
            if (!blockEntity.areAllReinforcementsDead()) {
                return;
            }
            blockEntity.searchArea = EntityAlgorithms.getSearchAreaRectangle(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_(), blockEntity.ACTIVATION_DISTANCE, 5.0, blockEntity.ACTIVATION_DISTANCE);
            blockEntity.possibleAggressorTargets = blockEntity.f_58857_.m_6443_(LivingEntity.class, blockEntity.searchArea, blockEntity.hostileTargetParameters.isPossibleNewTargetValid);
            blockEntity.possibleLivingEntityTargets = blockEntity.f_58857_.m_6443_(LivingEntity.class, blockEntity.searchArea, blockEntity.infectableTargetParameters.isPossibleNewTargetValid);
            if (blockEntity.possibleAggressorTargets.size() == 0 && blockEntity.possibleLivingEntityTargets.size() == 0) {
                return;
            }
            blockEntity.setSpawning();
            return;
        } else {
            if (!blockEntity.isSpawning()) return;
            ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_235898_, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 1.15, (double)blockPos.m_123343_() + 0.5, 2, 0.2, 0.0, 0.2, 0.0);
            ((ServerLevel)level).m_5594_((Player)null, blockPos, SoundEvents.f_215740_, SoundSource.BLOCKS, 2.0f, 1.6f);
            ArrayList<BlockPos> possibleSpawnPositions = blockEntity.getSpawnPositionsInCube((ServerLevel)level, blockEntity.m_58899_(), 5, blockEntity.MAX_SPAWNED_ENTITIES);
            BlockPos[] finalizedSpawnPositions = new BlockPos[blockEntity.MAX_SPAWNED_ENTITIES];
            for (int iterations = 0; iterations < possibleSpawnPositions.size(); ++iterations) {
                finalizedSpawnPositions[iterations] = possibleSpawnPositions.isEmpty() ? blockEntity.m_58899_().m_7494_() : possibleSpawnPositions.get(iterations);
            }
            blockEntity.request = new ReinforcementRequest(finalizedSpawnPositions);
            blockEntity.request.sender = ReinforcementRequest.senderType.SculkCocoon;
            if (blockEntity.possibleAggressorTargets.size() != 0) {
                blockEntity.request.is_aggressor_nearby = true;
                blockEntity.lastTimeOfSpawn = System.currentTimeMillis();
            }
            if (blockEntity.possibleLivingEntityTargets.size() != 0) {
                blockEntity.request.is_non_sculk_mob_nearby = true;
                blockEntity.lastTimeOfSpawn = System.currentTimeMillis();
            }
            if (blockEntity.request.is_non_sculk_mob_nearby || blockEntity.request.is_aggressor_nearby) {
                SculkHorde.entityFactory.createReinforcementRequestFromSummoner(level, blockPos, false, blockEntity.request);
            }
            blockEntity.setToCooldown();
        }
    }

    public ArrayList<BlockPos> getSpawnPositionsInCube(ServerLevel worldIn, BlockPos origin, int length, int amountOfPositions) {
        ArrayList<BlockPos> listOfPossibleSpawns = SculkSummonerBlockEntity.getSpawnPositions(worldIn, origin, this.VALID_SPAWN_BLOCKS, length);
        ArrayList<BlockPos> finalList = new ArrayList<BlockPos>();
        Random rng = new Random();
        for (int count = 0; count < amountOfPositions && listOfPossibleSpawns.size() > 0; ++count) {
            int randomIndex = rng.nextInt(listOfPossibleSpawns.size());
            finalList.add(listOfPossibleSpawns.get(randomIndex));
            listOfPossibleSpawns.remove(randomIndex);
        }
        return finalList;
    }

    public boolean isValidSpawnPosition(ServerLevel worldIn, BlockPos pos) {
        return SculkHorde.infestationConversionTable.infestationTable.isInfectedVariant(worldIn.m_8055_(pos.m_7495_())) && worldIn.m_8055_(pos).m_60722_((Fluid)Fluids.f_76193_) && worldIn.m_8055_(pos.m_7494_()).m_60722_((Fluid)Fluids.f_76193_);
    }

    public static ArrayList<BlockPos> getSpawnPositions(ServerLevel worldIn, BlockPos origin, Predicate<BlockPos> predicateIn, double pDistance) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        int i = 0;
        while ((double)i <= pDistance) {
            int j = 0;
            while ((double)j < pDistance) {
                int k = 0;
                while (k <= j) {
                    int l;
                    int n = l = k < j && k > -j ? j : 0;
                    while (l <= j) {
                        BlockPos temp = new BlockPos(origin.m_123341_() + k, origin.m_123342_() + i - 1, origin.m_123343_() + l);
                        if (origin.m_123314_((Vec3i)temp, pDistance) && predicateIn.test(temp)) {
                            list.add(temp);
                        }
                        l = l > 0 ? -l : 1 - l;
                    }
                    k = k > 0 ? -k : 1 - k;
                }
                ++j;
            }
            i = i > 0 ? -i : 1 - i;
        }
        return list;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128425_("listener", 10)) {
            VibrationListener.m_223781_((VibrationListener.VibrationListenerConfig)this).parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)nbt.m_128469_("listener"))).resultOrPartial(arg_0 -> ((Logger)SculkHorde.LOGGER).error(arg_0)).ifPresent(p_222864_ -> {
                this.listener = p_222864_;
            });
        }
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        VibrationListener.m_223781_((VibrationListener.VibrationListenerConfig)this).encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.listener).resultOrPartial(arg_0 -> ((Logger)SculkHorde.LOGGER).error(arg_0)).ifPresent(p_222871_ -> nbt.m_128365_("listener", p_222871_));
    }

    public TagKey<GameEvent> m_213929_() {
        return GameEventTags.f_215854_;
    }

    public void m_213991_(ServerLevel level, GameEventListener gameEventListener, BlockPos blockPos, GameEvent gameEvent, @Nullable Entity entity, @Nullable Entity entity1, float strenth) {
        SculkSummonerBlockEntity.spawnReinforcementsTick((Level)level, blockPos, this.m_58900_(), this);
        if (!this.isOnCooldown()) {
            level.m_46796_(3007, this.f_58858_, 0);
            level.m_220407_(GameEvent.f_223701_, this.f_58858_, GameEvent.Context.m_223717_((Entity)entity));
        }
    }

    public VibrationListener getListener() {
        return this.listener;
    }

    public boolean m_213641_(ServerLevel p_222856_, GameEventListener p_222857_, BlockPos p_222858_, GameEvent p_222859_, GameEvent.Context p_222860_) {
        return true;
    }

    public void m_214037_() {
        this.m_6596_();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, state2 -> {
            BlockState blockState = ((SculkSummonerBlockEntity)state2.getAnimatable()).m_58904_().m_8055_(((SculkSummonerBlockEntity)state2.getAnimatable()).f_58858_);
            if (blockState.m_60713_((Block)BlockRegistry.SCULK_SUMMONER_BLOCK.get())) {
                if ((Integer)((SculkSummonerBlockEntity)state2.getAnimatable()).m_58904_().m_8055_(((SculkSummonerBlockEntity)state2.getAnimatable()).f_58858_).m_61143_((Property)SculkSummonerBlock.STATE) == 0) {
                    return state2.setAndContinue(SCULK_SUMMONER_COOLDOWN_ANIMATION);
                }
                return state2.setAndContinue(SCULK_SUMMONER_READY_ANIMATION);
            }
            return state2.setAndContinue(SCULK_SUMMONER_READY_ANIMATION);
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

