/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity;

import com.github.sculkhorde.common.blockentity.SculkBeeNestBlockEntity;
import com.github.sculkhorde.core.BlockRegistry;
import com.github.sculkhorde.core.EntityRegistry;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.util.BlockAlgorithms;
import com.github.sculkhorde.util.TickUnits;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SculkBeeHarvesterEntity
extends Monster
implements GeoEntity,
FlyingAnimal {
    public static final float MAX_HEALTH = 20.0f;
    public static final float FOLLOW_RANGE = 25.0f;
    public static final float MOVEMENT_SPEED = 0.25f;
    protected final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final float FLAP_DEGREES_PER_TICK = 120.32113f;
    public static final int TICKS_PER_FLAP = Mth.m_14167_((float)1.4959966f);
    public static final String TAG_CROPS_GROWN_SINCE_POLLINATION = "CropsGrownSincePollination";
    public static final String TAG_CANNOT_ENTER_HIVE_TICKS = "CannotEnterHiveTicks";
    public static final String TAG_TICKS_SINCE_POLLINATION = "TicksSincePollination";
    public static final String TAG_HAS_STUNG = "HasStung";
    public static final String TAG_HAS_NECTAR = "HasNectar";
    public static final String TAG_FLOWER_POS = "FlowerPos";
    public static final String TAG_HIVE_POS = "HivePos";
    protected int timeWithoutHive;
    protected boolean hasHiveInRange;
    protected int disruptorInRange;
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(Bee.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final int FLAG_ROLL = 2;
    protected static final int FLAG_HAS_STUNG = 4;
    protected static final int FLAG_HAS_NECTAR = 8;
    protected static final int STING_DEATH_COUNTDOWN = 1200;
    protected static final int TICKS_BEFORE_GOING_TO_KNOWN_FLOWER = 2400;
    protected static final int TICKS_WITHOUT_NECTAR_BEFORE_GOING_HOME = 3600;
    protected static final int MIN_ATTACK_DIST = 4;
    protected static final int MAX_CROPS_GROWABLE = 10;
    protected static final int POISON_SECONDS_NORMAL = 10;
    protected static final int POISON_SECONDS_HARD = 18;
    protected static final int TOO_FAR_DISTANCE = 64;
    protected static final int HIVE_CLOSE_ENOUGH_DISTANCE = 2;
    protected static final int PATHFIND_TO_HIVE_WHEN_CLOSER_THAN = 16;
    protected static final int HIVE_SEARCH_DISTANCE = 20;
    protected float rollAmount;
    protected float rollAmountO;
    protected int timeSinceSting;
    int ticksWithoutNectarSinceExitingHive;
    protected int numCropsGrownSincePollination;
    protected static final int COOLDOWN_BEFORE_LOCATING_NEW_HIVE = 200;
    int remainingCooldownBeforeLocatingNewHive;
    protected static final int COOLDOWN_BEFORE_LOCATING_NEW_FLOWER = 200;
    int remainingCooldownBeforeLocatingNewFlower = Mth.m_216271_((RandomSource)this.f_19796_, (int)20, (int)60);
    @Nullable
    BlockPos savedFlowerPos;
    @Nullable
    BlockPos hivePos;
    BeePollinateGoal beePollinateGoal;
    BeeGoToHiveGoal goToHiveGoal;
    protected BeeGoToKnownFlowerGoal goToKnownFlowerGoal;
    protected int underWaterTicks;
    protected int failedFlowerFindAttempts = 0;
    private final Predicate<BlockPos> IS_VALID_FLOWER = blockPos -> {
        BlockState blockState = this.f_19853_.m_8055_(blockPos);
        if (blockState.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            return false;
        }
        return blockState.m_60713_((Block)BlockRegistry.SMALL_SHROOM.get());
    };

    public SculkBeeHarvesterEntity(EntityType<? extends SculkBeeHarvesterEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.f_21365_ = new BeeLookControl((Mob)this);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 16.0f);
        this.m_21441_(BlockPathTypes.COCOA, -1.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
    }

    public SculkBeeHarvesterEntity(Level worldIn) {
        this((EntityType<? extends SculkBeeHarvesterEntity>)((EntityType)EntityRegistry.SCULK_BEE_HARVESTER.get()), worldIn);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    public float m_5610_(BlockPos p_27788_, LevelReader p_27789_) {
        return p_27789_.m_8055_(p_27788_).m_60795_() ? 10.0f : 0.0f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22280_, (double)0.6f);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        if (this.hasHive()) {
            compoundTag.m_128365_(TAG_HIVE_POS, (Tag)NbtUtils.m_129224_((BlockPos)this.getHivePos()));
        }
        if (this.hasSavedFlowerPos()) {
            compoundTag.m_128365_(TAG_FLOWER_POS, (Tag)NbtUtils.m_129224_((BlockPos)this.getSavedFlowerPos()));
        }
        compoundTag.m_128379_(TAG_HAS_NECTAR, this.hasNectar());
        compoundTag.m_128379_(TAG_HAS_STUNG, this.hasStung());
        compoundTag.m_128405_(TAG_TICKS_SINCE_POLLINATION, this.ticksWithoutNectarSinceExitingHive);
        compoundTag.m_128405_(TAG_CROPS_GROWN_SINCE_POLLINATION, this.numCropsGrownSincePollination);
    }

    public void m_7378_(CompoundTag compoundTag) {
        this.hivePos = null;
        if (compoundTag.m_128441_(TAG_HIVE_POS)) {
            this.hivePos = NbtUtils.m_129239_((CompoundTag)compoundTag.m_128469_(TAG_HIVE_POS));
        }
        this.savedFlowerPos = null;
        if (compoundTag.m_128441_(TAG_FLOWER_POS)) {
            this.savedFlowerPos = NbtUtils.m_129239_((CompoundTag)compoundTag.m_128469_(TAG_FLOWER_POS));
        }
        super.m_7378_(compoundTag);
        this.setHasNectar(compoundTag.m_128471_(TAG_HAS_NECTAR));
        this.setHasStung(compoundTag.m_128471_(TAG_HAS_STUNG));
        this.ticksWithoutNectarSinceExitingHive = compoundTag.m_128451_(TAG_TICKS_SINCE_POLLINATION);
        this.numCropsGrownSincePollination = compoundTag.m_128451_(TAG_CROPS_GROWN_SINCE_POLLINATION);
    }

    public double getArrivalThreshold() {
        return 0.1;
    }

    public Predicate<BlockPos> getIsFlowerValidPredicate() {
        return this.IS_VALID_FLOWER;
    }

    @Nullable
    public BlockPos getSavedFlowerPos() {
        return this.savedFlowerPos;
    }

    public boolean hasSavedFlowerPos() {
        return this.savedFlowerPos != null;
    }

    public void setSavedFlowerPos(BlockPos blockPos) {
        this.savedFlowerPos = blockPos;
    }

    @VisibleForDebug
    public int getTravellingTicks() {
        return Math.max(this.goToHiveGoal.travellingTicks, this.goToKnownFlowerGoal.travellingTicks);
    }

    @VisibleForDebug
    public List<BlockPos> getBlacklistedHives() {
        return this.goToHiveGoal.blacklistedTargets;
    }

    @VisibleForDebug
    public boolean hasHive() {
        return this.getHivePos() != null;
    }

    @Nullable
    @VisibleForDebug
    public BlockPos getHivePos() {
        return this.hivePos;
    }

    public boolean hasNectar() {
        return this.getFlag(8);
    }

    public boolean hasStung() {
        return this.getFlag(4);
    }

    public boolean isFood(ItemStack itemStack) {
        return itemStack.m_204117_(ItemTags.f_13149_);
    }

    @VisibleForDebug
    public GoalSelector getGoalSelector() {
        return this.f_21345_;
    }

    public boolean m_142039_() {
        return this.m_29443_() && this.f_19797_ % TICKS_PER_FLAP == 0;
    }

    public void resetTicksWithoutNectarSinceExitingHive() {
        this.ticksWithoutNectarSinceExitingHive = 0;
    }

    protected boolean isTiredOfLookingForNectar() {
        return this.ticksWithoutNectarSinceExitingHive > 3600 || this.failedFlowerFindAttempts > 5;
    }

    protected int getCropsGrownSincePollination() {
        return this.numCropsGrownSincePollination;
    }

    protected void resetNumCropsGrownSincePollination() {
        this.numCropsGrownSincePollination = 0;
    }

    protected void incrementNumCropsGrownSincePollination() {
        ++this.numCropsGrownSincePollination;
    }

    protected boolean wantsToEnterHive() {
        if (this.isTiredOfLookingForNectar() || this.f_19853_.m_46471_() || this.hasNectar() || this.hivePos == null || this.hivePos == BlockPos.f_121853_) {
            return !this.isHiveNearFire();
        }
        return false;
    }

    protected boolean isHiveNearFire() {
        if (this.hivePos == null) {
            return false;
        }
        BlockEntity blockentity = this.f_19853_.m_7702_(this.hivePos);
        return blockentity instanceof SculkBeeNestBlockEntity && ((SculkBeeNestBlockEntity)blockentity).isFireNearby();
    }

    protected boolean doesHiveHaveSpace(BlockPos blockPos) {
        BlockEntity blockentity = this.f_19853_.m_7702_(blockPos);
        if (blockentity instanceof SculkBeeNestBlockEntity) {
            return !((SculkBeeNestBlockEntity)blockentity).isFull();
        }
        return false;
    }

    protected boolean isHiveValid() {
        if (!this.hasHive()) {
            return false;
        }
        if (this.isTooFarAway(this.hivePos)) {
            return false;
        }
        BlockEntity blockentity = this.f_19853_.m_7702_(this.hivePos);
        return blockentity instanceof SculkBeeNestBlockEntity;
    }

    protected void setHasNectar(boolean hasNectar) {
        if (hasNectar) {
            this.resetTicksWithoutNectarSinceExitingHive();
        }
        this.setFlag(8, hasNectar);
    }

    protected void setHasStung(boolean hasStung) {
        this.setFlag(4, hasStung);
    }

    protected boolean isTooFarAway(BlockPos blockPos) {
        return !this.closerThan(blockPos, 64);
    }

    protected void setFlag(int p_27833_, boolean p_27834_) {
        if (p_27834_) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) | p_27833_)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & ~p_27833_)));
        }
    }

    protected boolean getFlag(int p_27922_) {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & p_27922_) != 0;
    }

    protected boolean isFlowerValid(BlockPos pos) {
        return this.f_19853_.m_46749_(pos) && this.getIsFlowerValidPredicate().test(pos);
    }

    protected void executeCodeOnPollination() {
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.hasNectar() && this.getCropsGrownSincePollination() < 10 && this.f_19796_.m_188501_() < 0.05f) {
            for (int i = 0; i < this.f_19796_.m_188503_(2) + 1; ++i) {
                this.spawnFluidParticle(this.f_19853_, this.m_20185_() - (double)0.3f, this.m_20185_() + (double)0.3f, this.m_20189_() - (double)0.3f, this.m_20189_() + (double)0.3f, this.m_20227_(0.5), (ParticleOptions)ParticleTypes.f_123782_);
            }
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            boolean flag;
            if (this.remainingCooldownBeforeLocatingNewHive > 0) {
                --this.remainingCooldownBeforeLocatingNewHive;
            }
            if (this.remainingCooldownBeforeLocatingNewFlower > 0) {
                --this.remainingCooldownBeforeLocatingNewFlower;
            }
            boolean bl = flag = !this.hasStung() && this.m_5448_() != null && this.m_5448_().m_20280_((Entity)this) < 4.0;
            if (this.f_19797_ % 20 == 0 && !this.isHiveValid()) {
                this.hivePos = null;
            }
        }
    }

    protected void m_8024_() {
        boolean flag = this.hasStung();
        this.underWaterTicks = this.m_20072_() ? ++this.underWaterTicks : 0;
        if (this.underWaterTicks > 20) {
            this.m_6469_(this.m_269291_().m_269063_(), 1.0f);
        }
        if (flag) {
            ++this.timeSinceSting;
            if (this.timeSinceSting % 5 == 0 && this.f_19796_.m_188503_(Mth.m_14045_((int)(1200 - this.timeSinceSting), (int)1, (int)1200)) == 0) {
                this.m_6469_(this.m_269291_().m_269264_(), this.m_21223_());
            }
        }
        if (!this.hasNectar()) {
            ++this.ticksWithoutNectarSinceExitingHive;
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new BeeEnterHiveGoal());
        this.beePollinateGoal = new BeePollinateGoal();
        this.f_21345_.m_25352_(4, (Goal)this.beePollinateGoal);
        this.f_21345_.m_25352_(5, (Goal)new BeeLocateHiveGoal());
        this.goToHiveGoal = new BeeGoToHiveGoal();
        this.f_21345_.m_25352_(5, (Goal)this.goToHiveGoal);
        this.goToKnownFlowerGoal = new BeeGoToKnownFlowerGoal();
        this.f_21345_.m_25352_(6, (Goal)this.goToKnownFlowerGoal);
        this.f_21345_.m_25352_(7, (Goal)new BeeGrowCropGoal());
        this.f_21345_.m_25352_(8, (Goal)new BeeWanderGoal());
        this.f_21345_.m_25352_(9, (Goal)new FloatGoal((Mob)this));
    }

    protected PathNavigation m_6037_(Level p_27815_) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, p_27815_){

            public boolean m_6342_(BlockPos p_27947_) {
                return !this.f_26495_.m_8055_(p_27947_.m_7495_()).m_60795_();
            }

            public void m_7638_() {
                if (!SculkBeeHarvesterEntity.this.beePollinateGoal.isPollinating()) {
                    super.m_7638_();
                }
            }
        };
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(false);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    protected void spawnFluidParticle(Level p_27780_, double p_27781_, double p_27782_, double p_27783_, double p_27784_, double p_27785_, ParticleOptions p_27786_) {
        p_27780_.m_7106_(p_27786_, Mth.m_14139_((double)p_27780_.f_46441_.m_188500_(), (double)p_27781_, (double)p_27782_), p_27785_, Mth.m_14139_((double)p_27780_.f_46441_.m_188500_(), (double)p_27783_, (double)p_27784_), 0.0, 0.0, 0.0);
    }

    public void dropOffNectar() {
        this.setHasNectar(false);
        this.resetNumCropsGrownSincePollination();
    }

    public boolean m_6469_(DamageSource p_27762_, float p_27763_) {
        if (this.m_6673_(p_27762_)) {
            return false;
        }
        if (!this.f_19853_.f_46443_) {
            this.beePollinateGoal.stopPollinating();
        }
        return super.m_6469_(p_27762_, p_27763_);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.5f * this.m_20192_()), (double)(this.m_20205_() * 0.2f));
    }

    protected void pathfindRandomlyTowards(BlockPos p_27881_) {
        Vec3 vec31;
        Vec3 vec3 = Vec3.m_82539_((Vec3i)p_27881_);
        int i = 0;
        BlockPos blockpos = this.m_20183_();
        int j = (int)vec3.f_82480_ - blockpos.m_123342_();
        if (j > 2) {
            i = 4;
        } else if (j < -2) {
            i = -4;
        }
        int k = 6;
        int l = 8;
        int i1 = blockpos.m_123333_((Vec3i)p_27881_);
        if (i1 < 15) {
            k = i1 / 2;
            l = i1 / 2;
        }
        if ((vec31 = AirRandomPos.m_148387_((PathfinderMob)this, (int)k, (int)l, (int)i, (Vec3)vec3, (double)0.3141592741012573)) != null) {
            this.f_21344_.m_26529_(0.5f);
            this.f_21344_.m_26519_(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, 1.0);
        }
    }

    protected void jumpInLiquidInternal() {
        this.m_20256_(this.m_20184_().m_82520_(0.0, 0.01, 0.0));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericFlyController((GeoAnimatable)this)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    boolean closerThan(BlockPos p_27817_, int p_27818_) {
        return p_27817_.m_123314_((Vec3i)this.m_20183_(), (double)p_27818_);
    }

    public void m_6043_() {
    }

    public boolean m_213854_() {
        return true;
    }

    protected void m_7840_(double p_27754_, boolean p_27755_, BlockState p_27756_, BlockPos p_27757_) {
    }

    public void onRemovedFromWorld() {
        SculkHorde.savedData.addSculkAccumulatedMass((int)this.m_21223_());
        super.onRemovedFromWorld();
    }

    public boolean m_29443_() {
        return true;
    }

    protected class BeeLookControl
    extends LookControl {
        BeeLookControl(Mob p_28059_) {
            super(p_28059_);
        }

        public void m_8128_() {
            super.m_8128_();
        }

        protected boolean m_8106_() {
            return !SculkBeeHarvesterEntity.this.beePollinateGoal.isPollinating();
        }
    }

    @VisibleForDebug
    public class BeeGoToHiveGoal
    extends BaseBeeGoal {
        public static final int MAX_TRAVELLING_TICKS = TickUnits.convertMinutesToTicks(2);
        int travellingTicks;
        protected static final int MAX_BLACKLISTED_TARGETS = 3;
        final List<BlockPos> blacklistedTargets;
        @Nullable
        protected Path lastPath;
        protected static final int TICKS_BEFORE_HIVE_DROP = 60;
        protected int ticksStuck;

        BeeGoToHiveGoal() {
            this.travellingTicks = SculkBeeHarvesterEntity.this.f_19853_.f_46441_.m_188503_(10);
            this.blacklistedTargets = Lists.newArrayList();
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean canBeeUse() {
            if (SculkBeeHarvesterEntity.this.hivePos == null) {
                return false;
            }
            if (SculkBeeHarvesterEntity.this.m_21536_()) {
                return false;
            }
            if (this.hasReachedTarget(SculkBeeHarvesterEntity.this.hivePos)) {
                return false;
            }
            return SculkBeeHarvesterEntity.this.f_19853_.m_8055_(SculkBeeHarvesterEntity.this.hivePos).m_60713_((Block)BlockRegistry.SCULK_BEE_NEST_BLOCK.get());
        }

        @Override
        public boolean canBeeContinueToUse() {
            return this.canBeeUse();
        }

        public void m_8056_() {
            this.travellingTicks = 0;
            this.ticksStuck = 0;
            super.m_8056_();
        }

        public void m_8041_() {
            this.travellingTicks = 0;
            this.ticksStuck = 0;
            SculkBeeHarvesterEntity.this.f_21344_.m_26573_();
            SculkBeeHarvesterEntity.this.f_21344_.m_26566_();
        }

        public void m_8037_() {
            if (SculkBeeHarvesterEntity.this.hivePos != null) {
                ++this.travellingTicks;
                if (this.travellingTicks > this.m_183277_(MAX_TRAVELLING_TICKS)) {
                    this.dropAndBlacklistHive();
                } else if (!SculkBeeHarvesterEntity.this.f_21344_.m_26572_()) {
                    if (!SculkBeeHarvesterEntity.this.closerThan(SculkBeeHarvesterEntity.this.hivePos, 16)) {
                        if (SculkBeeHarvesterEntity.this.isTooFarAway(SculkBeeHarvesterEntity.this.hivePos)) {
                            this.dropHive();
                        } else {
                            SculkBeeHarvesterEntity.this.pathfindRandomlyTowards(SculkBeeHarvesterEntity.this.hivePos);
                        }
                    } else {
                        boolean flag = this.pathfindDirectlyTowards(SculkBeeHarvesterEntity.this.hivePos);
                        if (!flag) {
                            this.dropAndBlacklistHive();
                        } else if (this.lastPath != null && SculkBeeHarvesterEntity.this.f_21344_.m_26570_().m_77385_(this.lastPath)) {
                            ++this.ticksStuck;
                            if (this.ticksStuck > 60) {
                                this.dropHive();
                                this.ticksStuck = 0;
                            }
                        } else {
                            this.lastPath = SculkBeeHarvesterEntity.this.f_21344_.m_26570_();
                        }
                    }
                }
            }
        }

        protected boolean pathfindDirectlyTowards(BlockPos p_27991_) {
            SculkBeeHarvesterEntity.this.f_21344_.m_26529_(10.0f);
            SculkBeeHarvesterEntity.this.f_21344_.m_26519_((double)p_27991_.m_123341_(), (double)p_27991_.m_123342_(), (double)p_27991_.m_123343_(), 1.0);
            return SculkBeeHarvesterEntity.this.f_21344_.m_26570_() != null && SculkBeeHarvesterEntity.this.f_21344_.m_26570_().m_77403_();
        }

        protected boolean isTargetBlacklisted(BlockPos p_27994_) {
            return this.blacklistedTargets.contains(p_27994_);
        }

        protected void blacklistTarget(BlockPos p_27999_) {
            this.blacklistedTargets.add(p_27999_);
            while (this.blacklistedTargets.size() > 3) {
                this.blacklistedTargets.remove(0);
            }
        }

        protected void clearBlacklist() {
            this.blacklistedTargets.clear();
        }

        protected void dropAndBlacklistHive() {
            if (SculkBeeHarvesterEntity.this.hivePos != null) {
                this.blacklistTarget(SculkBeeHarvesterEntity.this.hivePos);
            }
            this.dropHive();
        }

        protected void dropHive() {
            SculkBeeHarvesterEntity.this.hivePos = null;
            SculkBeeHarvesterEntity.this.remainingCooldownBeforeLocatingNewHive = 200;
        }

        protected boolean hasReachedTarget(BlockPos p_28002_) {
            if (SculkBeeHarvesterEntity.this.closerThan(p_28002_, 2)) {
                return true;
            }
            Path path = SculkBeeHarvesterEntity.this.f_21344_.m_26570_();
            return path != null && path.m_77406_().equals((Object)p_28002_) && path.m_77403_() && path.m_77392_();
        }
    }

    public class BeeGoToKnownFlowerGoal
    extends BaseBeeGoal {
        protected static final int MAX_TRAVELLING_TICKS = TickUnits.convertMinutesToTicks(1);
        int travellingTicks;

        BeeGoToKnownFlowerGoal() {
            this.travellingTicks = SculkBeeHarvesterEntity.this.f_19853_.f_46441_.m_188503_(10);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean canBeeUse() {
            return SculkBeeHarvesterEntity.this.savedFlowerPos != null && !SculkBeeHarvesterEntity.this.m_21536_() && this.wantsToGoToKnownFlower() && SculkBeeHarvesterEntity.this.isFlowerValid(SculkBeeHarvesterEntity.this.savedFlowerPos) && !SculkBeeHarvesterEntity.this.closerThan(SculkBeeHarvesterEntity.this.savedFlowerPos, 2);
        }

        @Override
        public boolean canBeeContinueToUse() {
            return this.canBeeUse();
        }

        public void m_8056_() {
            this.travellingTicks = 0;
            super.m_8056_();
        }

        public void m_8041_() {
            this.travellingTicks = 0;
            SculkBeeHarvesterEntity.this.f_21344_.m_26573_();
            SculkBeeHarvesterEntity.this.f_21344_.m_26566_();
        }

        public void m_8037_() {
            if (SculkBeeHarvesterEntity.this.savedFlowerPos != null) {
                ++this.travellingTicks;
                if (this.travellingTicks > this.m_183277_(MAX_TRAVELLING_TICKS)) {
                    SculkBeeHarvesterEntity.this.savedFlowerPos = null;
                } else if (!SculkBeeHarvesterEntity.this.f_21344_.m_26572_()) {
                    if (SculkBeeHarvesterEntity.this.isTooFarAway(SculkBeeHarvesterEntity.this.savedFlowerPos)) {
                        SculkBeeHarvesterEntity.this.savedFlowerPos = null;
                    } else {
                        SculkBeeHarvesterEntity.this.pathfindRandomlyTowards(SculkBeeHarvesterEntity.this.savedFlowerPos);
                    }
                }
            }
        }

        protected boolean wantsToGoToKnownFlower() {
            return SculkBeeHarvesterEntity.this.ticksWithoutNectarSinceExitingHive > 2400;
        }
    }

    protected class BeeEnterHiveGoal
    extends BaseBeeGoal {
        protected BeeEnterHiveGoal() {
        }

        @Override
        public boolean canBeeUse() {
            BlockEntity blockentity;
            if (SculkBeeHarvesterEntity.this.hasHive() && SculkBeeHarvesterEntity.this.wantsToEnterHive() && SculkBeeHarvesterEntity.this.hivePos.m_203195_((Position)SculkBeeHarvesterEntity.this.m_20182_(), 2.0) && (blockentity = SculkBeeHarvesterEntity.this.f_19853_.m_7702_(SculkBeeHarvesterEntity.this.hivePos)) instanceof SculkBeeNestBlockEntity) {
                SculkBeeNestBlockEntity SculkBeeNestBlockEntity2 = (SculkBeeNestBlockEntity)blockentity;
                if (!SculkBeeNestBlockEntity2.isFull()) {
                    return true;
                }
                SculkBeeHarvesterEntity.this.hivePos = null;
            }
            return false;
        }

        @Override
        public boolean canBeeContinueToUse() {
            return false;
        }

        public void m_8056_() {
            BlockEntity blockentity = SculkBeeHarvesterEntity.this.f_19853_.m_7702_(SculkBeeHarvesterEntity.this.hivePos);
            if (blockentity instanceof SculkBeeNestBlockEntity) {
                SculkBeeNestBlockEntity SculkBeeNestBlockEntity2 = (SculkBeeNestBlockEntity)blockentity;
                SculkBeeHarvesterEntity.this.failedFlowerFindAttempts = 0;
                SculkBeeNestBlockEntity2.addOccupant((Entity)SculkBeeHarvesterEntity.this, SculkBeeHarvesterEntity.this.hasNectar());
            }
        }
    }

    protected class BeePollinateGoal
    extends BaseBeeGoal {
        protected static final int MIN_POLLINATION_TICKS = 400;
        protected static final int MIN_FIND_FLOWER_RETRY_COOLDOWN = 18000;
        protected static final int MAX_FIND_FLOWER_RETRY_COOLDOWN = 36000;
        protected static final int POSITION_CHANGE_CHANCE = 25;
        protected static final float SPEED_MODIFIER = 0.35f;
        protected static final float HOVER_HEIGHT_WITHIN_FLOWER = 0.6f;
        protected static final float HOVER_POS_OFFSET = 0.33333334f;
        protected int successfulPollinatingTicks;
        protected int lastSoundPlayedTick;
        protected boolean pollinating;
        @Nullable
        protected Vec3 hoverPos;
        protected int pollinatingTicks;
        protected static final int MAX_POLLINATING_TICKS = 600;

        BeePollinateGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean canBeeUse() {
            if (SculkBeeHarvesterEntity.this.remainingCooldownBeforeLocatingNewFlower > 0 || SculkBeeHarvesterEntity.this.failedFlowerFindAttempts > 5) {
                return false;
            }
            if (SculkBeeHarvesterEntity.this.hasNectar()) {
                return false;
            }
            if (SculkBeeHarvesterEntity.this.f_19853_.m_46471_()) {
                return false;
            }
            Optional<BlockPos> optional = this.findNearbyFlower();
            if (optional.isPresent()) {
                SculkBeeHarvesterEntity.this.savedFlowerPos = optional.get();
                SculkBeeHarvesterEntity.this.f_21344_.m_26519_((double)SculkBeeHarvesterEntity.this.savedFlowerPos.m_123341_() + 0.5, (double)SculkBeeHarvesterEntity.this.savedFlowerPos.m_123342_(), (double)SculkBeeHarvesterEntity.this.savedFlowerPos.m_123343_() + 0.5, (double)1.2f);
                return true;
            }
            SculkBeeHarvesterEntity.this.failedFlowerFindAttempts = 0;
            SculkBeeHarvesterEntity.this.remainingCooldownBeforeLocatingNewFlower = Mth.m_216271_((RandomSource)SculkBeeHarvesterEntity.this.f_19796_, (int)18000, (int)36000);
            return false;
        }

        @Override
        public boolean canBeeContinueToUse() {
            if (!this.pollinating) {
                return false;
            }
            if (!SculkBeeHarvesterEntity.this.hasSavedFlowerPos()) {
                return false;
            }
            if (SculkBeeHarvesterEntity.this.f_19853_.m_46471_()) {
                return false;
            }
            if (this.hasPollinatedLongEnough()) {
                return SculkBeeHarvesterEntity.this.f_19796_.m_188501_() < 0.2f;
            }
            if (SculkBeeHarvesterEntity.this.f_19797_ % 20 == 0 && !SculkBeeHarvesterEntity.this.isFlowerValid(SculkBeeHarvesterEntity.this.savedFlowerPos)) {
                SculkBeeHarvesterEntity.this.savedFlowerPos = null;
                return false;
            }
            return true;
        }

        protected boolean hasPollinatedLongEnough() {
            return this.successfulPollinatingTicks > 400;
        }

        protected boolean isPollinating() {
            return this.pollinating;
        }

        protected void stopPollinating() {
            this.pollinating = false;
        }

        public void m_8056_() {
            this.successfulPollinatingTicks = 0;
            this.pollinatingTicks = 0;
            this.lastSoundPlayedTick = 0;
            this.pollinating = true;
            SculkBeeHarvesterEntity.this.resetTicksWithoutNectarSinceExitingHive();
        }

        public void m_8041_() {
            if (this.hasPollinatedLongEnough()) {
                SculkBeeHarvesterEntity.this.setHasNectar(true);
                SculkBeeHarvesterEntity.this.executeCodeOnPollination();
            }
            this.pollinating = false;
            SculkBeeHarvesterEntity.this.f_21344_.m_26573_();
            SculkBeeHarvesterEntity.this.remainingCooldownBeforeLocatingNewFlower = 200;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            ++this.pollinatingTicks;
            if (this.pollinatingTicks > 600) {
                SculkBeeHarvesterEntity.this.savedFlowerPos = null;
            } else {
                Vec3 vec3 = Vec3.m_82539_((Vec3i)SculkBeeHarvesterEntity.this.savedFlowerPos).m_82520_(0.0, (double)0.6f, 0.0);
                if (vec3.m_82554_(SculkBeeHarvesterEntity.this.m_20182_()) > 1.0) {
                    this.hoverPos = vec3;
                    this.setWantedPos();
                } else {
                    if (this.hoverPos == null) {
                        this.hoverPos = vec3;
                    }
                    boolean flag = SculkBeeHarvesterEntity.this.m_20182_().m_82554_(this.hoverPos) <= SculkBeeHarvesterEntity.this.getArrivalThreshold();
                    boolean flag1 = true;
                    if (!flag && this.pollinatingTicks > 600) {
                        SculkBeeHarvesterEntity.this.savedFlowerPos = null;
                    } else {
                        if (flag) {
                            boolean flag2;
                            boolean bl = flag2 = SculkBeeHarvesterEntity.this.f_19796_.m_188503_(25) == 0;
                            if (flag2) {
                                this.hoverPos = new Vec3(vec3.m_7096_() + (double)this.getOffset(), vec3.m_7098_(), vec3.m_7094_() + (double)this.getOffset());
                                SculkBeeHarvesterEntity.this.f_21344_.m_26573_();
                            } else {
                                flag1 = false;
                            }
                            SculkBeeHarvesterEntity.this.m_21563_().m_24946_(vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_());
                        }
                        if (flag1) {
                            this.setWantedPos();
                        }
                        ++this.successfulPollinatingTicks;
                        if (SculkBeeHarvesterEntity.this.f_19796_.m_188501_() < 0.05f && this.successfulPollinatingTicks > this.lastSoundPlayedTick + 60) {
                            this.lastSoundPlayedTick = this.successfulPollinatingTicks;
                            SculkBeeHarvesterEntity.this.m_5496_(SoundEvents.f_11693_, 1.0f, 1.0f);
                        }
                    }
                }
            }
        }

        protected void setWantedPos() {
            SculkBeeHarvesterEntity.this.m_21566_().m_6849_(this.hoverPos.m_7096_(), this.hoverPos.m_7098_(), this.hoverPos.m_7094_(), (double)0.35f);
        }

        protected float getOffset() {
            return (SculkBeeHarvesterEntity.this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.33333334f;
        }

        protected Optional<BlockPos> findNearbyFlower() {
            return BlockAlgorithms.findBlockInCubeBlockPosPredicate((ServerLevel)SculkBeeHarvesterEntity.this.f_19853_, SculkBeeHarvesterEntity.this.m_20183_(), SculkBeeHarvesterEntity.this.getIsFlowerValidPredicate(), 5);
        }
    }

    protected class BeeLocateHiveGoal
    extends BaseBeeGoal {
        private final Predicate<BlockState> VALID_HIVE_BLOCKS;

        protected BeeLocateHiveGoal() {
            this.VALID_HIVE_BLOCKS = validBlocksPredicate -> validBlocksPredicate.m_60713_((Block)BlockRegistry.SCULK_BEE_NEST_BLOCK.get());
        }

        @Override
        public boolean canBeeUse() {
            return SculkBeeHarvesterEntity.this.remainingCooldownBeforeLocatingNewHive == 0 && !SculkBeeHarvesterEntity.this.hasHive() && SculkBeeHarvesterEntity.this.wantsToEnterHive();
        }

        @Override
        public boolean canBeeContinueToUse() {
            return false;
        }

        public void m_8056_() {
            SculkBeeHarvesterEntity.this.remainingCooldownBeforeLocatingNewHive = 200;
            List<BlockPos> list = this.findNearbyHivesWithSpace();
            if (!list.isEmpty()) {
                for (BlockPos blockpos : list) {
                    if (SculkBeeHarvesterEntity.this.goToHiveGoal.isTargetBlacklisted(blockpos) || !(BlockAlgorithms.getBlockDistance(blockpos, SculkBeeHarvesterEntity.this.m_20183_()) <= 64.0f)) continue;
                    SculkBeeHarvesterEntity.this.hivePos = blockpos;
                    return;
                }
                SculkBeeHarvesterEntity.this.goToHiveGoal.clearBlacklist();
                SculkBeeHarvesterEntity.this.hivePos = list.get(0);
                return;
            }
        }

        protected List<BlockPos> findNearbyHivesWithSpace() {
            ArrayList<BlockPos> list = BlockAlgorithms.getBlocksInArea((ServerLevel)SculkBeeHarvesterEntity.this.f_19853_, SculkBeeHarvesterEntity.this.m_20183_(), this.VALID_HIVE_BLOCKS, 63);
            for (int index = 0; index < list.size(); ++index) {
                if (SculkBeeHarvesterEntity.this.doesHiveHaveSpace((BlockPos)list.get(index))) continue;
                list.remove(index);
                --index;
            }
            return list;
        }
    }

    protected class BeeGrowCropGoal
    extends BaseBeeGoal {
        protected static final int GROW_CHANCE = 30;

        protected BeeGrowCropGoal() {
        }

        @Override
        public boolean canBeeUse() {
            if (SculkBeeHarvesterEntity.this.getCropsGrownSincePollination() >= 10) {
                return false;
            }
            if (SculkBeeHarvesterEntity.this.f_19796_.m_188501_() < 0.3f) {
                return false;
            }
            return SculkBeeHarvesterEntity.this.hasNectar() && SculkBeeHarvesterEntity.this.isHiveValid();
        }

        @Override
        public boolean canBeeContinueToUse() {
            return this.canBeeUse();
        }

        public void m_8037_() {
            if (SculkBeeHarvesterEntity.this.f_19796_.m_188503_(this.m_183277_(30)) == 0) {
                for (int i = 1; i <= 2; ++i) {
                    BlockPos blockpos = SculkBeeHarvesterEntity.this.m_20183_().m_6625_(i);
                    BlockState blockstate = SculkBeeHarvesterEntity.this.f_19853_.m_8055_(blockpos);
                    Block block = blockstate.m_60734_();
                    boolean flag = false;
                    IntegerProperty integerproperty = null;
                    if (!blockstate.m_204336_(BlockTags.f_13074_)) continue;
                    if (block instanceof CropBlock) {
                        CropBlock cropblock = (CropBlock)block;
                        if (!cropblock.m_52307_(blockstate)) {
                            flag = true;
                            integerproperty = cropblock.m_7959_();
                        }
                    } else if (block instanceof StemBlock) {
                        int k = (Integer)blockstate.m_61143_((Property)StemBlock.f_57013_);
                        if (k < 7) {
                            flag = true;
                            integerproperty = StemBlock.f_57013_;
                        }
                    } else if (blockstate.m_60713_(Blocks.f_50685_)) {
                        int j = (Integer)blockstate.m_61143_((Property)SweetBerryBushBlock.f_57244_);
                        if (j < 3) {
                            flag = true;
                            integerproperty = SweetBerryBushBlock.f_57244_;
                        }
                    } else if (blockstate.m_60713_(Blocks.f_152538_) || blockstate.m_60713_(Blocks.f_152539_)) {
                        ((BonemealableBlock)blockstate.m_60734_()).m_214148_((ServerLevel)SculkBeeHarvesterEntity.this.f_19853_, SculkBeeHarvesterEntity.this.f_19796_, blockpos, blockstate);
                    }
                    if (!flag) continue;
                    SculkBeeHarvesterEntity.this.f_19853_.m_46796_(2005, blockpos, 0);
                    SculkBeeHarvesterEntity.this.f_19853_.m_46597_(blockpos, (BlockState)blockstate.m_61124_((Property)integerproperty, (Comparable)Integer.valueOf((Integer)blockstate.m_61143_((Property)integerproperty) + 1)));
                    SculkBeeHarvesterEntity.this.incrementNumCropsGrownSincePollination();
                }
            }
        }
    }

    protected class BeeWanderGoal
    extends Goal {
        protected static final int WANDER_THRESHOLD = 63;

        BeeWanderGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return SculkBeeHarvesterEntity.this.f_21344_.m_26571_() && SculkBeeHarvesterEntity.this.f_19796_.m_188503_(10) == 0;
        }

        public boolean m_8045_() {
            return SculkBeeHarvesterEntity.this.f_21344_.m_26572_();
        }

        public void m_8056_() {
            Vec3 vec3 = this.findPos();
            if (vec3 != null) {
                SculkBeeHarvesterEntity.this.f_21344_.m_26536_(SculkBeeHarvesterEntity.this.f_21344_.m_7864_(BlockPos.m_274446_((Position)vec3), 1), 1.0);
            }
        }

        @Nullable
        protected Vec3 findPos() {
            Vec3 vec3;
            if (SculkBeeHarvesterEntity.this.isHiveValid() && !SculkBeeHarvesterEntity.this.closerThan(SculkBeeHarvesterEntity.this.hivePos, 63)) {
                Vec3 vec31 = Vec3.m_82512_((Vec3i)SculkBeeHarvesterEntity.this.hivePos);
                vec3 = vec31.m_82546_(SculkBeeHarvesterEntity.this.m_20182_()).m_82541_();
            } else {
                vec3 = SculkBeeHarvesterEntity.this.m_20252_(0.0f);
            }
            int i = 8;
            Vec3 vec32 = HoverRandomPos.m_148465_((PathfinderMob)SculkBeeHarvesterEntity.this, (int)8, (int)7, (double)vec3.f_82479_, (double)vec3.f_82481_, (float)1.5707964f, (int)3, (int)1);
            return vec32 != null ? vec32 : AirAndWaterRandomPos.m_148357_((PathfinderMob)SculkBeeHarvesterEntity.this, (int)8, (int)4, (int)-2, (double)vec3.f_82479_, (double)vec3.f_82481_, (double)1.5707963705062866);
        }
    }

    protected class BeeAttackGoal
    extends MeleeAttackGoal {
        BeeAttackGoal(PathfinderMob p_27960_, double p_27961_, boolean p_27962_) {
            super(p_27960_, p_27961_, p_27962_);
        }

        public boolean m_8036_() {
            return super.m_8036_() && !SculkBeeHarvesterEntity.this.hasStung();
        }

        public boolean m_8045_() {
            return super.m_8045_() && !SculkBeeHarvesterEntity.this.hasStung();
        }
    }

    protected abstract class BaseBeeGoal
    extends Goal {
        protected BaseBeeGoal() {
        }

        public abstract boolean canBeeUse();

        public abstract boolean canBeeContinueToUse();

        public boolean m_8036_() {
            return this.canBeeUse();
        }

        public boolean m_8045_() {
            return this.canBeeContinueToUse();
        }
    }
}

