/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity;

import com.github.sculkhorde.common.entity.SculkBeeHarvesterEntity;
import com.github.sculkhorde.common.entity.infection.CursorSurfaceInfectorEntity;
import com.github.sculkhorde.core.EntityRegistry;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.util.BlockAlgorithms;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SculkBeeInfectorEntity
extends SculkBeeHarvesterEntity
implements GeoEntity {
    public static final float MAX_HEALTH = 20.0f;
    public static final float FOLLOW_RANGE = 25.0f;
    public static final float MOVEMENT_SPEED = 0.5f;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Predicate<BlockPos> IS_VALID_FLOWER = blockPos -> {
        BlockState blockState = this.f_19853_.m_8055_(blockPos);
        if (blockState.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            return false;
        }
        if (!SculkHorde.infestationConversionTable.infestationTable.isNormalVariant(this.f_19853_.m_8055_(blockPos))) {
            return false;
        }
        return BlockAlgorithms.isExposedToAir((ServerLevel)this.f_19853_, blockPos);
    };

    public SculkBeeInfectorEntity(EntityType<? extends SculkBeeInfectorEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public SculkBeeInfectorEntity(Level worldIn) {
        super((EntityType<? extends SculkBeeHarvesterEntity>)((EntityType)EntityRegistry.SCULK_BEE_INFECTOR.get()), worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22280_, 1.5);
    }

    @Override
    public Predicate<BlockPos> getIsFlowerValidPredicate() {
        return this.IS_VALID_FLOWER;
    }

    @Override
    public double getArrivalThreshold() {
        return 3.0;
    }

    @Override
    protected void executeCodeOnPollination() {
        CursorSurfaceInfectorEntity cursor = new CursorSurfaceInfectorEntity(this.f_19853_);
        cursor.m_6034_(this.m_20183_().m_123341_(), this.m_20183_().m_123342_(), this.m_20183_().m_123343_());
        cursor.setMaxInfections(100);
        cursor.setMaxRange(100);
        cursor.setTickIntervalMilliseconds(500L);
        cursor.setSearchIterationsPerTick(10);
        this.f_19853_.m_7967_((Entity)cursor);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericFlyController((GeoAnimatable)this)});
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public boolean m_29443_() {
        return true;
    }

    @Override
    public boolean m_213854_() {
        return true;
    }

    @Override
    public void onRemovedFromWorld() {
        SculkHorde.savedData.addSculkAccumulatedMass((int)this.m_21223_());
        super.onRemovedFromWorld();
    }
}

