/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity;

import com.github.sculkhorde.common.entity.ISculkSmartEntity;
import com.github.sculkhorde.common.entity.goal.BlowUpPriorityBlockGoal;
import com.github.sculkhorde.common.entity.goal.DespawnWhenIdle;
import com.github.sculkhorde.common.entity.goal.NearestLivingEntityTargetGoal;
import com.github.sculkhorde.common.entity.goal.PathFindToRaidLocation;
import com.github.sculkhorde.common.entity.goal.TargetAttacker;
import com.github.sculkhorde.util.TargetParameters;
import com.github.sculkhorde.util.TickUnits;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.SwellGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SculkCreeperEntity
extends Creeper
implements ISculkSmartEntity,
GeoEntity {
    private boolean isParticipatingInRaid = false;
    private TargetParameters TARGET_PARAMETERS = new TargetParameters((Mob)this).enableTargetHostiles().enableMustReachTarget();
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("misc.idle");
    private static final RawAnimation RUN_ANIMATION = RawAnimation.begin().thenLoop("move.run");
    private static final RawAnimation WALK_ANIMATION = RawAnimation.begin().thenLoop("move.walk");
    private static final RawAnimation SWELL_ANIMATION = RawAnimation.begin().thenPlay("attack");
    private static final RawAnimation DESWELL_ANIMATION = RawAnimation.begin().thenPlay("unattack");
    private final AnimationController LIVING_CONTROLLER = DefaultAnimations.genericLivingController((GeoAnimatable)this);

    public SculkCreeperEntity(EntityType<? extends Creeper> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new DespawnWhenIdle(this, TickUnits.convertMinutesToTicks(3)));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SwellGoal((Creeper)this));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Ocelot.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Cat.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(5, (Goal)new BlowUpPriorityBlockGoal(this, 1.0, 3, 4, 5));
        this.f_21345_.m_25352_(6, new PathFindToRaidLocation<SculkCreeperEntity>(this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21346_.m_25352_(1, new NearestLivingEntityTargetGoal((Mob)this, true, true));
        this.f_21346_.m_25352_(2, (Goal)new TargetAttacker((PathfinderMob)this, new Class[0]).setAlertAllies(new Class[0]));
    }

    public void m_6043_() {
    }

    @Override
    public boolean isParticipatingInRaid() {
        return this.isParticipatingInRaid;
    }

    @Override
    public void setParticipatingInRaid(boolean isParticipatingInRaidIn) {
        this.isParticipatingInRaid = isParticipatingInRaidIn;
    }

    @Override
    public TargetParameters getTargetParameters() {
        return this.TARGET_PARAMETERS;
    }

    @Override
    public boolean isIdle() {
        return this.m_5448_() == null;
    }

    public void explodeSculkCreeper() {
        if (!this.f_19853_.f_46443_) {
            this.f_20890_ = true;
            this.f_19853_.m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 4.0f, Level.ExplosionInteraction.MOB);
            this.m_146870_();
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        this.LIVING_CONTROLLER.setTransitionLength(5);
        controllers.add(new AnimationController[]{this.LIVING_CONTROLLER, new AnimationController((GeoAnimatable)this, "Walk_cycle", 5, this::poseWalkCycle), new AnimationController((GeoAnimatable)this, "attack_cycle", 5, this::poseAttackCycle)});
    }

    protected PlayState poseWalkCycle(AnimationState<SculkCreeperEntity> state2) {
        if (!state2.isMoving()) {
            state2.setAnimation(IDLE_ANIMATION);
        } else {
            state2.setAnimation(RUN_ANIMATION);
        }
        return PlayState.CONTINUE;
    }

    protected PlayState poseAttackCycle(AnimationState<SculkCreeperEntity> state2) {
        if (this.m_32310_() > 0) {
            state2.setAnimation(SWELL_ANIMATION);
        } else if (this.m_32310_() < 0) {
            state2.setAnimation(DESWELL_ANIMATION);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

