/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity;

import com.github.sculkhorde.common.entity.ISculkSmartEntity;
import com.github.sculkhorde.common.entity.goal.ChaosRiftAttackGoal;
import com.github.sculkhorde.common.entity.goal.DespawnWhenIdle;
import com.github.sculkhorde.common.entity.goal.EnderBubbleAttackGoal;
import com.github.sculkhorde.common.entity.goal.InvalidateTargetGoal;
import com.github.sculkhorde.common.entity.goal.NearestLivingEntityTargetGoal;
import com.github.sculkhorde.common.entity.goal.PathFindToRaidLocation;
import com.github.sculkhorde.common.entity.goal.SummonUnitsFromRiftAttackGoal;
import com.github.sculkhorde.common.entity.goal.TargetAttacker;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.util.TargetParameters;
import com.github.sculkhorde.util.TickUnits;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SculkEndermanEntity
extends Monster
implements GeoEntity,
ISculkSmartEntity {
    public static final float MAX_HEALTH = 100.0f;
    public static final float ARMOR = 20.0f;
    public static final float ATTACK_DAMAGE = 7.0f;
    public static final float ATTACK_KNOCKBACK = 3.0f;
    public static final float FOLLOW_RANGE = 64.0f;
    public static final float MOVEMENT_SPEED = 0.3f;
    private TargetParameters TARGET_PARAMETERS = new TargetParameters((Mob)this).enableTargetHostiles().enableTargetInfected().disableBlackListMobs();
    public boolean canTeleport = true;
    protected int TELEPORT_COOLDOWN = TickUnits.convertSecondsToTicks(8);
    protected int ticksSinceLastTeleport = 0;
    protected int SPECIAL_ATTACK_COOLDOWN = TickUnits.convertSecondsToTicks(5);
    protected int ticksSinceLastSpecialAttack = 0;
    protected ServerBossEvent bossEvent;
    private static final EntityDataAccessor<Boolean> DATA_ANGRY = SynchedEntityData.m_135353_(SculkEndermanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean isParticipatingInRaid = false;
    private final AnimationController LIVING_CONTROLLER = DefaultAnimations.genericLivingController((GeoAnimatable)this);
    private static final RawAnimation BODY_IDLE_ANIMATION = RawAnimation.begin().thenPlay("body.idle");
    private static final RawAnimation BODY_WALK_ANIMATION = RawAnimation.begin().thenPlay("body.walk");
    private static final RawAnimation LEGS_IDLE_ANIMATION = RawAnimation.begin().thenPlay("legs.idle");
    private static final RawAnimation LEGS_WALK_ANIMATION = RawAnimation.begin().thenLoop("legs.walk");
    private static final RawAnimation ARMS_IDLE_ANIMATION = RawAnimation.begin().thenPlay("arms.idle");
    private static final RawAnimation ARMS_WALK_ANIMATION = RawAnimation.begin().thenPlay("arms.walk");
    private static final RawAnimation ARMS_ATTACK_ANIMATION = RawAnimation.begin().thenPlay("arms.attack");

    public SculkEndermanEntity(EntityType<? extends SculkEndermanEntity> type, Level worldIn) {
        super(type, worldIn);
        this.m_274367_(1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.bossEvent = this.createBossEvent();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22284_, 20.0).m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22282_, 3.0).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22279_, (double)0.3f);
    }

    public boolean isSpecialAttackReady() {
        return this.ticksSinceLastSpecialAttack >= this.SPECIAL_ATTACK_COOLDOWN;
    }

    public void incrementSpecialAttackCooldown() {
        ++this.ticksSinceLastSpecialAttack;
    }

    public void resetSpecialAttackCooldown() {
        this.ticksSinceLastSpecialAttack = 0;
    }

    @Override
    public boolean isIdle() {
        return this.m_5448_() == null;
    }

    @Override
    public boolean isParticipatingInRaid() {
        return this.isParticipatingInRaid;
    }

    @Override
    public void setParticipatingInRaid(boolean isParticipatingInRaidIn) {
        this.isParticipatingInRaid = isParticipatingInRaidIn;
    }

    @Override
    public TargetParameters getTargetParameters() {
        return this.TARGET_PARAMETERS;
    }

    boolean isLookingAtMe(Player player) {
        Vec3 vec3 = player.m_20252_(1.0f).m_82541_();
        Vec3 vec31 = new Vec3(this.m_20185_() - player.m_20185_(), this.m_20188_() - player.m_20188_(), this.m_20189_() - player.m_20189_());
        double d0 = vec31.m_82553_();
        double d1 = vec3.m_82526_(vec31 = vec31.m_82541_());
        return d1 > 1.0 - 0.025 / d0 ? player.m_142582_((Entity)this) : false;
    }

    public void m_6043_() {
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new DespawnWhenIdle(this, 120));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new EnderBubbleAttackGoal((PathfinderMob)this, TickUnits.convertSecondsToTicks(5)));
        this.f_21345_.m_25352_(2, (Goal)new SummonUnitsFromRiftAttackGoal((PathfinderMob)this, TickUnits.convertSecondsToTicks(3)));
        this.f_21345_.m_25352_(2, (Goal)new ChaosRiftAttackGoal((PathfinderMob)this, TickUnits.convertSecondsToTicks(3)));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(4, new PathFindToRaidLocation<SculkEndermanEntity>(this));
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, (double)0.8f, 20.0f));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(0, (Goal)new InvalidateTargetGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new TargetAttacker((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new NearestLivingEntityTargetGoal((Mob)this, true, true));
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (damageSource.m_7639_() != null) {
            this.teleportAwayFromEntity(damageSource.m_7639_());
        }
        return super.m_6469_(damageSource, amount);
    }

    public void m_8107_() {
        if (this.f_19853_.f_46443_) {
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
            }
        }
        this.f_20899_ = false;
        super.m_8107_();
    }

    protected void m_8024_() {
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        ++this.ticksSinceLastTeleport;
        this.incrementSpecialAttackCooldown();
        if (this.m_5448_() == null && this.ticksSinceLastTeleport >= this.TELEPORT_COOLDOWN || this.m_5448_() != null && this.ticksSinceLastTeleport >= this.TELEPORT_COOLDOWN / 8) {
            this.ticksSinceLastTeleport = 0;
            if (this.m_5448_() == null) {
                this.teleport();
            } else {
                this.teleportTowards((Entity)this.m_5448_());
            }
        }
        super.m_8024_();
    }

    protected boolean teleport() {
        if (this.f_19853_.m_5776_() || !this.m_6084_() || !this.canTeleport) {
            return false;
        }
        double teleportDistance = 64.0;
        double d0 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * teleportDistance;
        double d1 = this.m_20186_() + (double)(this.f_19796_.m_188503_(64) - 32);
        double d2 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * teleportDistance;
        return this.teleport(d0, d1, d2);
    }

    protected boolean teleportTowards(Entity entity) {
        if (!this.canTeleport) {
            return false;
        }
        Vec3 vec3 = new Vec3(this.m_20185_() - entity.m_20185_(), this.m_20227_(0.5) - entity.m_20188_(), this.m_20189_() - entity.m_20189_());
        vec3 = vec3.m_82541_();
        double teleportDistance = 8.0;
        double d1 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vec3.f_82479_ * teleportDistance;
        double d2 = this.m_20186_() + (double)(this.f_19796_.m_188503_(16) - 8) - vec3.f_82480_ * teleportDistance;
        double d3 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vec3.f_82481_ * teleportDistance;
        return this.teleport(d1, d2, d3);
    }

    public boolean teleportAwayFromEntity(Entity entity) {
        if (!this.canTeleport) {
            return false;
        }
        Vec3 vec3 = new Vec3(this.m_20185_() - entity.m_20185_(), this.m_20227_(0.5) - entity.m_20188_(), this.m_20189_() - entity.m_20189_());
        vec3 = vec3.m_82541_();
        double teleportDistance = 8.0;
        double d1 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 + vec3.f_82479_ * teleportDistance;
        double d2 = this.m_20186_() + (double)(this.f_19796_.m_188503_(16) - 8) + vec3.f_82480_ * teleportDistance;
        double d3 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 + vec3.f_82481_ * teleportDistance;
        return this.teleport(d1, d2, d3);
    }

    protected boolean teleport(double x, double y, double z) {
        if (!this.canTeleport) {
            return false;
        }
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(x, y, z);
        while (blockpos$mutableblockpos.m_123342_() > this.f_19853_.m_141937_() && !this.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos).m_60767_().m_76334_()) {
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos);
        boolean isMotionBlockFlag = blockstate.m_60767_().m_76334_();
        boolean isWaterFlag = blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
        if (isMotionBlockFlag && !isWaterFlag) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)x, (double)y, (double)z);
            if (event.isCanceled()) {
                return false;
            }
            Vec3 vec3 = this.m_20182_();
            boolean ifCanRandomTeleport = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (ifCanRandomTeleport) {
                this.f_19853_.m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)this));
                if (!this.m_20067_()) {
                    this.f_19853_.m_6263_((Player)null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
                    this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
                }
            }
            return ifCanRandomTeleport;
        }
        return false;
    }

    protected ServerBossEvent createBossEvent() {
        ServerBossEvent event = new ServerBossEvent((Component)Component.m_237113_((String)"SCULK_ENDERMAN"), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS);
        return event;
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossEvent.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossEvent.m_6539_(player);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ANGRY, (Object)false);
    }

    public void m_7350_(EntityDataAccessor<?> p_32513_) {
        super.m_7350_(p_32513_);
    }

    public boolean m_6126_() {
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        this.LIVING_CONTROLLER.setTransitionLength(5);
        controllers.add(new AnimationController[]{this.LIVING_CONTROLLER});
    }

    protected PlayState poseLegs(AnimationState<SculkEndermanEntity> state2) {
        if (state2.isMoving()) {
            state2.setAnimation(LEGS_WALK_ANIMATION);
        } else {
            state2.setAnimation(LEGS_IDLE_ANIMATION);
        }
        return PlayState.CONTINUE;
    }

    protected PlayState poseBody(AnimationState<SculkEndermanEntity> state2) {
        if (state2.isMoving()) {
            state2.setAnimation(BODY_WALK_ANIMATION);
        } else {
            state2.setAnimation(BODY_IDLE_ANIMATION);
        }
        return PlayState.CONTINUE;
    }

    protected PlayState poseArms(AnimationState<SculkEndermanEntity> state2) {
        if (((SculkEndermanEntity)state2.getAnimatable()).f_20911_) {
            state2.setAnimation(ARMS_ATTACK_ANIMATION);
        } else if (state2.isMoving()) {
            state2.setAnimation(ARMS_WALK_ANIMATION);
        } else {
            state2.setAnimation(ARMS_IDLE_ANIMATION);
        }
        return PlayState.CONTINUE;
    }

    protected float m_6431_(Pose p_32517_, EntityDimensions p_32518_) {
        return 2.55f;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11899_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_11849_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11900_;
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(SoundEvents.f_12614_, 0.15f, 1.0f);
    }

    public boolean m_213854_() {
        return true;
    }

    public void onRemovedFromWorld() {
        SculkHorde.savedData.addSculkAccumulatedMass((int)this.m_21223_());
        super.onRemovedFromWorld();
    }
}

