/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity;

import com.github.sculkhorde.common.entity.ISculkSmartEntity;
import com.github.sculkhorde.common.entity.goal.DespawnWhenIdle;
import com.github.sculkhorde.common.entity.goal.InvalidateTargetGoal;
import com.github.sculkhorde.common.entity.goal.NearestLivingEntityTargetGoal;
import com.github.sculkhorde.common.entity.goal.PathFindToRaidLocation;
import com.github.sculkhorde.common.entity.goal.TargetAttacker;
import com.github.sculkhorde.core.EntityRegistry;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.util.TargetParameters;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SculkHatcherEntity
extends Monster
implements GeoEntity,
ISculkSmartEntity {
    public static final float MAX_HEALTH = 20.0f;
    public static final float ARMOR = 4.0f;
    public static final float ATTACK_DAMAGE = 3.0f;
    public static final float ATTACK_KNOCKBACK = 1.0f;
    public static final float FOLLOW_RANGE = 25.0f;
    public static final float MOVEMENT_SPEED = 0.25f;
    private TargetParameters TARGET_PARAMETERS = new TargetParameters((Mob)this).enableTargetHostiles().ignoreTargetBelow50PercentHealth().enableMustReachTarget();
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation BODY_IDLE_ANIMATION = RawAnimation.begin().thenPlay("body.idle");
    private static final RawAnimation BODY_WALK_ANIMATION = RawAnimation.begin().thenPlay("body.walk");
    private static final RawAnimation LEGS_IDLE_ANIMATION = RawAnimation.begin().thenPlay("legs.idle");
    private static final RawAnimation LEGS_WALK_ANIMATION = RawAnimation.begin().thenLoop("legs.walk");
    private static final RawAnimation HEAD_ATTACK_ANIMATION = RawAnimation.begin().thenPlay("head.attack");
    private boolean isParticipatingInRaid = false;

    public SculkHatcherEntity(EntityType<? extends SculkHatcherEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public SculkHatcherEntity(Level worldIn) {
        super((EntityType)EntityRegistry.SCULK_HATCHER.get(), worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    public void m_6043_() {
    }

    @Override
    public boolean isIdle() {
        return this.m_5448_() == null;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11830_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_11832_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11831_;
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlockIn) {
        this.m_5496_(SoundEvents.f_11834_, 0.15f, 1.0f);
    }

    public void m_8099_() {
        Goal[] goalSelectorPayload = this.goalSelectorPayload();
        for (int priority = 0; priority < goalSelectorPayload.length; ++priority) {
            this.f_21345_.m_25352_(priority, goalSelectorPayload[priority]);
        }
        Goal[] targetSelectorPayload = this.targetSelectorPayload();
        for (int priority = 0; priority < targetSelectorPayload.length; ++priority) {
            this.f_21346_.m_25352_(priority, targetSelectorPayload[priority]);
        }
    }

    public Goal[] goalSelectorPayload() {
        Goal[] goals = new Goal[]{new DespawnWhenIdle(this, 30), new FloatGoal((Mob)this), new SculkHatcherAttackGoal(this, 1.0, true), new PathFindToRaidLocation<SculkHatcherEntity>(this), new MoveTowardsTargetGoal((PathfinderMob)this, (double)0.8f, 20.0f), new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0), new LookAtPlayerGoal((Mob)this, Pig.class, 8.0f), new RandomLookAroundGoal((Mob)this), new OpenDoorGoal((Mob)this, true)};
        return goals;
    }

    public Goal[] targetSelectorPayload() {
        Goal[] goals = new Goal[]{new InvalidateTargetGoal(this), new TargetAttacker((PathfinderMob)this, new Class[0]).setAlertAllies(new Class[0]), new NearestLivingEntityTargetGoal((Mob)this, true, true)};
        return goals;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Legs", 5, this::poseLegs), new AnimationController((GeoAnimatable)this, "Body", 5, this::poseBody), DefaultAnimations.genericAttackAnimation((LivingEntity)this, (RawAnimation)HEAD_ATTACK_ANIMATION)});
    }

    protected PlayState poseLegs(AnimationState<SculkHatcherEntity> state2) {
        if (state2.isMoving()) {
            state2.setAnimation(LEGS_WALK_ANIMATION);
        } else {
            state2.setAnimation(LEGS_IDLE_ANIMATION);
        }
        return PlayState.CONTINUE;
    }

    protected PlayState poseBody(AnimationState<SculkHatcherEntity> state2) {
        if (state2.isMoving()) {
            state2.setAnimation(BODY_WALK_ANIMATION);
        } else {
            state2.setAnimation(BODY_IDLE_ANIMATION);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public boolean isParticipatingInRaid() {
        return this.isParticipatingInRaid;
    }

    @Override
    public void setParticipatingInRaid(boolean isParticipatingInRaidIn) {
        this.isParticipatingInRaid = isParticipatingInRaidIn;
    }

    @Override
    public TargetParameters getTargetParameters() {
        return this.TARGET_PARAMETERS;
    }

    public boolean m_213854_() {
        return true;
    }

    public void onRemovedFromWorld() {
        SculkHorde.savedData.addSculkAccumulatedMass((int)this.m_21223_());
        super.onRemovedFromWorld();
    }

    public class SculkHatcherAttackGoal
    extends MeleeAttackGoal {
        private final SculkHatcherEntity thisMob;
        private long tickCooldownForSpawn;
        private long ticksInCooldown;

        public SculkHatcherAttackGoal(SculkHatcherEntity mob, double speedModifier, boolean followTargetIfNotSeen) {
            super((PathfinderMob)mob, speedModifier, followTargetIfNotSeen);
            this.tickCooldownForSpawn = 20L;
            this.ticksInCooldown = 0L;
            this.thisMob = mob;
        }

        public boolean m_8036_() {
            boolean canWeUse = ((ISculkSmartEntity)this.f_25540_).getTargetParameters().isEntityValidTarget(this.f_25540_.m_5448_(), true);
            return canWeUse;
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8037_() {
            if (this.thisMob.m_5448_() == null) {
                this.m_8041_();
            } else {
                super.m_8037_();
                if (this.ticksInCooldown >= this.tickCooldownForSpawn && this.thisMob.m_5448_() != null && this.thisMob.m_21223_() > 5.0f) {
                    this.ticksInCooldown = 0L;
                    BlockPos spawnPos = new BlockPos((Vec3i)this.thisMob.m_20183_());
                    ((EntityType)EntityRegistry.SCULK_MITE.get()).m_262496_((ServerLevel)this.thisMob.f_19853_, spawnPos, MobSpawnType.SPAWNER);
                    this.thisMob.m_6469_(SculkHatcherEntity.this.m_269291_().m_269264_(), 5.0f);
                } else {
                    ++this.ticksInCooldown;
                }
            }
        }
    }
}

