/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity;

import com.github.sculkhorde.common.entity.ISculkSmartEntity;
import com.github.sculkhorde.common.entity.goal.DespawnWhenIdle;
import com.github.sculkhorde.common.entity.goal.InvalidateTargetGoal;
import com.github.sculkhorde.common.entity.goal.NearestLivingEntityTargetGoal;
import com.github.sculkhorde.common.entity.goal.PathFindToRaidLocation;
import com.github.sculkhorde.common.entity.goal.TargetAttacker;
import com.github.sculkhorde.core.EntityRegistry;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.util.TargetParameters;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SculkRavagerEntity
extends Ravager
implements GeoEntity,
ISculkSmartEntity {
    public static final float MAX_HEALTH = 50.0f;
    public static final float ARMOR = 4.0f;
    public static final float ATTACK_DAMAGE = 18.0f;
    public static final float ATTACK_KNOCKBACK = 5.0f;
    public static final float FOLLOW_RANGE = 50.0f;
    public static final float MOVEMENT_SPEED = 0.75f;
    private TargetParameters TARGET_PARAMETERS = new TargetParameters((Mob)this).enableTargetHostiles().enableTargetInfected().enableMustReachTarget();
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean isParticipatingInRaid = false;
    private static final RawAnimation HEAD_ATTACK_ANIMATION = RawAnimation.begin().thenPlay("head.attack");

    public SculkRavagerEntity(EntityType<? extends SculkRavagerEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public SculkRavagerEntity(Level worldIn) {
        super((EntityType)EntityRegistry.SCULK_RAVAGER.get(), worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22281_, 18.0).m_22268_(Attributes.f_22282_, 5.0).m_22268_(Attributes.f_22277_, 50.0).m_22268_(Attributes.f_22279_, (double)0.4f).m_22268_(Attributes.f_22278_, 0.75);
    }

    public void m_6043_() {
    }

    @Override
    public boolean isParticipatingInRaid() {
        return this.isParticipatingInRaid;
    }

    @Override
    public void setParticipatingInRaid(boolean isParticipatingInRaidIn) {
        this.isParticipatingInRaid = isParticipatingInRaidIn;
    }

    @Override
    public TargetParameters getTargetParameters() {
        return this.TARGET_PARAMETERS;
    }

    @Override
    public boolean isIdle() {
        return this.m_5448_() == null;
    }

    public void m_8099_() {
        Goal[] goalSelectorPayload = this.goalSelectorPayload();
        for (int priority = 0; priority < goalSelectorPayload.length; ++priority) {
            this.f_21345_.m_25352_(priority, goalSelectorPayload[priority]);
        }
        Goal[] targetSelectorPayload = this.targetSelectorPayload();
        for (int priority = 0; priority < targetSelectorPayload.length; ++priority) {
            this.f_21346_.m_25352_(priority, targetSelectorPayload[priority]);
        }
    }

    public Goal[] goalSelectorPayload() {
        return new Goal[]{new DespawnWhenIdle(this, 120), new FloatGoal((Mob)this), new AttackGoal(), new PathFindToRaidLocation<SculkRavagerEntity>(this), new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7)};
    }

    public Goal[] targetSelectorPayload() {
        return new Goal[]{new InvalidateTargetGoal(this), new TargetAttacker((PathfinderMob)this, new Class[0]).setAlertAllies(new Class[0]), new NearestLivingEntityTargetGoal((Mob)this, true, true)};
    }

    public void onRemovedFromWorld() {
        SculkHorde.savedData.addSculkAccumulatedMass((int)this.m_21223_());
        super.onRemovedFromWorld();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericWalkIdleController((GeoAnimatable)this)});
        controllers.add(new AnimationController[]{DefaultAnimations.genericAttackAnimation((LivingEntity)this, (RawAnimation)HEAD_ATTACK_ANIMATION)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean m_213854_() {
        return true;
    }

    class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal() {
            super((PathfinderMob)SculkRavagerEntity.this, 1.0, true);
        }

        public boolean m_8036_() {
            boolean canWeUse = ((ISculkSmartEntity)this.f_25540_).getTargetParameters().isEntityValidTarget(this.f_25540_.m_5448_(), true);
            return canWeUse;
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        protected double m_6639_(LivingEntity pAttackTarget) {
            float f = SculkRavagerEntity.this.m_20205_() - 0.1f;
            return f * 2.0f * f * 2.0f + pAttackTarget.m_20205_();
        }
    }
}

