/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity;

import com.github.sculkhorde.common.entity.ISculkSmartEntity;
import com.github.sculkhorde.common.entity.goal.TargetAttacker;
import com.github.sculkhorde.common.entity.infection.CursorSurfaceInfectorEntity;
import com.github.sculkhorde.core.EffectRegistry;
import com.github.sculkhorde.core.EntityRegistry;
import com.github.sculkhorde.core.ParticleRegistry;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.util.EntityAlgorithms;
import com.github.sculkhorde.util.TargetParameters;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SculkSporeSpewerEntity
extends Monster
implements GeoEntity,
ISculkSmartEntity {
    public static final float MAX_HEALTH = 40.0f;
    public static final float ARMOR = 10.0f;
    public static final float ATTACK_DAMAGE = 0.0f;
    public static final float ATTACK_KNOCKBACK = 0.0f;
    public static final float FOLLOW_RANGE = 0.0f;
    public static final float MOVEMENT_SPEED = 0.0f;
    private TargetParameters TARGET_PARAMETERS = new TargetParameters((Mob)this).enableTargetPassives();
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private CursorSurfaceInfectorEntity cursor;
    private long INFECTION_INTERVAL_MILLIS = TimeUnit.SECONDS.toMillis(20L);
    private long lastInfectionTime = 0L;
    private boolean isParticipatingInRaid = false;

    public SculkSporeSpewerEntity(EntityType<? extends SculkSporeSpewerEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public SculkSporeSpewerEntity(Level worldIn) {
        super((EntityType)EntityRegistry.SCULK_SPORE_SPEWER.get(), worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22277_, 0.0).m_22268_(Attributes.f_22279_, 0.0);
    }

    public void m_6043_() {
    }

    @Override
    public boolean isIdle() {
        return false;
    }

    @Override
    public boolean isParticipatingInRaid() {
        return this.isParticipatingInRaid;
    }

    @Override
    public void setParticipatingInRaid(boolean isParticipatingInRaidIn) {
        this.isParticipatingInRaid = isParticipatingInRaidIn;
    }

    @Override
    public TargetParameters getTargetParameters() {
        return this.TARGET_PARAMETERS;
    }

    public void m_8099_() {
        Goal[] goalSelectorPayload = this.goalSelectorPayload();
        for (int priority = 0; priority < goalSelectorPayload.length; ++priority) {
            this.f_21345_.m_25352_(priority, goalSelectorPayload[priority]);
        }
        Goal[] targetSelectorPayload = this.targetSelectorPayload();
        for (int priority = 0; priority < targetSelectorPayload.length; ++priority) {
            this.f_21346_.m_25352_(priority, targetSelectorPayload[priority]);
        }
    }

    public Goal[] goalSelectorPayload() {
        Goal[] goals = new Goal[]{new dieAfterTimeGoal(this)};
        return goals;
    }

    public Goal[] targetSelectorPayload() {
        Goal[] goals = new Goal[]{new TargetAttacker((PathfinderMob)this, new Class[0]).setAlertAllies(new Class[0])};
        return goals;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericIdleController((GeoAnimatable)this)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19853_.f_46443_) {
            Random random = new Random();
            for (int i = 0; i < 1; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleRegistry.SCULK_CRUST_PARTICLE.get(), this.m_20182_().f_82479_, this.m_20182_().f_82480_ + 1.7, this.m_20182_().f_82481_, (random.nextDouble() - 0.5) * 3.0, (random.nextDouble() - 0.5) * 3.0, (random.nextDouble() - 0.5) * 3.0);
            }
            return;
        }
        Random random = new Random();
        if (!(random.nextInt(100) != 0 || this.cursor != null && this.cursor.m_6084_())) {
            this.cursor = new CursorSurfaceInfectorEntity(this.f_19853_);
            this.cursor.m_6034_(this.m_20183_().m_123341_(), this.m_20183_().m_123342_() - 1, this.m_20183_().m_123343_());
            this.cursor.setMaxInfections(100);
            this.cursor.setMaxRange(100);
            this.cursor.setTickIntervalMilliseconds(10L);
            this.cursor.setSearchIterationsPerTick(1);
            this.f_19853_.m_7967_((Entity)this.cursor);
        }
        if (System.currentTimeMillis() - this.lastInfectionTime > this.INFECTION_INTERVAL_MILLIS) {
            this.lastInfectionTime = System.currentTimeMillis();
            ArrayList entities = (ArrayList)EntityAlgorithms.getLivingEntitiesInBoundingBox((ServerLevel)this.f_19853_, this.m_20191_().m_82400_(10.0));
            for (LivingEntity entity : entities) {
                if (!(entity instanceof LivingEntity) || !this.getTargetParameters().isEntityValidTarget(entity, false)) continue;
                entity.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.SCULK_INFECTION.get(), 500, 3));
            }
        }
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11853_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_11855_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11854_;
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(SoundEvents.f_11856_, 0.15f, 1.0f);
    }

    public boolean m_213854_() {
        return true;
    }

    public void onRemovedFromWorld() {
        SculkHorde.savedData.addSculkAccumulatedMass((int)this.m_21223_());
        super.onRemovedFromWorld();
    }

    private class dieAfterTimeGoal
    extends Goal {
        private final SculkSporeSpewerEntity entity;
        private int timeUntilDeath = 0;

        public dieAfterTimeGoal(SculkSporeSpewerEntity entity) {
            this.entity = entity;
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8056_() {
            this.timeUntilDeath = 72000;
        }

        public void m_8037_() {
            if (SculkSporeSpewerEntity.this.f_19853_.m_5776_()) {
                return;
            }
            --this.timeUntilDeath;
            if (this.timeUntilDeath <= 0) {
                this.entity.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }
}

