/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity;

import com.github.sculkhorde.common.entity.ISculkSmartEntity;
import com.github.sculkhorde.common.entity.goal.DespawnWhenIdle;
import com.github.sculkhorde.common.entity.goal.InvalidateTargetGoal;
import com.github.sculkhorde.common.entity.goal.NearestLivingEntityTargetGoal;
import com.github.sculkhorde.common.entity.goal.PathFindToRaidLocation;
import com.github.sculkhorde.common.entity.goal.TargetAttacker;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.util.TargetParameters;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SculkVindicatorEntity
extends Monster
implements GeoEntity,
ISculkSmartEntity {
    public static final float MAX_HEALTH = 10.0f;
    public static final float ARMOR = 10.0f;
    public static final float ATTACK_DAMAGE = 22.0f;
    public static final float ATTACK_KNOCKBACK = 1.0f;
    public static final float FOLLOW_RANGE = 25.0f;
    public static final float MOVEMENT_SPEED = 0.3f;
    private TargetParameters TARGET_PARAMETERS = new TargetParameters((Mob)this).enableTargetHostiles().enableTargetInfected().enableMustReachTarget();
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean isParticipatingInRaid = false;
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("misc.idle");
    private static final RawAnimation RUN_ANIMATION = RawAnimation.begin().thenLoop("move.run");
    private static final RawAnimation WALK_ANIMATION = RawAnimation.begin().thenLoop("move.walk");
    private static final RawAnimation ATTACK_ANIMATION = RawAnimation.begin().thenPlay("attack");
    private final AnimationController LIVING_CONTROLLER = DefaultAnimations.genericLivingController((GeoAnimatable)this);

    public SculkVindicatorEntity(EntityType<? extends SculkVindicatorEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22281_, 22.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22279_, (double)0.3f);
    }

    public void m_6043_() {
    }

    @Override
    public boolean isIdle() {
        return this.m_5448_() == null;
    }

    @Override
    public boolean isParticipatingInRaid() {
        return this.isParticipatingInRaid;
    }

    @Override
    public void setParticipatingInRaid(boolean isParticipatingInRaidIn) {
        this.isParticipatingInRaid = isParticipatingInRaidIn;
    }

    @Override
    public TargetParameters getTargetParameters() {
        return this.TARGET_PARAMETERS;
    }

    public void m_8099_() {
        Goal[] goalSelectorPayload = this.goalSelectorPayload();
        for (int priority = 0; priority < goalSelectorPayload.length; ++priority) {
            this.f_21345_.m_25352_(priority, goalSelectorPayload[priority]);
        }
        Goal[] targetSelectorPayload = this.targetSelectorPayload();
        for (int priority = 0; priority < targetSelectorPayload.length; ++priority) {
            this.f_21346_.m_25352_(priority, targetSelectorPayload[priority]);
        }
    }

    public Goal[] goalSelectorPayload() {
        Goal[] goals = new Goal[]{new DespawnWhenIdle(this, 120), new OpenDoorGoal((Mob)this, true), new FloatGoal((Mob)this), new SculkVindicatorAttackGoal((PathfinderMob)this, 1.0, false), new PathFindToRaidLocation<SculkVindicatorEntity>(this), new MoveTowardsTargetGoal((PathfinderMob)this, (double)0.8f, 20.0f), new WaterAvoidingRandomStrollGoal((PathfinderMob)this, (double)0.8f)};
        return goals;
    }

    public Goal[] targetSelectorPayload() {
        Goal[] goals = new Goal[]{new InvalidateTargetGoal(this), new TargetAttacker((PathfinderMob)this, new Class[0]).setAlertAllies(new Class[0]), new NearestLivingEntityTargetGoal((Mob)this, true, true)};
        return goals;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        this.LIVING_CONTROLLER.setTransitionLength(5);
        controllers.add(new AnimationController[]{this.LIVING_CONTROLLER, new AnimationController((GeoAnimatable)this, "Walk_cycle", 5, this::poseWalkCycle), DefaultAnimations.genericAttackAnimation((LivingEntity)this, (RawAnimation)ATTACK_ANIMATION)});
    }

    protected PlayState poseWalkCycle(AnimationState<SculkVindicatorEntity> state2) {
        if (!state2.isMoving()) {
            state2.setAnimation(IDLE_ANIMATION);
        } else if (!((SculkVindicatorEntity)state2.getAnimatable()).m_20142_()) {
            state2.setAnimation(WALK_ANIMATION);
        } else if (((SculkVindicatorEntity)state2.getAnimatable()).m_20142_()) {
            state2.setAnimation(RUN_ANIMATION);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12307_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12310_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12309_;
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(SoundEvents.f_11875_, 0.15f, 1.0f);
    }

    public boolean m_213854_() {
        return true;
    }

    public void onRemovedFromWorld() {
        SculkHorde.savedData.addSculkAccumulatedMass((int)this.m_21223_());
        super.onRemovedFromWorld();
    }

    public class SculkVindicatorAttackGoal
    extends MeleeAttackGoal {
        public SculkVindicatorAttackGoal(PathfinderMob p_25552_, double p_25553_, boolean p_25554_) {
            super(p_25552_, p_25553_, p_25554_);
        }

        public void m_8056_() {
            super.m_8056_();
            SculkVindicatorEntity.this.m_6858_(true);
        }

        public void m_8041_() {
            super.m_8056_();
            SculkVindicatorEntity.this.m_6858_(false);
        }
    }
}

