/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.attack;

import com.github.sculkhorde.common.entity.projectile.CustomItemProjectileEntity;
import com.github.sculkhorde.util.ProjectileHelper;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;

public abstract class RangedAttack {
    public Mob thisMob;
    public double xOffSetModifier = 2.0;
    public double entityHeightFraction = 0.5;
    public double zOffSetModifier = 2.0;
    public float damage = 1.0f;
    public double accuracy = 0.95;

    public RangedAttack(Mob parentEntity) {
        this.thisMob = parentEntity;
    }

    public RangedAttack(Mob parentEntity, double xOffSetModifier, double entityHeightFraction, double zOffSetModifier, float damage) {
        this.thisMob = parentEntity;
        this.xOffSetModifier = xOffSetModifier;
        this.entityHeightFraction = entityHeightFraction;
        this.zOffSetModifier = zOffSetModifier;
        this.damage = damage;
    }

    public abstract CustomItemProjectileEntity getProjectile(Level var1, LivingEntity var2, float var3);

    public RangedAttack setProjectileOriginOffset(double x, double entityHeightFraction, double z) {
        this.xOffSetModifier = x;
        this.entityHeightFraction = entityHeightFraction;
        this.zOffSetModifier = z;
        return this;
    }

    public RangedAttack setDamage(float damage) {
        this.damage = damage;
        return this;
    }

    public RangedAttack setAccuracy(double accuracy) {
        this.accuracy = accuracy;
        return this;
    }

    public double rollAccuracy(double directional) {
        return directional + (1.0 - this.accuracy) * directional * this.thisMob.m_217043_().m_188583_();
    }

    public void shoot() {
        LivingEntity targetEntity = this.thisMob.m_5448_();
        CustomItemProjectileEntity projectile = this.getProjectile(this.thisMob.f_19853_, (LivingEntity)this.thisMob, this.damage);
        double d0 = targetEntity.m_20185_() - this.thisMob.m_20185_();
        double d1 = targetEntity.m_20188_() - projectile.m_20186_();
        double d2 = targetEntity.m_20189_() - this.thisMob.m_20189_();
        double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
        if (d3 > 40.0) {
            return;
        }
        double velocity = 1.6;
        d1 = ProjectileHelper.computeY(d3, d1, velocity, projectile.m_20186_(), targetEntity.m_20186_(), targetEntity.m_20188_() - targetEntity.m_20186_());
        float inaccuracy = 0.0f;
        projectile.m_6686_(d0, d1, d2, (float)velocity, inaccuracy);
        this.thisMob.m_5496_(SoundEvents.f_12479_, 1.0f, 1.0f);
        this.thisMob.f_19853_.m_7967_((Entity)projectile);
    }
}

