/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.goal;

import com.github.sculkhorde.common.entity.SculkCreeperEntity;
import com.github.sculkhorde.core.BlockRegistry;
import com.github.sculkhorde.core.ItemRegistry;
import com.github.sculkhorde.util.TickUnits;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class BlowUpPriorityBlockGoal
extends MoveToBlockGoal {
    protected final TagKey<Block> blockWithTagToRemove = BlockRegistry.Tags.SCULK_RAID_TARGET_HIGH_PRIORITY;
    protected final SculkCreeperEntity removerMob;
    protected int ticksSinceReachedGoal;
    protected static final int WAIT_AFTER_BLOCK_FOUND = 20;
    protected int distanceRequired;
    protected int ticksRequiredToBreakBlock;
    protected int COOLDOWN_BETWEEN_BLOCK_SEARCH;
    protected int ticksSinceLastSearch = this.COOLDOWN_BETWEEN_BLOCK_SEARCH = TickUnits.convertSecondsToTicks(5);

    public BlowUpPriorityBlockGoal(SculkCreeperEntity sculkCreeperEntity, double p_25842_, int p_25843_, int distanceRequired, int ticksRequiredToBreakBlock) {
        super((PathfinderMob)sculkCreeperEntity, p_25842_, 24, p_25843_);
        this.removerMob = sculkCreeperEntity;
        this.distanceRequired = distanceRequired;
        this.ticksRequiredToBreakBlock = ticksRequiredToBreakBlock;
    }

    public boolean m_8036_() {
        ++this.ticksSinceLastSearch;
        if (this.ticksSinceLastSearch >= this.COOLDOWN_BETWEEN_BLOCK_SEARCH) {
            this.m_25626_();
            this.ticksSinceLastSearch = 0;
        }
        if (!ForgeEventFactory.getMobGriefingEvent((Level)this.removerMob.f_19853_, (Entity)this.removerMob)) {
            return false;
        }
        if (!this.removerMob.isParticipatingInRaid()) {
            return false;
        }
        return this.f_25602_ != null && this.f_25602_ != BlockPos.f_121853_;
    }

    public void m_8041_() {
        super.m_8041_();
    }

    public void m_8056_() {
        super.m_8056_();
    }

    public void playDestroyProgressSound(LevelAccessor level, BlockPos blockPos) {
    }

    public void playBreakSound(Level level, BlockPos blockPos) {
    }

    public void m_8037_() {
        super.m_8037_();
        Level level = this.removerMob.f_19853_;
        BlockPos mobPosition = this.removerMob.m_20183_();
        BlockPos blockPosition = this.f_25602_;
        RandomSource randomsource = this.removerMob.m_217043_();
        if (blockPosition == null) {
            return;
        }
        if (!blockPosition.m_123314_((Vec3i)mobPosition, (double)this.distanceRequired)) {
            this.ticksSinceReachedGoal = 0;
            return;
        }
        ++this.ticksSinceReachedGoal;
        if (this.ticksSinceReachedGoal > 0) {
            Vec3 vec3 = this.removerMob.m_20184_();
            this.removerMob.m_20334_(vec3.f_82479_, 0.3, vec3.f_82481_);
            this.removerMob.m_32283_(1);
            if (!level.f_46443_) {
                ((ServerLevel)level).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)ItemRegistry.SCULK_MATTER.get())), (double)blockPosition.m_123341_() + 0.5, (double)blockPosition.m_123342_() + 0.7, (double)blockPosition.m_123343_() + 0.5, 3, ((double)randomsource.m_188501_() - 0.5) * 0.08, ((double)randomsource.m_188501_() - 0.5) * 0.08, ((double)randomsource.m_188501_() - 0.5) * 0.08, (double)0.15f);
            }
        }
        if (this.ticksSinceReachedGoal % 2 == 0) {
            Vec3 vec31 = this.removerMob.m_20184_();
            this.removerMob.m_20334_(vec31.f_82479_, -0.3, vec31.f_82481_);
            if (this.ticksSinceReachedGoal % 6 == 0) {
                this.playDestroyProgressSound((LevelAccessor)level, this.f_25602_);
            }
        }
        if (this.ticksSinceReachedGoal > this.ticksRequiredToBreakBlock) {
            this.removerMob.explodeSculkCreeper();
            level.m_46961_(blockPosition, true);
            if (!level.f_46443_) {
                for (int i = 0; i < 20; ++i) {
                    double d3 = randomsource.m_188583_() * 0.02;
                    double d1 = randomsource.m_188583_() * 0.02;
                    double d2 = randomsource.m_188583_() * 0.02;
                    ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123759_, (double)blockPosition.m_123341_() + 0.5, (double)blockPosition.m_123342_(), (double)blockPosition.m_123343_() + 0.5, 1, d3, d1, d2, (double)0.15f);
                }
                this.playBreakSound(level, blockPosition);
            }
        }
    }

    protected boolean m_6465_(LevelReader levelReader, BlockPos blockPos) {
        ChunkAccess chunkaccess = levelReader.m_6522_(SectionPos.m_123171_((int)blockPos.m_123341_()), SectionPos.m_123171_((int)blockPos.m_123343_()), ChunkStatus.f_62326_, false);
        if (chunkaccess == null) {
            return false;
        }
        return chunkaccess.m_8055_(blockPos).m_204336_(BlockRegistry.Tags.SCULK_RAID_TARGET_HIGH_PRIORITY) || chunkaccess.m_8055_(blockPos).m_204336_(BlockRegistry.Tags.SCULK_RAID_TARGET_MEDIUM_PRIORITY) || chunkaccess.m_8055_(blockPos).m_204336_(BlockRegistry.Tags.SCULK_RAID_TARGET_LOW_PRIORITY);
    }
}

