/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.goal;

import com.github.sculkhorde.common.entity.ISculkSmartEntity;
import com.github.sculkhorde.util.BlockAlgorithms;
import com.github.sculkhorde.util.TargetParameters;
import java.util.EnumSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;

public class InvalidateTargetGoal
extends Goal {
    private final ISculkSmartEntity mob;
    private UUID lastTargetUUID;
    private long timeSinceLastTargetChange;
    private BlockPos ourLastPositionSinceCheck;
    private long UNREACHABLE_TARGET_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);
    private long lastTimeSincePositionCheck = System.currentTimeMillis();
    private long POSITION_CHECK_INTERVAL = TimeUnit.SECONDS.toMillis(5L);

    public InvalidateTargetGoal(ISculkSmartEntity mob) {
        this.mob = mob;
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
    }

    public Mob getMob() {
        return (Mob)this.mob;
    }

    public LivingEntity getTarget() {
        return this.getMob().m_5448_();
    }

    private boolean hasTargetChanged() {
        if (this.getTarget() == null) {
            return false;
        }
        if (this.lastTargetUUID == null || !this.lastTargetUUID.equals(this.getTarget().m_20148_())) {
            this.lastTargetUUID = this.getTarget().m_20148_();
            this.timeSinceLastTargetChange = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    private boolean tooCloseToLastPosition() {
        return BlockAlgorithms.getBlockDistance(this.ourLastPositionSinceCheck, this.getMob().m_20183_()) < 5.0f;
    }

    public boolean m_8036_() {
        if (this.getTarget() == null) {
            return false;
        }
        TargetParameters targetParameters = this.mob.getTargetParameters();
        if (System.currentTimeMillis() - this.lastTimeSincePositionCheck > this.POSITION_CHECK_INTERVAL) {
            this.ourLastPositionSinceCheck = this.getMob().m_20183_();
            this.lastTimeSincePositionCheck = System.currentTimeMillis();
        }
        if (targetParameters.canBlackListMobs() && this.getTarget() instanceof Mob && !this.hasTargetChanged() && System.currentTimeMillis() - this.timeSinceLastTargetChange > this.UNREACHABLE_TARGET_TIMEOUT && this.tooCloseToLastPosition()) {
            targetParameters.addToBlackList((Mob)this.getTarget());
        }
        boolean result = !targetParameters.isEntityValidTarget(this.getTarget(), true);
        return result;
    }

    public void m_8056_() {
        this.getMob().m_6710_(null);
        this.getMob().m_5448_();
    }

    public boolean m_8045_() {
        return false;
    }
}

