/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.goal;

import com.github.sculkhorde.util.EntityAlgorithms;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TargetAttacker
extends TargetGoal {
    private static final TargetingConditions HURT_BY_TARGETING = TargetingConditions.m_148352_().m_26893_();
    private boolean alertSameType;
    private int timestamp;
    private final Class<?>[] toIgnoreDamage;
    private Class<?>[] toIgnoreAlert;

    public TargetAttacker(PathfinderMob sourceEntity, Class<?> ... p_i50317_2_) {
        super((Mob)sourceEntity, true);
        this.toIgnoreDamage = p_i50317_2_;
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
    }

    public TargetAttacker setAlertAllies(Class<?> ... pReinforcementTypes) {
        this.alertSameType = true;
        this.toIgnoreAlert = pReinforcementTypes;
        return this;
    }

    public boolean m_8036_() {
        int i = this.f_26135_.m_21213_();
        LivingEntity livingentity = this.f_26135_.m_21188_();
        if (EntityAlgorithms.isSculkLivingEntity.test(livingentity)) {
            return false;
        }
        if (i != this.timestamp && livingentity != null) {
            if (livingentity.m_6095_() == EntityType.f_20532_ && this.f_26135_.f_19853_.m_46469_().m_46207_(GameRules.f_46127_)) {
                return false;
            }
            for (Class<?> oclass : this.toIgnoreDamage) {
                if (!oclass.isAssignableFrom(livingentity.getClass())) continue;
                return false;
            }
            return this.m_26150_(livingentity, HURT_BY_TARGETING);
        }
        return false;
    }

    public void m_8056_() {
        this.f_26135_.m_6710_(this.f_26135_.m_21188_());
        this.f_26137_ = this.f_26135_.m_5448_();
        this.timestamp = this.f_26135_.m_21213_();
        this.f_26138_ = 60;
        if (this.alertSameType) {
            this.alertSculkLivingEntities();
        }
        super.m_8056_();
    }

    protected void alertSculkLivingEntities() {
        boolean DEBUG_THIS = false;
        double d0 = this.m_7623_();
        AABB axisalignedbb = AABB.m_82333_((Vec3)this.f_26135_.m_20182_()).m_82377_(d0, 10.0, d0);
        List list = this.f_26135_.f_19853_.m_45976_(Mob.class, axisalignedbb);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Mob mobentity = (Mob)iterator.next();
            boolean isAlertingSelf = this.f_26135_ == mobentity;
            boolean hasTargetAlready = mobentity.m_5448_() != null;
            boolean isProtector = EntityAlgorithms.isSculkLivingEntity.test((LivingEntity)mobentity);
            if (DEBUG_THIS) {
                System.out.println("Attempting to Call Protectors");
                System.out.println("[ isAlertingSelf? = " + isAlertingSelf + " hasTargetAlready? =" + hasTargetAlready + " isProtector? =" + isProtector + "]");
            }
            if (isAlertingSelf || hasTargetAlready || !isProtector) continue;
            this.alertOther(mobentity, this.f_26135_.m_21188_());
        }
        return;
    }

    protected void alertOther(Mob pMob, LivingEntity pTarget) {
        pMob.m_6710_(pTarget);
    }
}

