/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.infection;

import com.github.sculkhorde.common.block.SculkLivingRockBlock;
import com.github.sculkhorde.core.BlockRegistry;
import com.github.sculkhorde.core.EntityRegistry;
import com.github.sculkhorde.util.BlockAlgorithms;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;

public class CursorBridgerEntity
extends Entity {
    private int MAX_DISTANCE = 1000;
    private int distanceTraveled = 0;
    private Direction direction = Direction.DOWN;
    private long MAX_LIFETIME_SECONDS = 10L;
    private long creationTickTime = System.nanoTime();
    private long lastTickTime = 0L;
    private long TICK_INVTERVAL_SECONDS = 5L;
    public BlockPos lastKnownBlockPos = BlockPos.f_121853_;
    public boolean isSuccessful = false;

    public CursorBridgerEntity(Level worldIn) {
        super((EntityType)EntityRegistry.CURSOR_BRIDGER.get(), worldIn);
    }

    public CursorBridgerEntity(EntityType<?> pType, Level pLevel) {
        super(pType, pLevel);
        this.distanceTraveled = 0;
        this.creationTickTime = System.nanoTime();
    }

    public void setMAX_DISTANCE(int MAX_DISTANCE) {
        this.MAX_DISTANCE = MAX_DISTANCE;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        super.m_8119_();
        float timeElapsed = TimeUnit.SECONDS.convert(System.nanoTime() - this.lastTickTime, TimeUnit.NANOSECONDS);
        if (timeElapsed < (float)this.TICK_INVTERVAL_SECONDS) {
            // empty if block
        }
        this.lastTickTime = System.nanoTime();
        if (this.f_19853_.f_46443_) {
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
            return;
        }
        long currentLifeTime = TimeUnit.SECONDS.convert(System.nanoTime() - this.creationTickTime, TimeUnit.NANOSECONDS);
        if (currentLifeTime >= this.MAX_LIFETIME_SECONDS || this.distanceTraveled >= this.MAX_DISTANCE) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        ArrayList<BlockPos> neighbors = BlockAlgorithms.getAdjacentNeighbors(this.m_20183_());
        BlockPos closest = neighbors.get(0);
        for (BlockPos pos : neighbors) {
            closest = pos;
            if (!this.f_19853_.m_8055_(closest).m_60795_()) continue;
            this.f_19853_.m_46597_(closest, ((SculkLivingRockBlock)((Object)BlockRegistry.SCULK_LIVING_ROCK_BLOCK.get())).m_49966_());
        }
        this.m_6034_(closest.m_123341_(), closest.m_123342_(), closest.m_123343_());
        this.lastKnownBlockPos = this.m_20183_();
        if (this.f_19853_.m_8055_(this.m_20183_()).m_60800_((BlockGetter)this.f_19853_, this.m_20183_()) <= 3.0f) {
            this.f_19853_.m_46597_(this.m_20183_(), ((SculkLivingRockBlock)((Object)BlockRegistry.SCULK_LIVING_ROCK_BLOCK.get())).m_49966_());
        }
        ++this.distanceTraveled;
    }

    protected void m_7378_(CompoundTag pCompound) {
    }

    protected void m_7380_(CompoundTag pCompound) {
    }
}

