/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.infection;

import com.github.sculkhorde.core.EntityRegistry;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.util.BlockAlgorithms;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class CursorInfectorEntity
extends Entity {
    State state = State.IDLE;
    protected int MAX_INFECTIONS = 100;
    protected int infections = 0;
    protected int MAX_RANGE = 20;
    protected long MAX_LIFETIME_MILLIS = TimeUnit.SECONDS.toMillis(300L);
    protected long creationTickTime = System.currentTimeMillis();
    protected long lastTickTime = 0L;
    protected int searchIterationsPerTick = 20;
    protected long tickIntervalMilliseconds = 1000L;
    protected BlockPos origin = BlockPos.f_121853_;
    protected BlockPos target = BlockPos.f_121853_;
    Queue<BlockPos> queue = new LinkedList<BlockPos>();
    public boolean isSuccessful = false;
    protected HashMap<Long, Boolean> visitedPositons = new HashMap();

    public CursorInfectorEntity(Level worldIn) {
        super((EntityType)EntityRegistry.CURSOR_INFECTOR.get(), worldIn);
    }

    public CursorInfectorEntity(EntityType<?> pType, Level pLevel) {
        super(pType, pLevel);
        this.creationTickTime = System.currentTimeMillis();
    }

    public void setMaxInfections(int MAX_INFECTIONS) {
        this.MAX_INFECTIONS = MAX_INFECTIONS;
    }

    public void setMaxRange(int MAX_RANGE) {
        this.MAX_RANGE = MAX_RANGE;
    }

    public void setMaxLifeTimeMillis(long MAX_LIFETIME) {
        this.MAX_LIFETIME_MILLIS = MAX_LIFETIME;
    }

    public void setSearchIterationsPerTick(int iterations) {
        this.searchIterationsPerTick = iterations;
    }

    public void setTickIntervalMilliseconds(long milliseconds) {
        this.tickIntervalMilliseconds = milliseconds;
    }

    protected void m_8097_() {
    }

    protected boolean searchTick() {
        for (int i = 0; i < this.searchIterationsPerTick; ++i) {
            if (this.queue.isEmpty()) {
                this.isSuccessful = false;
                this.target = BlockPos.f_121853_;
                return true;
            }
            BlockPos currentBlock = this.queue.poll();
            if (this.isTarget(this.f_19853_.m_8055_(currentBlock), currentBlock)) {
                this.isSuccessful = true;
                this.target = currentBlock;
                return true;
            }
            ArrayList<BlockPos> possiblePaths = BlockAlgorithms.getNeighborsCube(currentBlock, false);
            Collections.shuffle(possiblePaths);
            for (BlockPos neighbor : possiblePaths) {
                if (this.visitedPositons.containsKey(neighbor.m_121878_()) || this.isObstructed(this.f_19853_.m_8055_(neighbor), neighbor)) continue;
                this.queue.add(neighbor);
                this.visitedPositons.put(neighbor.m_121878_(), true);
            }
        }
        return false;
    }

    public void m_8119_() {
        long currentLifeTimeMilliseconds;
        super.m_8119_();
        float timeElapsedMilliSeconds = System.currentTimeMillis() - this.lastTickTime;
        if (timeElapsedMilliSeconds < (float)this.tickIntervalMilliseconds) {
            return;
        }
        this.lastTickTime = System.currentTimeMillis();
        if (this.f_19853_.f_46443_) {
            for (int i = 0; i < 2; ++i) {
                this.spawnParticleEffects();
            }
            return;
        }
        if (this.origin == BlockPos.f_121853_) {
            this.origin = this.m_20183_();
        }
        if ((currentLifeTimeMilliseconds = System.currentTimeMillis() - this.creationTickTime) >= this.MAX_LIFETIME_MILLIS) {
            this.state = State.FINISHED;
        } else if (this.infections >= this.MAX_INFECTIONS) {
            this.state = State.FINISHED;
        }
        if (this.state == State.IDLE) {
            this.queue.add(this.m_20183_());
            this.state = State.SEARCHING;
        } else if (this.state == State.SEARCHING) {
            if (!this.searchTick()) {
                return;
            }
            if (this.target.equals((Object)BlockPos.f_121853_)) {
                this.state = State.FINISHED;
            } else {
                this.state = State.EXPLORING;
                this.visitedPositons.clear();
            }
        } else if (this.state == State.EXPLORING) {
            ArrayList<BlockPos> neighbors = BlockAlgorithms.getNeighborsCube(this.m_20183_(), false);
            ArrayList<BlockPos> unobstructedNeighbors = new ArrayList<BlockPos>();
            for (BlockPos neighbor : neighbors) {
                if (this.isObstructed(this.f_19853_.m_8055_(neighbor), neighbor)) continue;
                unobstructedNeighbors.add(neighbor);
            }
            if (neighbors.size() == 0) {
                return;
            }
            BlockPos closest = neighbors.get(0);
            for (BlockPos pos : neighbors) {
                if (!(BlockAlgorithms.getBlockDistance(pos, this.target) < BlockAlgorithms.getBlockDistance(closest, this.target))) continue;
                closest = pos;
            }
            this.m_6034_(closest.m_123341_(), closest.m_123342_(), closest.m_123343_());
            this.visitedPositons.put(closest.m_121878_(), true);
            if (this.m_20183_().equals((Object)this.target)) {
                this.target = BlockPos.f_121853_;
                this.transformBlock(this.m_20183_());
                ++this.infections;
                this.state = State.SEARCHING;
                this.visitedPositons.clear();
                this.queue.clear();
                this.queue.add(this.m_20183_());
            }
        } else if (this.state == State.FINISHED) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected boolean isObstructed(BlockState state2, BlockPos pos) {
        if (!state2.m_60804_((BlockGetter)this.f_19853_, pos)) {
            return true;
        }
        if (BlockAlgorithms.getBlockDistance(this.origin, pos) > (float)this.MAX_RANGE) {
            return true;
        }
        if (state2.m_60795_()) {
            return true;
        }
        return this.visitedPositons.containsKey(pos.m_121878_());
    }

    protected boolean isTarget(BlockState state2, BlockPos pos) {
        return SculkHorde.infestationConversionTable.infestationTable.isNormalVariant(state2);
    }

    protected void transformBlock(BlockPos pos) {
        SculkHorde.infestationConversionTable.infectBlock((ServerLevel)this.f_19853_, pos);
    }

    protected void spawnParticleEffects() {
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_235898_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.1, 0.0);
    }

    protected void m_7378_(CompoundTag pCompound) {
    }

    protected void m_7380_(CompoundTag pCompound) {
    }

    public void setTarget(BlockPos target) {
        this.target = target;
    }

    static enum State {
        IDLE,
        SEARCHING,
        EXPLORING,
        FINISHED;

    }
}

