/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.infection;

import com.github.sculkhorde.common.block.SculkLivingRockBlock;
import com.github.sculkhorde.core.BlockRegistry;
import com.github.sculkhorde.core.EntityRegistry;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.util.BlockAlgorithms;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Stack;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;

public class CursorProberEntity
extends Entity {
    private int MAX_DISTANCE = 1000;
    private int distanceTraveled = 0;
    private BlockPos target = BlockPos.f_121853_;
    private Direction direction = Direction.DOWN;
    private long MAX_LIFETIME_SECONDS = 10L;
    private long creationTickTime = System.nanoTime();
    private long lastTickTime = 0L;
    private long TICK_INVTERVAL_SECONDS = 5L;
    public BlockPos lastKnownBlockPos = BlockPos.f_121853_;
    public boolean isSuccessful = false;

    public CursorProberEntity(Level worldIn) {
        super((EntityType)EntityRegistry.CURSOR_PROBER.get(), worldIn);
    }

    public CursorProberEntity(EntityType<?> pType, Level pLevel) {
        super(pType, pLevel);
        this.distanceTraveled = 0;
        this.creationTickTime = System.nanoTime();
    }

    public void setMAX_DISTANCE(int MAX_DISTANCE) {
        this.MAX_DISTANCE = MAX_DISTANCE;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    protected void m_8097_() {
    }

    private BlockPos findNearestTargetBlockDepthFirstSearch(Direction direction) {
        BlockPos origin = this.m_20183_();
        int nodesVisited = 0;
        Stack<BlockPos> stack = new Stack<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        stack.push(origin);
        visited.add(origin);
        while (!stack.isEmpty()) {
            BlockPos currentBlock = (BlockPos)stack.pop();
            ++nodesVisited;
            if (SculkHorde.infestationConversionTable.infestationTable.isNormalVariant(this.f_19853_.m_8055_(currentBlock))) {
                return currentBlock;
            }
            if (BlockAlgorithms.getBlockDistance(currentBlock, origin) > (float)this.MAX_DISTANCE) break;
            ArrayList<Direction> possibleDirections = new ArrayList<Direction>();
            if (Math.random() < 0.25 && this.f_19853_.m_8055_(currentBlock.m_121945_(direction)).m_60804_((BlockGetter)this.f_19853_, currentBlock.m_121945_(direction))) {
                possibleDirections.add(direction);
            } else {
                possibleDirections.addAll(Arrays.asList(Direction.values()));
                possibleDirections.removeIf(dir -> !this.f_19853_.m_8055_(currentBlock.m_121945_(dir)).m_60804_((BlockGetter)this.f_19853_, currentBlock.m_121945_(dir)));
            }
            for (Direction dir2 : possibleDirections) {
                BlockPos neighbor = currentBlock.m_121945_(dir2);
                if (visited.contains(neighbor)) continue;
                stack.push(neighbor);
                visited.add(neighbor);
            }
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
        this.isSuccessful = false;
        return BlockPos.f_121853_;
    }

    public void m_8119_() {
        super.m_8119_();
        float timeElapsed = TimeUnit.SECONDS.convert(System.nanoTime() - this.lastTickTime, TimeUnit.NANOSECONDS);
        if (timeElapsed < (float)this.TICK_INVTERVAL_SECONDS) {
            // empty if block
        }
        this.lastTickTime = System.nanoTime();
        if (this.f_19853_.f_46443_) {
            for (int i = 0; i < 2; ++i) {
            }
            return;
        }
        long currentLifeTime = TimeUnit.SECONDS.convert(System.nanoTime() - this.creationTickTime, TimeUnit.NANOSECONDS);
        if (currentLifeTime >= this.MAX_LIFETIME_SECONDS || this.distanceTraveled >= this.MAX_DISTANCE) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (this.target.equals((Object)BlockPos.f_121853_)) {
            this.target = this.findNearestTargetBlockDepthFirstSearch(this.direction);
        }
        ArrayList<BlockPos> neighbors = BlockAlgorithms.getAdjacentNeighbors(this.m_20183_());
        BlockPos closest = neighbors.get(0);
        for (BlockPos pos : neighbors) {
            if (!(BlockAlgorithms.getBlockDistance(pos, this.target) < BlockAlgorithms.getBlockDistance(closest, this.target))) continue;
            closest = pos;
        }
        if (this.f_19853_.m_8055_(this.m_20183_()).m_60795_()) {
            this.f_19853_.m_46597_(this.m_20183_(), ((SculkLivingRockBlock)((Object)BlockRegistry.SCULK_LIVING_ROCK_BLOCK.get())).m_49966_());
        }
        if (this.target.equals((Object)BlockPos.f_121853_)) {
            this.isSuccessful = false;
            return;
        }
        this.m_6034_(closest.m_123341_(), closest.m_123342_(), closest.m_123343_());
        this.lastKnownBlockPos = this.m_20183_();
        SculkHorde.infestationConversionTable.infectBlock((ServerLevel)this.f_19853_, this.m_20183_());
        ++this.distanceTraveled;
        if (this.m_20183_().equals((Object)this.target)) {
            this.isSuccessful = true;
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void m_7378_(CompoundTag pCompound) {
    }

    protected void m_7380_(CompoundTag pCompound) {
    }

    public void setTarget(BlockPos target) {
        this.target = target;
    }
}

