/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.infection;

import com.github.sculkhorde.common.entity.infection.CursorSurfaceInfectorEntity;
import com.github.sculkhorde.core.BlockRegistry;
import com.github.sculkhorde.core.EntityRegistry;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.util.BlockAlgorithms;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class CursorSurfacePurifierEntity
extends CursorSurfaceInfectorEntity {
    public static Predicate<BlockState> isSculkFlora = b -> {
        if (b.m_60713_((Block)BlockRegistry.GRASS.get())) {
            return true;
        }
        if (b.m_60713_((Block)BlockRegistry.GRASS_SHORT.get())) {
            return true;
        }
        if (b.m_60713_((Block)BlockRegistry.SMALL_SHROOM.get())) {
            return true;
        }
        if (b.m_60713_((Block)BlockRegistry.SCULK_SHROOM_CULTURE.get())) {
            return true;
        }
        if (b.m_60713_((Block)BlockRegistry.SPIKE.get())) {
            return true;
        }
        return b.m_60713_((Block)BlockRegistry.SCULK_SUMMONER_BLOCK.get());
    };

    public CursorSurfacePurifierEntity(Level worldIn) {
        super((EntityType)EntityRegistry.CURSOR_SURFACE_PURIFIER.get(), worldIn);
    }

    public CursorSurfacePurifierEntity(EntityType<?> pType, Level pLevel) {
        super(pType, pLevel);
    }

    @Override
    protected boolean isTarget(BlockState state2, BlockPos pos) {
        return SculkHorde.infestationConversionTable.infestationTable.isInfectedVariant(state2);
    }

    @Override
    protected void transformBlock(BlockPos pos) {
        SculkHorde.infestationConversionTable.deinfectBlock((ServerLevel)this.f_19853_, pos);
        if (isSculkFlora.test(this.f_19853_.m_8055_(pos.m_7494_()))) {
            this.f_19853_.m_46597_(pos.m_7494_(), Blocks.f_50034_.m_49966_());
        }
    }

    @Override
    protected void spawnParticleEffects() {
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123749_, this.m_20208_(1.5), this.m_20187_(), this.m_20262_(1.5), 0.0, 0.0, 0.0);
    }

    @Override
    protected boolean isObstructed(BlockState state2, BlockPos pos) {
        if (!state2.m_60804_((BlockGetter)this.f_19853_, pos)) {
            return true;
        }
        if (BlockAlgorithms.getBlockDistance(this.origin, pos) > (float)this.MAX_RANGE) {
            return true;
        }
        if (state2.m_60795_()) {
            return true;
        }
        if (this.visitedPositons.containsKey(pos.m_121878_())) {
            return true;
        }
        return !BlockAlgorithms.isExposedToAir((ServerLevel)this.f_19853_, pos);
    }
}

