/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.projectile;

import com.github.sculkhorde.core.EntityRegistry;
import com.github.sculkhorde.core.ItemRegistry;
import com.github.sculkhorde.util.EntityAlgorithms;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.network.NetworkHooks;

public class CustomItemProjectileEntity
extends ThrowableItemProjectile {
    private float damage = 50.0f;

    public CustomItemProjectileEntity(EntityType<? extends CustomItemProjectileEntity> entityIn, Level worldIn) {
        super(entityIn, worldIn);
    }

    public CustomItemProjectileEntity(Level worldIn, LivingEntity shooterIn, float damageIn) {
        this((EntityType<? extends CustomItemProjectileEntity>)((EntityType)EntityRegistry.CUSTOM_ITEM_PROJECTILE_ENTITY.get()), worldIn);
        this.m_6034_(shooterIn.m_20185_(), shooterIn.m_20188_(), shooterIn.m_20189_());
        this.m_5602_((Entity)shooterIn);
        this.setDamage(damageIn);
    }

    public CustomItemProjectileEntity setDamage(float damageIn) {
        this.damage = damageIn;
        return this;
    }

    protected Item m_7881_() {
        return (Item)ItemRegistry.CUSTOM_ITEM_PROJECTILE.get();
    }

    protected ParticleOptions getParticle() {
        return new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)this.m_7881_()));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_8119_() {
        Entity entity = this.m_19749_();
        if (entity instanceof Player && !entity.m_6084_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        } else {
            super.m_8119_();
        }
    }

    protected void m_5790_(EntityHitResult raytrace) {
        super.m_5790_(raytrace);
        if (!(raytrace.m_82443_() instanceof LivingEntity)) {
            return;
        }
        if (EntityAlgorithms.isSculkLivingEntity.test((LivingEntity)raytrace.m_82443_()) || this.m_19749_() == raytrace.m_82443_()) {
            return;
        }
        raytrace.m_82443_().m_6469_(this.m_269291_().m_269390_((Entity)this, this.m_19749_()), this.damage);
        this.m_5496_(SoundEvents.f_11964_, 1.0f, 1.0f + this.f_19796_.m_188501_() * 0.2f);
        if (raytrace.m_82443_() instanceof LivingEntity) {
            ((LivingEntity)raytrace.m_82443_()).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 1));
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    protected void m_8060_(BlockHitResult raytrace) {
        super.m_8060_(raytrace);
        if (!(!(this.f_19796_.m_188501_() < 0.028f) || this.m_19749_() instanceof Player && ((Player)this.m_19749_()).m_7500_())) {
            Vec3 vec = raytrace.m_82450_();
            ItemEntity item = new ItemEntity(this.f_19853_, vec.f_82479_, vec.f_82480_ + 0.25, vec.f_82481_, new ItemStack((ItemLike)this.m_7881_()));
            this.f_19853_.m_7967_((Entity)item);
        } else {
            this.m_5496_(SoundEvents.f_11964_, 1.0f, 1.0f + this.f_19796_.m_188501_() * 0.2f);
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public Entity changeDimension(ServerLevel serverWorld, ITeleporter iTeleporter) {
        Entity entity = this.m_19749_();
        if (entity != null && entity.f_19853_.m_46472_() != serverWorld.m_46472_()) {
            this.m_5602_(null);
        }
        return super.changeDimension(serverWorld, iTeleporter);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte pId) {
        if (pId == 3) {
            ParticleOptions iparticledata = this.getParticle();
            for (int i = 0; i < 8; ++i) {
                this.f_19853_.m_7106_(iparticledata, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }
}

