/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.specialeffects;

import com.github.sculkhorde.common.entity.specialeffects.SpecialEffectEntity;
import com.github.sculkhorde.core.EntityRegistry;
import com.github.sculkhorde.util.EntityAlgorithms;
import com.github.sculkhorde.util.TickUnits;
import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EnderBubbleAttackEntity
extends SpecialEffectEntity
implements GeoEntity {
    public static int LIFE_TIME = TickUnits.convertSecondsToTicks(10);
    public int currentLifeTicks = 0;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public EnderBubbleAttackEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public EnderBubbleAttackEntity(Level level) {
        super((EntityType)EntityRegistry.ENDER_BUBBLE_ATTACK.get(), level);
    }

    public EnderBubbleAttackEntity(EntityType<?> entityType, Level level, LivingEntity sourceEntity) {
        super(entityType, level, sourceEntity);
    }

    public EnderBubbleAttackEntity(Level level, LivingEntity sourceEntity) {
        super((EntityType)EntityRegistry.ENDER_BUBBLE_ATTACK.get(), level, sourceEntity);
    }

    public EnderBubbleAttackEntity enableDeleteAfterTime(int ticks) {
        LIFE_TIME = ticks;
        return this;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        ++this.currentLifeTicks;
        if (this.currentLifeTicks >= LIFE_TIME && LIFE_TIME != -1) {
            this.m_146870_();
        }
        List<LivingEntity> hitList = this.getEntitiesNearbyCube(LivingEntity.class, 3.0);
        for (LivingEntity entity : hitList) {
            if (entity == this.sourceEntity || EntityAlgorithms.isSculkLivingEntity.test(entity)) continue;
            entity.m_6469_(this.m_269291_().m_269264_(), 1.0f);
        }
    }

    protected void m_8097_() {
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericIdleController((GeoAnimatable)this)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

