/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.specialeffects;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public abstract class SpecialEffectEntity
extends Entity {
    public LivingEntity sourceEntity;
    protected boolean hasSyncedSourceEntity = false;
    private static final EntityDataAccessor<Optional<UUID>> SOURCE_ENTITY = SynchedEntityData.m_135353_(SpecialEffectEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    public SpecialEffectEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public SpecialEffectEntity(EntityType<?> entityType, Level level, LivingEntity sourceEntity) {
        super(entityType, level);
        this.sourceEntity = sourceEntity;
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public Optional<UUID> getSourceEntityID() {
        return (Optional)this.m_20088_().m_135370_(SOURCE_ENTITY);
    }

    public void setSourceEntityID(UUID id) {
        this.m_20088_().m_135381_(SOURCE_ENTITY, Optional.of(id));
    }

    public boolean m_6087_() {
        return false;
    }

    public void m_7334_(Entity entityIn) {
    }

    public void m_8119_() {
        super.m_8119_();
    }

    public void link(Entity entity) {
        if (entity instanceof LivingEntity) {
            this.sourceEntity = (LivingEntity)entity;
        }
        this.hasSyncedSourceEntity = true;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_7378_(CompoundTag compound) {
    }

    protected void m_7380_(CompoundTag compound) {
    }

    public List<LivingEntity> getEntityLivingBaseNearby(double radius) {
        return this.getEntitiesNearby(LivingEntity.class, radius);
    }

    public <T extends Entity> List<T> getEntitiesNearby(Class<T> entityClass, double r) {
        return this.f_19853_.m_6443_(entityClass, this.m_20191_().m_82377_(r, r, r), e -> e != this && (double)this.m_20270_((Entity)e) <= r + (double)(e.m_20205_() / 2.0f));
    }

    public <T extends Entity> List<T> getEntitiesNearbyCube(Class<T> entityClass, double r) {
        return this.f_19853_.m_6443_(entityClass, this.m_20191_().m_82377_(r, r, r), e -> e != this);
    }

    public boolean raytraceCheckEntity(Entity entity) {
        Vec3 from = this.m_20182_();
        int numChecks = 3;
        for (int i = 0; i < numChecks; ++i) {
            float increment = entity.m_20206_() / (float)(numChecks + 1);
            Vec3 to = entity.m_20182_().m_82520_(0.0, (double)(increment * (float)(i + 1)), 0.0);
            BlockHitResult result = this.f_19853_.m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (result.m_6662_() == HitResult.Type.BLOCK) continue;
            return true;
        }
        return false;
    }
}

