/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.procedural.structures;

import com.github.sculkhorde.core.SculkHorde;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class PlannedBlock {
    protected BlockState plannedBlock = null;
    protected BlockPos targetPos;
    protected ServerLevel world;
    protected final Predicate<BlockState> VALID_BLOCKS_TO_REPLACE = validBlocksPredicate -> SculkHorde.infestationConversionTable.infestationTable.isNormalVariant((BlockState)validBlocksPredicate) || validBlocksPredicate.m_60722_((Fluid)Fluids.f_76193_) || SculkHorde.infestationConversionTable.infestationTable.isInfectedVariant((BlockState)validBlocksPredicate) || validBlocksPredicate.m_60800_((BlockGetter)this.world, this.targetPos) <= 3.0f || validBlocksPredicate.m_60734_().equals(Blocks.f_50016_) || validBlocksPredicate.m_60734_().equals(Blocks.f_50627_);

    public PlannedBlock(ServerLevel worldIn, BlockState plannedBlockIn, BlockPos targetPosIn) {
        this.plannedBlock = plannedBlockIn;
        this.targetPos = targetPosIn;
        this.world = worldIn;
    }

    public boolean canBePlaced() {
        return this.VALID_BLOCKS_TO_REPLACE.test(this.world.m_8055_(this.targetPos));
    }

    public boolean isPlaced() {
        return this.world.m_8055_(this.targetPos).m_60713_(this.plannedBlock.m_60734_());
    }

    public void build() {
        if (this.canBePlaced()) {
            this.world.m_46597_(this.targetPos, this.plannedBlock);
        }
    }

    public BlockPos getPosition() {
        return this.targetPos;
    }
}

