/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.procedural.structures;

import com.github.sculkhorde.common.procedural.structures.PlannedBlock;
import com.github.sculkhorde.util.BlockAlgorithms;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;

public class ProceduralStructure {
    protected ServerLevel world;
    protected BlockPos origin;
    protected boolean isCurrentlyBuilding = false;
    public ArrayList<PlannedBlock> plannedBlockQueue;
    protected int currentPlannedBlockQueueIndex = 0;
    protected ArrayList<ProceduralStructure> childStructuresQueue;

    public ProceduralStructure(ServerLevel worldIn, BlockPos originIn) {
        this.origin = originIn;
        this.plannedBlockQueue = new ArrayList();
        this.childStructuresQueue = new ArrayList();
        this.world = worldIn;
    }

    public boolean isCurrentlyBuilding() {
        return this.isCurrentlyBuilding;
    }

    protected int getPlannedBlocksThatCanBePlaced() {
        int plannedBlocksThatAreAbleToBePlaced = 0;
        for (PlannedBlock entry : this.plannedBlockQueue) {
            if (!entry.canBePlaced()) continue;
            ++plannedBlocksThatAreAbleToBePlaced;
        }
        return plannedBlocksThatAreAbleToBePlaced;
    }

    protected int getPlannedBlocksPlaced() {
        int plannedBlocksPlaced = 0;
        for (PlannedBlock entry : this.plannedBlockQueue) {
            if (!entry.canBePlaced() || !entry.isPlaced()) continue;
            ++plannedBlocksPlaced;
        }
        return plannedBlocksPlaced;
    }

    protected float getBuildProgress() {
        int totalPlannedBlocksThatAreAbleToBePlaced = this.getPlannedBlocksThatCanBePlaced();
        int totalPlannedBlocksPlaced = this.getPlannedBlocksPlaced();
        for (ProceduralStructure entry : this.childStructuresQueue) {
            totalPlannedBlocksThatAreAbleToBePlaced += entry.getPlannedBlocksThatCanBePlaced();
            totalPlannedBlocksPlaced += entry.getPlannedBlocksPlaced();
        }
        if (totalPlannedBlocksThatAreAbleToBePlaced == 0) {
            return 1.0f;
        }
        return (float)totalPlannedBlocksPlaced / (float)totalPlannedBlocksThatAreAbleToBePlaced;
    }

    public boolean isStructureComplete() {
        if ((double)this.getBuildProgress() < 1.0) {
            return false;
        }
        for (ProceduralStructure childStructure : this.childStructuresQueue) {
            if (childStructure.isStructureComplete()) continue;
            return false;
        }
        return true;
    }

    public void generatePlan() {
        this.plannedBlockQueue.clear();
        for (ProceduralStructure entry : this.childStructuresQueue) {
            entry.generatePlan();
        }
    }

    public boolean canStartToBuild() {
        boolean result = true;
        if (this.isStructureComplete()) {
            result = false;
        } else if (this.plannedBlockQueue.isEmpty()) {
            result = false;
        }
        return result;
    }

    protected boolean canContinueToBuild() {
        return this.canStartToBuild() && !this.isStructureComplete();
    }

    public void startBuildProcedure() {
        if (this.canStartToBuild()) {
            this.isCurrentlyBuilding = true;
            this.currentPlannedBlockQueueIndex = 0;
            this.plannedBlockQueue.sort((block1, block2) -> Float.compare(BlockAlgorithms.getBlockDistance(block1.getPosition(), this.origin), BlockAlgorithms.getBlockDistance(block2.getPosition(), this.origin)));
        }
    }

    public void stopBuildProcedure() {
        this.isCurrentlyBuilding = false;
    }

    public void buildTick() {
        if (!this.isCurrentlyBuilding) {
            return;
        }
        if (!this.canContinueToBuild()) {
            this.stopBuildProcedure();
            return;
        }
        if (this.currentPlannedBlockQueueIndex < this.plannedBlockQueue.size()) {
            PlannedBlock currentPlannedBlock = this.plannedBlockQueue.get(this.currentPlannedBlockQueueIndex);
            if (currentPlannedBlock.canBePlaced()) {
                currentPlannedBlock.build();
            }
            ++this.currentPlannedBlockQueueIndex;
        }
    }

    public class ConnectionPoint {
        private BlockPos position;
        private Direction direction;

        public ConnectionPoint(BlockPos positionIn, Direction directionIn) {
            this.position = positionIn;
            this.direction = directionIn;
        }

        public BlockPos getPosition() {
            return this.position;
        }

        public Direction getDirection() {
            return this.direction;
        }
    }
}

