/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.procedural.structures;

import com.github.sculkhorde.common.procedural.structures.Line3D;
import com.github.sculkhorde.common.procedural.structures.PlannedBlock;
import com.github.sculkhorde.common.procedural.structures.ProceduralStructure;
import com.github.sculkhorde.core.BlockRegistry;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class SculkNodeCaveHallwayProceduralStructure
extends ProceduralStructure {
    private int radius = -1;
    private int length = -1;
    private Direction direction;

    public SculkNodeCaveHallwayProceduralStructure(ServerLevel worldIn, BlockPos originIn, int radiusIn, int length, Direction direction) {
        super(worldIn, originIn);
        this.radius = radiusIn;
        this.length = length;
        this.direction = direction;
        this.generatePlan();
    }

    @Override
    public void buildTick() {
        if (this.currentPlannedBlockQueueIndex < this.plannedBlockQueue.size()) {
            PlannedBlock currentPlannedBlock = (PlannedBlock)this.plannedBlockQueue.get(this.currentPlannedBlockQueueIndex);
            while (currentPlannedBlock.canBePlaced() && currentPlannedBlock.isPlaced() && this.currentPlannedBlockQueueIndex < this.plannedBlockQueue.size()) {
                currentPlannedBlock = (PlannedBlock)this.plannedBlockQueue.get(this.currentPlannedBlockQueueIndex);
                ++this.currentPlannedBlockQueueIndex;
            }
            if (currentPlannedBlock.canBePlaced()) {
                currentPlannedBlock.build();
            }
            ++this.currentPlannedBlockQueueIndex;
        }
    }

    @Override
    public void generatePlan() {
        this.plannedBlockQueue.clear();
        ArrayList<BlockPos> plannedBlockPositions = this.createCaveBlockPositions();
        for (BlockPos position : plannedBlockPositions) {
            this.plannedBlockQueue.add(new CaveAirPlannedBlock(this.world, position));
        }
    }

    public ArrayList<BlockPos> createCaveBlockPositions() {
        return (switch (this.direction) {
            case Direction.NORTH -> new Line3D(this.origin, this.origin.m_122013_(this.length));
            case Direction.SOUTH -> new Line3D(this.origin, this.origin.m_122020_(this.length));
            case Direction.EAST -> new Line3D(this.origin, this.origin.m_122030_(this.length));
            case Direction.WEST -> new Line3D(this.origin, this.origin.m_122025_(this.length));
            default -> throw new IllegalArgumentException("Invalid direction: " + this.direction);
        }).getBlockPositionsOnLineWithSphere(this.radius);
    }

    public class CaveAirPlannedBlock
    extends PlannedBlock {
        protected final Predicate<BlockState> CAN_BLOCK_BE_REPLACED;

        public CaveAirPlannedBlock(ServerLevel worldIn, BlockPos targetPosIn) {
            super(worldIn, Blocks.f_50627_.m_49966_(), targetPosIn);
            this.CAN_BLOCK_BE_REPLACED = validBlocksPredicate -> {
                if (validBlocksPredicate.m_60734_().equals(BlockRegistry.SCULK_NODE_BLOCK.get()) || validBlocksPredicate.m_60734_().equals(BlockRegistry.SCULK_DURA_MATTER.get()) || validBlocksPredicate.m_60734_().equals(BlockRegistry.SCULK_ARACHNOID.get()) || validBlocksPredicate.m_60734_().equals(BlockRegistry.SCULK_LIVING_ROCK_BLOCK.get()) || validBlocksPredicate.m_60734_().equals(BlockRegistry.SCULK_LIVING_ROCK_ROOT_BLOCK.get()) || validBlocksPredicate.m_60734_().equals(BlockRegistry.SCULK_BEE_NEST_CELL_BLOCK.get()) || validBlocksPredicate.m_60734_().equals(BlockRegistry.SCULK_SUMMONER_BLOCK.get()) || validBlocksPredicate.m_60734_().equals(BlockRegistry.GRASS.get()) || validBlocksPredicate.m_60734_().equals(BlockRegistry.GRASS_SHORT.get()) || validBlocksPredicate.m_60734_().equals(BlockRegistry.SCULK_BEE_NEST_CELL_BLOCK.get()) || validBlocksPredicate.m_60734_().equals(BlockRegistry.CALCITE_ORE.get()) || validBlocksPredicate.m_60734_().equals(BlockRegistry.SMALL_SHROOM.get()) || validBlocksPredicate.m_60734_().equals(BlockRegistry.TENDRILS.get()) || validBlocksPredicate.m_60734_().equals(BlockRegistry.SCULK_SHROOM_CULTURE.get())) {
                    return false;
                }
                if (this.world.m_45527_(this.targetPos.m_7494_())) {
                    return false;
                }
                return !(validBlocksPredicate.m_60800_((BlockGetter)this.world, this.targetPos) > 3.0f);
            };
        }

        @Override
        public boolean canBePlaced() {
            return this.CAN_BLOCK_BE_REPLACED.test(this.world.m_8055_(this.targetPos));
        }

        @Override
        public void build() {
            if (this.canBePlaced()) {
                this.world.m_46597_(this.targetPos, this.plannedBlock);
            }
        }
    }

    private class CaveWallPlannedBlock
    extends PlannedBlock {
        protected final Predicate<BlockState> CAN_BLOCK_BE_REPLACED;

        public CaveWallPlannedBlock(ServerLevel worldIn, BlockPos targetPosIn) {
            super(worldIn, Blocks.f_50627_.m_49966_(), targetPosIn);
            this.CAN_BLOCK_BE_REPLACED = validBlocksPredicate -> validBlocksPredicate.m_60795_();
        }

        @Override
        public boolean canBePlaced() {
            return this.CAN_BLOCK_BE_REPLACED.test(this.world.m_8055_(this.targetPos));
        }

        @Override
        public void build() {
            if (this.canBePlaced()) {
                this.world.m_46597_(this.targetPos, this.plannedBlock);
            }
        }
    }
}

