/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.procedural.structures;

import com.github.sculkhorde.common.block.SculkLivingRockRootBlock;
import com.github.sculkhorde.common.procedural.structures.PlannedBlock;
import com.github.sculkhorde.common.procedural.structures.ProceduralStructure;
import com.github.sculkhorde.common.procedural.structures.SculkNodeCaveProceduralStructure;
import com.github.sculkhorde.core.BlockRegistry;
import com.github.sculkhorde.util.BlockAlgorithms;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class SculkNodeProceduralStructure
extends ProceduralStructure {
    private final int SHELL_RADIUS = 5;
    private final int CAVE_RADIUS = 10;
    private final int HALLWAY_RADIUS = 5;

    public SculkNodeProceduralStructure(ServerLevel worldIn, BlockPos originIn) {
        super(worldIn, originIn);
    }

    @Override
    public void buildTick() {
        super.buildTick();
        for (ProceduralStructure childStructure : this.childStructuresQueue) {
            childStructure.buildTick();
        }
    }

    public Optional<BlockPos> findLivingRockStructureIfExists(ServerLevel world, BlockPos placementPos) {
        if (world.m_8055_(placementPos).m_60734_().equals(BlockRegistry.SCULK_LIVING_ROCK_ROOT_BLOCK.get())) {
            return Optional.of(placementPos);
        }
        int offsetBelow = 0;
        int offsetAbove = 0;
        while (placementPos.m_7918_(0, offsetBelow, 0).m_123342_() > 0) {
            if (world.m_8055_(placementPos.m_7918_(0, offsetBelow, 0)).m_60734_().equals(BlockRegistry.SCULK_LIVING_ROCK_ROOT_BLOCK.get())) {
                return Optional.of(placementPos.m_7918_(0, offsetBelow, 0));
            }
            --offsetBelow;
        }
        while (placementPos.m_7918_(0, offsetAbove, 0).m_123342_() > world.m_141928_()) {
            if (world.m_8055_(placementPos.m_7918_(0, offsetAbove, 0)).m_60734_().equals(BlockRegistry.SCULK_LIVING_ROCK_ROOT_BLOCK.get())) {
                return Optional.of(placementPos.m_7918_(0, offsetAbove, 0));
            }
            ++offsetAbove;
        }
        return Optional.empty();
    }

    public BlockPos findLivingRockPlacementPosition(ServerLevel world, BlockPos placementPos) {
        int attempts;
        if (this.findLivingRockStructureIfExists(world, placementPos).isPresent()) {
            return this.findLivingRockStructureIfExists(world, placementPos).get();
        }
        int MAX_ATTEMPTS = 100;
        int offsetBelow = 0;
        int offsetAbove = 0;
        for (attempts = 0; world.m_8055_(placementPos.m_7918_(0, offsetBelow, 0)).m_60722_((Fluid)Fluids.f_76193_) && attempts <= MAX_ATTEMPTS; ++attempts) {
            --offsetBelow;
        }
        for (attempts = 0; world.m_8055_(placementPos.m_7918_(0, offsetAbove, 0)).m_60722_((Fluid)Fluids.f_76193_) && attempts <= MAX_ATTEMPTS; ++attempts) {
            ++offsetAbove;
        }
        if (Math.abs(offsetBelow) < offsetAbove) {
            return placementPos.m_7918_(0, offsetBelow, 0);
        }
        return placementPos.m_7918_(0, offsetAbove, 0);
    }

    @Override
    public void generatePlan() {
        this.plannedBlockQueue.clear();
        this.childStructuresQueue.add(new SculkNodeCaveProceduralStructure(this.world, this.origin, 10));
        for (Object entry : this.childStructuresQueue) {
            ((ProceduralStructure)entry).generatePlan();
        }
        ArrayList<BlockPos> blockPositionsInCircle = BlockAlgorithms.getBlockPosInCircle(this.origin, 5, false);
        for (BlockPos position : blockPositionsInCircle) {
            if (BlockAlgorithms.getBlockDistance(this.origin, position) < 4.0f) {
                this.plannedBlockQueue.add(new PlannedBlock(this.world, ((Block)BlockRegistry.SCULK_ARACHNOID.get()).m_49966_(), position));
                continue;
            }
            this.plannedBlockQueue.add(new PlannedBlock(this.world, ((Block)BlockRegistry.SCULK_DURA_MATTER.get()).m_49966_(), position));
        }
        ArrayList<BlockPos> surroundingLivingRock = BlockAlgorithms.getPointsOnCircumference(this.origin, 5, 15);
        surroundingLivingRock.addAll(BlockAlgorithms.getPointsOnCircumference(this.origin, 10, 30));
        surroundingLivingRock.addAll(BlockAlgorithms.getPointsOnCircumference(this.origin, 20, 45));
        for (BlockPos position : surroundingLivingRock) {
            this.plannedBlockQueue.add(new PlannedBlock(this.world, ((SculkLivingRockRootBlock)((Object)BlockRegistry.SCULK_LIVING_ROCK_ROOT_BLOCK.get())).m_49966_(), this.findLivingRockPlacementPosition(this.world, position)));
        }
    }
}

