/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.core;

import com.github.sculkhorde.common.block.DevStructureTesterBlock;
import com.github.sculkhorde.common.block.InfestedLogBlock;
import com.github.sculkhorde.common.block.SculkBeeNestBlock;
import com.github.sculkhorde.common.block.SculkBeeNestCellBlock;
import com.github.sculkhorde.common.block.SculkFloraBlock;
import com.github.sculkhorde.common.block.SculkLivingRockBlock;
import com.github.sculkhorde.common.block.SculkLivingRockRootBlock;
import com.github.sculkhorde.common.block.SculkMassBlock;
import com.github.sculkhorde.common.block.SculkNodeBlock;
import com.github.sculkhorde.common.block.SculkShroomCultureBlock;
import com.github.sculkhorde.common.block.SculkSummonerBlock;
import com.github.sculkhorde.common.block.SmallShroomBlock;
import com.github.sculkhorde.common.block.SpikeBlock;
import com.github.sculkhorde.common.block.TendrilsBlock;
import com.github.sculkhorde.core.ItemRegistry;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class BlockRegistry {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"sculkhorde");
    public static final RegistryObject<Block> ANCIENT_LARGE_BRICKS = BlockRegistry.registerBlock("ancient_large_bricks", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76383_).m_60913_(15.0f, 30.0f).m_60999_().m_60918_(SoundType.f_56726_)));
    public static final RegistryObject<Block> ANCIENT_LARGE_TILE = BlockRegistry.registerBlock("ancient_large_tile", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76383_).m_60913_(15.0f, 30.0f).m_60999_().m_60918_(SoundType.f_56726_)));
    public static final RegistryObject<Block> SCULK_ARACHNOID = BlockRegistry.registerBlock("sculk_arachnoid", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76415_).m_60913_(10.0f, 6.0f).m_60999_().m_60918_(SoundType.f_56751_)));
    public static final RegistryObject<Block> SCULK_DURA_MATTER = BlockRegistry.registerBlock("sculk_dura_matter", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76412_).m_60913_(15.0f, 30.0f).m_60999_().m_60918_(SoundType.f_56726_)));
    public static final RegistryObject<Block> CALCITE_ORE = BlockRegistry.registerBlock("calcite_ore", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76412_).m_60913_(15.0f, 30.0f).m_60999_().m_60918_(SoundType.f_56726_)));
    public static final RegistryObject<Block> INFESTED_STONE = BlockRegistry.registerBlock("infested_stone", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76388_).m_60913_(15.0f, 30.0f).m_60999_().m_60918_(SoundType.f_56726_)));
    public static final RegistryObject<InfestedLogBlock> INFESTED_LOG = BlockRegistry.registerBlock("infested_log", () -> new InfestedLogBlock());
    public static final RegistryObject<Block> INFESTED_SAND = BlockRegistry.registerBlock("infested_sand", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76317_, (MaterialColor)MaterialColor.f_76412_).m_60913_(15.0f, 30.0f).m_60999_().m_60918_(SoundType.f_56746_)));
    public static final RegistryObject<Block> INFESTED_DEEPSLATE = BlockRegistry.registerBlock("infested_deepslate", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76383_).m_60913_(15.0f, 30.0f).m_60999_().m_60918_(SoundType.f_154677_)));
    public static final RegistryObject<Block> INFESTED_SANDSTONE = BlockRegistry.registerBlock("infested_sandstone", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76383_).m_60913_(15.0f, 30.0f).m_60999_().m_60918_(SoundType.f_56742_)));
    public static final RegistryObject<Block> INFESTED_DIORITE = BlockRegistry.registerBlock("infested_diorite", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76383_).m_60913_(15.0f, 30.0f).m_60999_().m_60918_(SoundType.f_56742_)));
    public static final RegistryObject<Block> INFESTED_GRANITE = BlockRegistry.registerBlock("infested_granite", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76383_).m_60913_(15.0f, 30.0f).m_60999_().m_60918_(SoundType.f_56742_)));
    public static final RegistryObject<Block> INFESTED_ANDESITE = BlockRegistry.registerBlock("infested_andesite", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76383_).m_60913_(15.0f, 30.0f).m_60999_().m_60918_(SoundType.f_56742_)));
    public static final RegistryObject<Block> INFESTED_TUFF = BlockRegistry.registerBlock("infested_tuff", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76383_).m_60913_(15.0f, 30.0f).m_60999_().m_60918_(SoundType.f_56742_)));
    public static final RegistryObject<SpikeBlock> SPIKE = BlockRegistry.registerBlock("spike", () -> new SpikeBlock());
    public static final RegistryObject<SmallShroomBlock> SMALL_SHROOM = BlockRegistry.registerBlock("small_shroom", () -> new SmallShroomBlock());
    public static final RegistryObject<SculkFloraBlock> GRASS = BlockRegistry.registerBlock("grass", () -> new SculkFloraBlock());
    public static final RegistryObject<SculkFloraBlock> GRASS_SHORT = BlockRegistry.registerBlock("grass_short", () -> new SculkFloraBlock());
    public static final RegistryObject<SculkShroomCultureBlock> SCULK_SHROOM_CULTURE = BlockRegistry.registerBlock("sculk_shroom_culture", () -> new SculkShroomCultureBlock());
    public static final RegistryObject<SculkMassBlock> SCULK_MASS = BlockRegistry.registerBlock("sculk_mass", () -> new SculkMassBlock());
    public static final RegistryObject<TendrilsBlock> TENDRILS = BlockRegistry.registerBlock("tendrils", () -> new TendrilsBlock());
    public static final RegistryObject<SculkNodeBlock> SCULK_NODE_BLOCK = BlockRegistry.registerBlock("sculk_node", () -> new SculkNodeBlock());
    public static final RegistryObject<SculkBeeNestBlock> SCULK_BEE_NEST_BLOCK = BlockRegistry.registerBlock("sculk_bee_nest", () -> new SculkBeeNestBlock());
    public static final RegistryObject<SculkBeeNestCellBlock> SCULK_BEE_NEST_CELL_BLOCK = BlockRegistry.registerBlock("sculk_bee_nest_cell", () -> new SculkBeeNestCellBlock());
    public static final RegistryObject<SculkSummonerBlock> SCULK_SUMMONER_BLOCK = BlockRegistry.registerBlock("sculk_summoner", () -> new SculkSummonerBlock());
    public static final RegistryObject<SculkLivingRockBlock> SCULK_LIVING_ROCK_BLOCK = BlockRegistry.registerBlock("sculk_living_rock", () -> new SculkLivingRockBlock());
    public static final RegistryObject<SculkLivingRockRootBlock> SCULK_LIVING_ROCK_ROOT_BLOCK = BlockRegistry.registerBlock("sculk_living_rock_root", () -> new SculkLivingRockRootBlock());
    public static final RegistryObject<DevStructureTesterBlock> DEV_STRUCTURE_TESTER_BLOCK = BlockRegistry.registerBlock("dev_structure_tester", () -> new DevStructureTesterBlock());

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        BlockRegistry.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, RegistryObject<T> block) {
        ItemRegistry.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static class Tags {
        public static final TagKey<Block> SCULK_RAID_TARGET_HIGH_PRIORITY = Tags.create("sculk_raid_target/high_priority");
        public static final TagKey<Block> SCULK_RAID_TARGET_MEDIUM_PRIORITY = Tags.create("sculk_raid_target/medium_priority");
        public static final TagKey<Block> SCULK_RAID_TARGET_LOW_PRIORITY = Tags.create("sculk_raid_target/low_priority");

        private static TagKey<Block> create(String location) {
            return BlockTags.create((ResourceLocation)new ResourceLocation("sculkhorde", location));
        }

        private static TagKey<Block> createForge(String location) {
            return BlockTags.create((ResourceLocation)new ResourceLocation("forge", location));
        }

        private static TagKey<Block> createMinecraft(String location) {
            return BlockTags.create((ResourceLocation)new ResourceLocation(location));
        }
    }
}

