/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.core;

import com.github.sculkhorde.common.block.SculkBeeNestBlock;
import com.github.sculkhorde.core.BlockRegistry;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.core.gravemind.Gravemind;
import com.github.sculkhorde.core.gravemind.RaidHandler;
import com.github.sculkhorde.util.BlockAlgorithms;
import com.github.sculkhorde.util.EntityAlgorithms;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class ModSavedData
extends SavedData {
    private final ServerLevel level;
    private final ArrayList<NodeEntry> nodeEntries = new ArrayList();
    private final ArrayList<BeeNestEntry> beeNestEntries = new ArrayList();
    private final Map<String, HostileEntry> hostileEntries = new HashMap<String, HostileEntry>();
    private final ArrayList<PriorityBlockEntry> priorityBlockEntries = new ArrayList();
    private final ArrayList<DeathAreaEntry> deathAreaEntries = new ArrayList();
    private final ArrayList<AreaofInterestEntry> areasOfInterestEntries = new ArrayList();
    private int sculkAccumulatedMass = 0;
    private static final String sculkAccumulatedMassIdentifier = "sculkAccumulatedMass";
    private int ticksSinceSculkNodeDestruction = Gravemind.TICKS_BETWEEN_NODE_SPAWNS;
    private static final String ticksSinceSculkNodeDestructionIdentifier = "ticksSinceSculkNodeDestruction";
    private int ticksSinceLastRaid = RaidHandler.COOLDOWN_BETWEEN_RAIDS;
    private static final String ticksSinceLastRaidIdentifier = "ticksSinceLastRaid";

    public ModSavedData() {
        this.level = ServerLifecycleHooks.getCurrentServer().m_129783_();
    }

    @NotNull
    private static ModSavedData getGravemindMemory() {
        return SculkHorde.savedData;
    }

    public static ModSavedData load(CompoundTag nbt) {
        CompoundTag gravemindData = nbt.m_128469_("gravemindData");
        SculkHorde.savedData = new ModSavedData();
        SculkHorde.savedData.getNodeEntries().clear();
        SculkHorde.savedData.getBeeNestEntries().clear();
        SculkHorde.savedData.getHostileEntries().clear();
        SculkHorde.savedData.getPriorityBlockEntries().clear();
        SculkHorde.savedData.getDeathAreaEntries().clear();
        SculkHorde.savedData.getAreasOfInterestEntries().clear();
        SculkHorde.savedData.setSculkAccumulatedMass(nbt.m_128451_(sculkAccumulatedMassIdentifier));
        SculkHorde.savedData.setTicksSinceSculkNodeDestruction(nbt.m_128451_(ticksSinceSculkNodeDestructionIdentifier));
        SculkHorde.savedData.setTicksSinceLastRaid(nbt.m_128451_(ticksSinceLastRaidIdentifier));
        int i = 0;
        while (gravemindData.m_128441_("node_entry" + i)) {
            SculkHorde.savedData.getNodeEntries().add(NodeEntry.serialize(gravemindData.m_128469_("node_entry" + i)));
            ++i;
        }
        i = 0;
        while (gravemindData.m_128441_("bee_nest_entry" + i)) {
            SculkHorde.savedData.getBeeNestEntries().add(BeeNestEntry.serialize(gravemindData.m_128469_("bee_nest_entry" + i)));
            ++i;
        }
        i = 0;
        while (gravemindData.m_128441_("hostile_entry" + i)) {
            HostileEntry hostileEntry = HostileEntry.serialize(gravemindData.m_128469_("hostile_entry" + i));
            SculkHorde.savedData.getHostileEntries().putIfAbsent(hostileEntry.identifier, hostileEntry);
            ++i;
        }
        i = 0;
        while (gravemindData.m_128441_("priority_block_entry" + i)) {
            SculkHorde.savedData.getPriorityBlockEntries().add(PriorityBlockEntry.serialize(gravemindData.m_128469_("priority_block_entry" + i)));
            ++i;
        }
        i = 0;
        while (gravemindData.m_128441_("death_area_entry" + i)) {
            SculkHorde.savedData.getDeathAreaEntries().add(DeathAreaEntry.serialize(gravemindData.m_128469_("death_area_entry" + i)));
            ++i;
        }
        i = 0;
        while (gravemindData.m_128441_("area_of_interest_entry" + i)) {
            SculkHorde.savedData.getAreasOfInterestEntries().add(AreaofInterestEntry.serialize(gravemindData.m_128469_("area_of_interest_entry" + i)));
            ++i;
        }
        return ModSavedData.getGravemindMemory();
    }

    @NotNull
    public CompoundTag m_7176_(CompoundTag nbt) {
        CompoundTag gravemindData = new CompoundTag();
        nbt.m_128405_(sculkAccumulatedMassIdentifier, this.sculkAccumulatedMass);
        nbt.m_128405_(ticksSinceSculkNodeDestructionIdentifier, this.ticksSinceSculkNodeDestruction);
        nbt.m_128405_(ticksSinceLastRaidIdentifier, this.ticksSinceLastRaid);
        ListIterator<Object> iterator = this.getNodeEntries().listIterator();
        while (iterator.hasNext()) {
            gravemindData.m_128365_("node_entry" + iterator.nextIndex(), (Tag)((NodeEntry)iterator.next()).deserialize());
        }
        iterator = this.getBeeNestEntries().listIterator();
        while (iterator.hasNext()) {
            gravemindData.m_128365_("bee_nest_entry" + iterator.nextIndex(), (Tag)((BeeNestEntry)iterator.next()).deserialize());
        }
        int hostileIndex = 0;
        for (Map.Entry<String, HostileEntry> entry : this.getHostileEntries().entrySet()) {
            gravemindData.m_128365_("hostile_entry" + hostileIndex, (Tag)entry.getValue().deserialize());
            ++hostileIndex;
        }
        ListIterator<Object> iterator2 = this.getPriorityBlockEntries().listIterator();
        while (iterator2.hasNext()) {
            gravemindData.m_128365_("priority_block_entry" + iterator2.nextIndex(), (Tag)((PriorityBlockEntry)iterator2.next()).deserialize());
        }
        iterator2 = this.getDeathAreaEntries().listIterator();
        while (iterator2.hasNext()) {
            gravemindData.m_128365_("death_area_entry" + iterator2.nextIndex(), (Tag)((DeathAreaEntry)iterator2.next()).deserialize());
        }
        iterator2 = this.getAreasOfInterestEntries().listIterator();
        while (iterator2.hasNext()) {
            gravemindData.m_128365_("area_of_interest_entry" + iterator2.nextIndex(), (Tag)((AreaofInterestEntry)iterator2.next()).deserialize());
        }
        nbt.m_128365_("gravemindData", (Tag)gravemindData);
        return nbt;
    }

    public boolean isRaidCooldownOver() {
        return this.getTicksSinceLastRaid() >= RaidHandler.COOLDOWN_BETWEEN_RAIDS;
    }

    public int getTicksSinceLastRaid() {
        this.m_77762_();
        return this.ticksSinceLastRaid;
    }

    public void setTicksSinceLastRaid(int ticksSinceLastRaid) {
        this.ticksSinceLastRaid = ticksSinceLastRaid;
        this.m_77762_();
    }

    public void incrementTicksSinceLastRaid() {
        ++this.ticksSinceLastRaid;
        this.m_77762_();
    }

    public boolean isSculkNodeCooldownOver() {
        return this.ticksSinceSculkNodeDestruction >= Gravemind.TICKS_BETWEEN_NODE_SPAWNS;
    }

    public int getTicksSinceSculkNodeDestruction() {
        this.m_77762_();
        return this.ticksSinceSculkNodeDestruction;
    }

    public void setTicksSinceSculkNodeDestruction(int ticksSinceSculkNodeDestruction) {
        this.ticksSinceSculkNodeDestruction = ticksSinceSculkNodeDestruction;
        this.m_77762_();
    }

    public void incrementTicksSinceSculkNodeDestruction() {
        ++this.ticksSinceSculkNodeDestruction;
        this.m_77762_();
    }

    public void resetTicksSinceSculkNodeDestruction() {
        this.level.m_6907_().forEach(player -> player.m_5661_((Component)Component.m_237113_((String)"A Sculk Node has been Destroyed!"), true));
        this.level.m_6907_().forEach(player -> this.level.m_5594_(null, player.m_20183_(), SoundEvents.f_11891_, SoundSource.HOSTILE, 1.0f, 1.0f));
        this.ticksSinceSculkNodeDestruction = 0;
        this.m_77762_();
    }

    public int getSculkAccumulatedMass() {
        this.m_77762_();
        return this.sculkAccumulatedMass;
    }

    public void addSculkAccumulatedMass(int amount) {
        this.m_77762_();
        this.sculkAccumulatedMass += amount;
    }

    public void subtractSculkAccumulatedMass(int amount) {
        this.m_77762_();
        this.sculkAccumulatedMass -= amount;
    }

    public void setSculkAccumulatedMass(int amount) {
        this.m_77762_();
        this.sculkAccumulatedMass = amount;
    }

    public ArrayList<NodeEntry> getNodeEntries() {
        return this.nodeEntries;
    }

    public ArrayList<BeeNestEntry> getBeeNestEntries() {
        return this.beeNestEntries;
    }

    public Map<String, HostileEntry> getHostileEntries() {
        return this.hostileEntries;
    }

    public ArrayList<PriorityBlockEntry> getPriorityBlockEntries() {
        return this.priorityBlockEntries;
    }

    public ArrayList<DeathAreaEntry> getDeathAreaEntries() {
        return this.deathAreaEntries;
    }

    public ArrayList<AreaofInterestEntry> getAreasOfInterestEntries() {
        return this.areasOfInterestEntries;
    }

    public void addNodeToMemory(BlockPos positionIn) {
        if (!this.isNodePositionInMemory(positionIn) && this.getNodeEntries() != null) {
            this.getNodeEntries().add(new NodeEntry(positionIn));
            this.m_77762_();
        }
    }

    public void addBeeNestToMemory(BlockPos positionIn) {
        if (!this.isBeeNestPositionInMemory(positionIn) && this.getBeeNestEntries() != null) {
            this.getBeeNestEntries().add(new BeeNestEntry(positionIn));
            this.m_77762_();
        }
    }

    public void addHostileToMemory(LivingEntity entityIn) {
        if (entityIn == null || EntityAlgorithms.isSculkLivingEntity.test(entityIn) || entityIn instanceof Creeper) {
            return;
        }
        String identifier = entityIn.m_6095_().toString();
        if (!identifier.isEmpty()) {
            this.getHostileEntries().putIfAbsent(identifier, new HostileEntry(identifier));
            this.m_77762_();
        }
    }

    public void addPriorityBlockToMemory(BlockPos positionIn) {
        int priority;
        if (this.getPriorityBlockEntries() == null) {
            return;
        }
        for (PriorityBlockEntry entry : this.getPriorityBlockEntries()) {
            if (entry.position != positionIn) continue;
            return;
        }
        if (this.level.m_8055_(positionIn).m_204336_(BlockRegistry.Tags.SCULK_RAID_TARGET_HIGH_PRIORITY)) {
            priority = 2;
        } else if (this.level.m_8055_(positionIn).m_204336_(BlockRegistry.Tags.SCULK_RAID_TARGET_MEDIUM_PRIORITY)) {
            priority = 1;
        } else if (this.level.m_8055_(positionIn).m_204336_(BlockRegistry.Tags.SCULK_RAID_TARGET_LOW_PRIORITY)) {
            priority = 0;
        } else {
            SculkHorde.LOGGER.warn("Attempted to add a block to the priority list that was not a priority block");
            return;
        }
        this.getPriorityBlockEntries().add(new PriorityBlockEntry(positionIn, priority));
        this.m_77762_();
    }

    public void addDeathAreaToMemory(BlockPos positionIn) {
        if (this.getDeathAreaEntries() == null) {
            SculkHorde.LOGGER.warn("Attempted to add a death area to memory but the list was null");
            return;
        }
        for (int i = 0; i < this.getDeathAreaEntries().size(); ++i) {
            if (this.getDeathAreaEntries().get((int)i).position != positionIn) continue;
            return;
        }
        SculkHorde.LOGGER.info("Adding Death Area at " + positionIn + " to memory");
        this.getDeathAreaEntries().add(new DeathAreaEntry(positionIn));
        this.m_77762_();
    }

    public void addAreaOfInterestToMemory(BlockPos positionIn) {
        if (this.getAreasOfInterestEntries() == null) {
            SculkHorde.LOGGER.warn("Attempted to add an area of interest to memory but the list was null");
            return;
        }
        for (int i = 0; i < this.getAreasOfInterestEntries().size(); ++i) {
            if (this.getAreasOfInterestEntries().get((int)i).position != positionIn && !this.getAreasOfInterestEntries().get((int)i).position.m_123314_((Vec3i)positionIn, 100.0)) continue;
            return;
        }
        SculkHorde.LOGGER.info("Adding Area of Interest at " + positionIn + " to memory");
        this.getAreasOfInterestEntries().add(new AreaofInterestEntry(positionIn));
        this.m_77762_();
    }

    private Optional<DeathAreaEntry> getDeathAreaWithinRange(BlockPos positionIn, int range) {
        if (this.getDeathAreaEntries() == null) {
            SculkHorde.LOGGER.warn("Attempted to get a death area from memory but the list was null");
            return Optional.empty();
        }
        for (int i = 0; i < this.getDeathAreaEntries().size(); ++i) {
            if (!this.getDeathAreaEntries().get((int)i).position.m_123314_((Vec3i)positionIn, (double)range)) continue;
            return Optional.of(this.getDeathAreaEntries().get(i));
        }
        return Optional.empty();
    }

    public Optional<DeathAreaEntry> getDeathAreaWithHighestDeaths() {
        if (this.getDeathAreaEntries() == null) {
            SculkHorde.LOGGER.warn("Attempted to get a death area from memory but the list was null");
            return Optional.empty();
        }
        int highestDeathCount = 0;
        DeathAreaEntry highestDeathArea = null;
        for (int i = 0; i < this.getDeathAreaEntries().size(); ++i) {
            if (this.getDeathAreaEntries().get((int)i).deathCount <= highestDeathCount) continue;
            highestDeathCount = this.getDeathAreaEntries().get((int)i).deathCount;
            highestDeathArea = this.getDeathAreaEntries().get(i);
        }
        if (highestDeathArea == null) {
            return Optional.empty();
        }
        return Optional.of(highestDeathArea);
    }

    public void validateNodeEntries() {
        long startTime = System.nanoTime();
        for (int index = 0; index < this.nodeEntries.size(); ++index) {
            if (this.getNodeEntries().get(index).isEntryValid(this.level)) continue;
            this.resetTicksSinceSculkNodeDestruction();
            this.getNodeEntries().remove(index);
            --index;
            this.m_77762_();
        }
        long endTime = System.nanoTime();
        if (SculkHorde.DEBUG_MODE) {
            System.out.println("Node Validation Took " + TimeUnit.MILLISECONDS.convert(endTime - startTime, TimeUnit.NANOSECONDS) + " milliseconds");
        }
    }

    public void validateBeeNestEntries() {
        long startTime = System.nanoTime();
        for (int index = 0; index < this.getBeeNestEntries().size(); ++index) {
            this.getBeeNestEntries().get(index).setParentNodeToClosest();
            if (this.getBeeNestEntries().get(index).isEntryValid(this.level)) continue;
            this.getBeeNestEntries().remove(index);
            --index;
            this.m_77762_();
        }
        long endTime = System.nanoTime();
        if (SculkHorde.DEBUG_MODE) {
            System.out.println("Bee Nest Validation Took " + TimeUnit.MILLISECONDS.convert(endTime - startTime, TimeUnit.NANOSECONDS) + " milliseconds");
        }
    }

    public void validatePriorityBlockEntries() {
        long startTime = System.currentTimeMillis();
        for (int index = 0; index < this.getPriorityBlockEntries().size(); ++index) {
            if (this.getPriorityBlockEntries().get(index).isEntryValid(this.level)) continue;
            this.getPriorityBlockEntries().remove(index);
            this.m_77762_();
            SculkHorde.LOGGER.info("Priority Block Entry at " + this.getPriorityBlockEntries().get((int)(--index)).position + " is invalid. Removing from memory.");
        }
        long endTime = System.currentTimeMillis();
        SculkHorde.LOGGER.info("Priority Block Validation Took " + (endTime - startTime) + " milliseconds");
    }

    public boolean isBeeNestPositionInMemory(BlockPos position) {
        for (BeeNestEntry entry : this.getBeeNestEntries()) {
            if (entry.position != position) continue;
            return true;
        }
        return false;
    }

    public boolean isNodePositionInMemory(BlockPos position) {
        for (NodeEntry entry : this.getNodeEntries()) {
            if (!entry.position.equals((Object)position)) continue;
            return true;
        }
        return false;
    }

    public NodeEntry getClosestNodeEntry(BlockPos pos) {
        NodeEntry closestNode = null;
        double closestDistance = Double.MAX_VALUE;
        for (NodeEntry node : this.getNodeEntries()) {
            if (!(pos.m_123331_((Vec3i)node.position) < closestDistance)) continue;
            closestNode = node;
            closestDistance = pos.m_123331_((Vec3i)node.position);
        }
        return closestNode;
    }

    public boolean isInRangeOfNode(BlockPos pos, int distance) {
        if (this.getNodeEntries().isEmpty()) {
            return false;
        }
        return BlockAlgorithms.getBlockDistance(this.getClosestNodeEntry((BlockPos)pos).position, pos) <= (float)distance;
    }

    public void removeDeathAreaFromMemory(BlockPos positionIn) {
        if (this.getDeathAreaEntries() == null) {
            SculkHorde.LOGGER.warn("Attempted to remove a death area from memory but the list was null");
            return;
        }
        for (int i = 0; i < this.getDeathAreaEntries().size(); ++i) {
            if (this.getDeathAreaEntries().get((int)i).position != positionIn) continue;
            this.getDeathAreaEntries().remove(i);
            this.m_77762_();
            return;
        }
        this.m_77762_();
    }

    public void removeAreaOfInterestFromMemory(BlockPos positionIn) {
        if (this.getAreasOfInterestEntries() == null) {
            SculkHorde.LOGGER.warn("Attempted to remove an area of interest from memory but the list was null");
            return;
        }
        for (int i = 0; i < this.getAreasOfInterestEntries().size(); ++i) {
            if (this.getAreasOfInterestEntries().get((int)i).position != positionIn) continue;
            this.getAreasOfInterestEntries().remove(i);
            this.m_77762_();
            return;
        }
        this.m_77762_();
    }

    public void reportDeath(BlockPos deathPosition) {
        Optional<DeathAreaEntry> deathArea = this.getDeathAreaWithinRange(deathPosition, 100);
        if (deathArea.isPresent()) {
            deathArea.get().iterateDeathCount();
            this.m_77762_();
            return;
        }
        this.addDeathAreaToMemory(deathPosition);
    }

    public static class NodeEntry {
        private final BlockPos position;
        private long lastTimeWasActive;

        public NodeEntry(BlockPos positionIn) {
            this.position = positionIn;
            this.lastTimeWasActive = System.nanoTime();
        }

        public BlockPos getPosition() {
            return this.position;
        }

        public long getLastTimeWasActive() {
            return this.lastTimeWasActive;
        }

        public void setLastTimeWasActive(long lastTimeWasActiveIn) {
            this.lastTimeWasActive = lastTimeWasActiveIn;
        }

        public boolean isEntryValid(ServerLevel worldIn) {
            return worldIn.m_8055_(this.position).m_60734_().equals(BlockRegistry.SCULK_NODE_BLOCK.get());
        }

        public CompoundTag deserialize() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128356_("position", this.position.m_121878_());
            nbt.m_128356_("lastTimeWasActive", this.lastTimeWasActive);
            return nbt;
        }

        public static NodeEntry serialize(CompoundTag nbt) {
            return new NodeEntry(BlockPos.m_122022_((long)nbt.m_128454_("position")));
        }
    }

    public static class BeeNestEntry {
        private final BlockPos position;
        private BlockPos parentNodePosition;

        public BeeNestEntry(BlockPos positionIn) {
            this.position = positionIn;
        }

        public BeeNestEntry(BlockPos positionIn, BlockPos parentPositionIn) {
            this.position = positionIn;
            this.parentNodePosition = parentPositionIn;
        }

        public boolean isEntryValid(ServerLevel worldIn) {
            return worldIn.m_8055_(this.position).m_60734_().equals(BlockRegistry.SCULK_BEE_NEST_BLOCK.get());
        }

        public boolean isOccupantsExistingDisabled(ServerLevel worldIn) {
            return SculkBeeNestBlock.isNestClosed(worldIn.m_8055_(this.position));
        }

        public void disableOccupantsExiting(ServerLevel world) {
            SculkBeeNestBlock.setNestClosed(world, world.m_8055_(this.position), this.position);
        }

        public void enableOccupantsExiting(ServerLevel world) {
            SculkBeeNestBlock.setNestOpen(world, world.m_8055_(this.position), this.position);
        }

        public void setParentNodeToClosest() {
            if (ModSavedData.getGravemindMemory().getNodeEntries() != null && !ModSavedData.getGravemindMemory().getNodeEntries().isEmpty()) {
                NodeEntry closestEntry = ModSavedData.getGravemindMemory().getNodeEntries().get(0);
                for (NodeEntry entry : ModSavedData.getGravemindMemory().getNodeEntries()) {
                    if (!(BlockAlgorithms.getBlockDistance(this.position, entry.position) < BlockAlgorithms.getBlockDistance(this.position, closestEntry.position))) continue;
                    closestEntry = entry;
                }
                this.parentNodePosition = closestEntry.position;
            }
        }

        public CompoundTag deserialize() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128356_("position", this.position.m_121878_());
            if (this.parentNodePosition != null) {
                nbt.m_128356_("parentNodePosition", this.parentNodePosition.m_121878_());
            }
            return nbt;
        }

        public static BeeNestEntry serialize(CompoundTag nbt) {
            return new BeeNestEntry(BlockPos.m_122022_((long)nbt.m_128454_("position")), BlockPos.m_122022_((long)nbt.m_128454_("parentNodePosition")));
        }
    }

    private static class HostileEntry {
        private final String identifier;

        public HostileEntry(String identifierIn) {
            this.identifier = identifierIn;
        }

        public CompoundTag deserialize() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("identifier", this.identifier);
            return nbt;
        }

        public static HostileEntry serialize(CompoundTag nbt) {
            return new HostileEntry(nbt.m_128461_("identifier"));
        }
    }

    public static class PriorityBlockEntry {
        private final BlockPos position;
        private final int priority;

        public PriorityBlockEntry(BlockPos positionIn, int priorityIn) {
            this.position = positionIn;
            this.priority = priorityIn;
        }

        public BlockPos getPosition() {
            return this.position;
        }

        public int getPriority() {
            return this.priority;
        }

        public boolean isEntryValid(ServerLevel level) {
            BlockState blockState = level.m_8055_(this.position);
            if (blockState.m_204336_(BlockRegistry.Tags.SCULK_RAID_TARGET_HIGH_PRIORITY) && this.priority == 2) {
                return true;
            }
            if (blockState.m_204336_(BlockRegistry.Tags.SCULK_RAID_TARGET_MEDIUM_PRIORITY) && this.priority == 1) {
                return true;
            }
            return blockState.m_204336_(BlockRegistry.Tags.SCULK_RAID_TARGET_LOW_PRIORITY) && this.priority == 0;
        }

        public CompoundTag deserialize() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128356_("position", this.position.m_121878_());
            nbt.m_128356_("priority", (long)this.priority);
            return nbt;
        }

        public static PriorityBlockEntry serialize(CompoundTag nbt) {
            return new PriorityBlockEntry(BlockPos.m_122022_((long)nbt.m_128454_("position")), nbt.m_128451_("priority"));
        }
    }

    public static class DeathAreaEntry {
        private final BlockPos position;
        private int deathCount;

        public DeathAreaEntry(BlockPos positionIn) {
            this.position = positionIn;
            this.deathCount = 1;
        }

        public DeathAreaEntry(BlockPos positionIn, int deathCountIn) {
            this.position = positionIn;
            this.deathCount = deathCountIn;
        }

        public void setDeathCount(int deathCountIn) {
            this.deathCount = deathCountIn;
        }

        public int getDeathCount() {
            return this.deathCount;
        }

        public void iterateDeathCount() {
            ++this.deathCount;
        }

        public BlockPos getPosition() {
            return this.position;
        }

        public CompoundTag deserialize() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128356_("position", this.position.m_121878_());
            nbt.m_128405_("deathCount", this.deathCount);
            return nbt;
        }

        public static DeathAreaEntry serialize(CompoundTag nbt) {
            return new DeathAreaEntry(BlockPos.m_122022_((long)nbt.m_128454_("position")), nbt.m_128451_("deathCount"));
        }
    }

    public static class AreaofInterestEntry {
        private final BlockPos position;
        private long ticksSinceLastRaid;

        public AreaofInterestEntry(BlockPos positionIn) {
            this.position = positionIn;
        }

        public AreaofInterestEntry(BlockPos positionIn, long ticksSinceLastRaidIn) {
            this.position = positionIn;
            this.ticksSinceLastRaid = ticksSinceLastRaidIn;
        }

        public BlockPos getPosition() {
            return this.position;
        }

        public long getTicksSinceLastRaid() {
            return this.ticksSinceLastRaid;
        }

        public CompoundTag deserialize() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128356_("position", this.position.m_121878_());
            nbt.m_128356_(ModSavedData.ticksSinceLastRaidIdentifier, this.ticksSinceLastRaid);
            return nbt;
        }

        public static AreaofInterestEntry serialize(CompoundTag nbt) {
            return new AreaofInterestEntry(BlockPos.m_122022_((long)nbt.m_128454_("position")), nbt.m_128454_(ModSavedData.ticksSinceLastRaidIdentifier));
        }
    }
}

