/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.core.gravemind;

import com.github.sculkhorde.common.block.SculkNodeBlock;
import com.github.sculkhorde.core.ModSavedData;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.core.gravemind.entity_factory.EntityFactory;
import com.github.sculkhorde.core.gravemind.entity_factory.ReinforcementRequest;
import com.github.sculkhorde.util.BlockAlgorithms;
import com.github.sculkhorde.util.TickUnits;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;

public class Gravemind {
    private evolution_states evolution_state = evolution_states.Undeveloped;
    public static EntityFactory entityFactory;
    private static final int MINIMUM_DISTANCE_BETWEEN_NODES = 300;
    private final int SCULK_NODE_INFECT_RADIUS_UNDEVELOPED = 10;
    public int sculk_node_infect_radius = 10;
    public int sculk_node_limit = 1;
    public static int TICKS_BETWEEN_NODE_SPAWNS;

    public Gravemind() {
        entityFactory = SculkHorde.entityFactory;
        this.calulateCurrentState();
    }

    public evolution_states getEvolutionState() {
        return this.evolution_state;
    }

    public void calulateCurrentState() {
        int MASS_GOAL_FOR_IMMATURE = 5000;
        int MASS_GOAL_FOR_MATURE = 100000000;
        if (SculkHorde.savedData.getSculkAccumulatedMass() >= MASS_GOAL_FOR_IMMATURE) {
            this.sculk_node_infect_radius = 20;
            this.evolution_state = evolution_states.Immature;
        } else if (SculkHorde.savedData.getSculkAccumulatedMass() >= MASS_GOAL_FOR_MATURE) {
            this.sculk_node_infect_radius = 50;
            this.evolution_state = evolution_states.Mature;
            this.sculk_node_limit = 2;
        }
    }

    public void enableAmountOfBeeHives(ServerLevel worldIn, int amount) {
        if (SculkHorde.savedData.getBeeNestEntries().size() <= 0) {
            return;
        }
        int lastEnabledIndex = -1;
        for (int i = 0; i < SculkHorde.savedData.getBeeNestEntries().size(); ++i) {
            ModSavedData.BeeNestEntry entry = SculkHorde.savedData.getBeeNestEntries().get(i);
            if (!entry.isEntryValid(worldIn) || entry.isOccupantsExistingDisabled(worldIn)) continue;
            entry.disableOccupantsExiting(worldIn);
            lastEnabledIndex = i;
        }
        int startIndex = lastEnabledIndex + 1;
        if (startIndex >= SculkHorde.savedData.getBeeNestEntries().size()) {
            startIndex = 0;
        }
        for (int i = startIndex; i < startIndex + amount; ++i) {
            int index = i % SculkHorde.savedData.getBeeNestEntries().size();
            if (!SculkHorde.savedData.getBeeNestEntries().get(index).isEntryValid(worldIn)) continue;
            SculkHorde.savedData.getBeeNestEntries().get(index).enableOccupantsExiting(worldIn);
        }
    }

    public void processReinforcementRequest(ReinforcementRequest context) {
        context.isRequestViewed = true;
        if (context.sender == ReinforcementRequest.senderType.Developer || context.sender == ReinforcementRequest.senderType.SculkMass) {
            context.isRequestApproved = true;
        }
        if (SculkHorde.savedData.getSculkAccumulatedMass() <= 0) {
            return;
        }
        if (this.evolution_state == evolution_states.Undeveloped) {
            context.isRequestApproved = true;
        } else if (this.evolution_state == evolution_states.Immature) {
            if (context.is_aggressor_nearby) {
                context.approvedMobTypes.add(EntityFactory.StrategicValues.Melee);
                context.approvedMobTypes.add(EntityFactory.StrategicValues.Ranged);
                context.isRequestApproved = true;
            } else if (context.is_non_sculk_mob_nearby) {
                context.approvedMobTypes.add(EntityFactory.StrategicValues.Infector);
                context.isRequestApproved = true;
            }
        }
    }

    public boolean isEvolutionStateEqualOrLessThanCurrent(evolution_states stateIn) {
        if (this.evolution_state == evolution_states.Undeveloped) {
            return stateIn == evolution_states.Undeveloped;
        }
        if (this.evolution_state == evolution_states.Immature) {
            return stateIn == evolution_states.Immature || stateIn == evolution_states.Undeveloped;
        }
        if (this.evolution_state == evolution_states.Mature) {
            return stateIn == evolution_states.Undeveloped || stateIn == evolution_states.Immature || stateIn == evolution_states.Mature;
        }
        return false;
    }

    public void placeSculkNode(ServerLevel worldIn, BlockPos targetPos, boolean enableChance) {
        int SPAWN_NODE_COST = 3000;
        int SPAWN_NODE_BUFFER = 1000;
        if (new Random().nextInt(1000) > 1 && enableChance) {
            return;
        }
        if (!SculkHorde.savedData.isSculkNodeCooldownOver()) {
            return;
        }
        if (!SculkHorde.gravemind.isValidPositionForSculkNode(worldIn, targetPos)) {
            return;
        }
        if (SculkHorde.savedData.getSculkAccumulatedMass() < 4000) {
            return;
        }
        SculkNodeBlock.FindAreaAndPlaceNode(worldIn, targetPos);
        SculkHorde.savedData.subtractSculkAccumulatedMass(3000);
    }

    public boolean isValidPositionForSculkNode(ServerLevel worldIn, BlockPos positionIn) {
        if (worldIn.m_45527_(positionIn)) {
            return false;
        }
        if (SculkHorde.savedData.getNodeEntries().size() >= SculkHorde.gravemind.sculk_node_limit) {
            return false;
        }
        for (ModSavedData.NodeEntry entry : SculkHorde.savedData.getNodeEntries()) {
            int distanceFromPotentialToCurrentNode = (int)BlockAlgorithms.getBlockDistance(positionIn, entry.getPosition());
            if (distanceFromPotentialToCurrentNode >= 300) continue;
            return false;
        }
        return true;
    }

    static {
        TICKS_BETWEEN_NODE_SPAWNS = TickUnits.convertHoursToTicks(1);
    }

    public static enum evolution_states {
        Undeveloped,
        Immature,
        Mature;

    }
}

