/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.core.gravemind;

import com.github.sculkhorde.common.entity.ISculkSmartEntity;
import com.github.sculkhorde.core.BlockRegistry;
import com.github.sculkhorde.core.EntityRegistry;
import com.github.sculkhorde.core.ModSavedData;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.core.SoundRegistry;
import com.github.sculkhorde.core.gravemind.DefaultRaidWavePatterns;
import com.github.sculkhorde.core.gravemind.Gravemind;
import com.github.sculkhorde.core.gravemind.entity_factory.EntityFactory;
import com.github.sculkhorde.core.gravemind.entity_factory.EntityFactoryEntry;
import com.github.sculkhorde.util.BlockAlgorithms;
import com.github.sculkhorde.util.BlockSearcher;
import com.github.sculkhorde.util.ChunkLoaderHelper;
import com.github.sculkhorde.util.TickUnits;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class RaidHandler {
    public static int COOLDOWN_BETWEEN_RAIDS = TickUnits.convertMinutesToTicks(5);
    protected int MAX_WAVE_DURATION = TickUnits.convertMinutesToTicks(5);
    protected int waveDuration = 0;
    protected ServerLevel level;
    protected BlockPos raidLocation = BlockPos.f_121853_;
    protected BlockPos objectiveLocation = BlockPos.f_121853_;
    protected BlockPos raidCenter = BlockPos.f_121853_;
    protected int raidRadius = 150;
    protected ArrayList<ISculkSmartEntity> waveParticipants = new ArrayList();
    private RaidState raidState = RaidState.INACTIVE;
    private EntityFactory.StrategicValues[] currentWavePattern;
    private int maxWaves = 2;
    private int currentWave = 0;
    private int remainingWaveParticipants = 0;
    protected ModSavedData.AreaofInterestEntry areaOfInterestEntry;
    private static ArrayList<BlockPos> high_priority_targets = new ArrayList();
    private static ArrayList<BlockPos> medium_priority_targets = new ArrayList();
    private static ArrayList<BlockPos> low_priority_targets = new ArrayList();
    private BlockSearcher blockSearcher;
    private Predicate<BlockPos> isSpawnObstructed = blockPos -> {
        if (this.level.m_8055_(blockPos).m_60795_() || this.level.m_8055_(blockPos).m_60713_(Blocks.f_49990_) || this.level.m_8055_(blockPos).m_60713_(Blocks.f_49991_)) {
            return true;
        }
        if (!this.level.m_8055_(blockPos.m_7494_()).m_247087_() || this.level.m_8055_(blockPos.m_7494_()).m_60713_(Blocks.f_49990_) || this.level.m_8055_(blockPos.m_7494_()).m_60713_(Blocks.f_49991_)) {
            return true;
        }
        if (!this.level.m_8055_(blockPos.m_7494_()).m_247087_() || this.level.m_8055_(blockPos.m_6630_(1)).m_60713_(Blocks.f_49990_) || this.level.m_8055_(blockPos.m_6630_(1)).m_60713_(Blocks.f_49991_)) {
            return true;
        }
        return !this.level.m_8055_(blockPos.m_7494_()).m_247087_() || this.level.m_8055_(blockPos.m_6630_(2)).m_60713_(Blocks.f_49990_) || this.level.m_8055_(blockPos.m_6630_(2)).m_60713_(Blocks.f_49991_);
    };
    private Predicate<BlockPos> isSpawnTarget = blockPos -> (double)BlockAlgorithms.getBlockDistance(blockPos, this.raidLocation) > (double)this.raidRadius * 0.75;

    public RaidHandler(ServerLevel levelIn) {
        this.setLevel(levelIn);
    }

    public ServerLevel getLevel() {
        return this.level;
    }

    public void setLevel(ServerLevel levelIn) {
        this.level = levelIn;
    }

    public BlockPos getRaidLocation() {
        return this.raidLocation;
    }

    public Vec3 getRaidLocationVec3() {
        return new Vec3((double)this.raidLocation.m_123341_(), (double)this.raidLocation.m_123342_(), (double)this.raidLocation.m_123343_());
    }

    public void setRaidLocation(BlockPos raidLocationIn) {
        this.raidLocation = raidLocationIn;
    }

    public boolean canRaidStart() {
        if (SculkHorde.gravemind.getEvolutionState() == Gravemind.evolution_states.Undeveloped) {
            return false;
        }
        if (!SculkHorde.savedData.isRaidCooldownOver()) {
            return false;
        }
        return !SculkHorde.savedData.getAreasOfInterestEntries().isEmpty();
    }

    public boolean isRaidActive() {
        return this.raidState == RaidState.ACTIVE_WAVE;
    }

    public void setRaidState(RaidState raidStateIn) {
        this.raidState = raidStateIn;
    }

    public int getRaidRadius() {
        return this.raidRadius;
    }

    public void setRaidRadius(int raidRadiusIn) {
        this.raidRadius = raidRadiusIn;
    }

    public boolean areWaveParticipantsDead() {
        return this.remainingWaveParticipants <= 0;
    }

    private void updateRemainingWaveParticipantsAmount() {
        this.remainingWaveParticipants = 0;
        for (ISculkSmartEntity entity : this.waveParticipants) {
            if (!((Mob)entity).m_6084_()) continue;
            ++this.remainingWaveParticipants;
        }
    }

    protected void removeWaveParticipantsFromList() {
        for (ISculkSmartEntity entity : this.waveParticipants) {
            if (((Mob)entity).m_6084_()) {
                ((Mob)entity).m_21219_();
                continue;
            }
            ((Mob)entity).m_146870_();
        }
        this.waveParticipants.clear();
    }

    public BlockPos getObjectiveLocation() {
        return this.objectiveLocation;
    }

    public Vec3 getObjectiveLocationVec3() {
        return new Vec3((double)this.objectiveLocation.m_123341_(), (double)this.objectiveLocation.m_123342_(), (double)this.objectiveLocation.m_123343_());
    }

    public void setObjectiveLocation(BlockPos objectiveLocationIn) {
        this.objectiveLocation = objectiveLocationIn;
    }

    public Optional<BlockPos> popObjectiveLocation() {
        Optional<BlockPos> objective = Optional.empty();
        if (!high_priority_targets.isEmpty()) {
            objective = Optional.of(high_priority_targets.get(0));
            high_priority_targets.remove(0);
        } else if (!medium_priority_targets.isEmpty()) {
            objective = Optional.of(medium_priority_targets.get(0));
            medium_priority_targets.remove(0);
        } else if (!low_priority_targets.isEmpty()) {
            objective = Optional.of(low_priority_targets.get(0));
            low_priority_targets.remove(0);
        }
        return objective;
    }

    public Optional<BlockPos> getNextObjectiveLocation() {
        Optional<BlockPos> objective = Optional.empty();
        if (!high_priority_targets.isEmpty()) {
            objective = Optional.of(high_priority_targets.get(0));
        } else if (!medium_priority_targets.isEmpty()) {
            objective = Optional.of(medium_priority_targets.get(0));
        } else if (!low_priority_targets.isEmpty()) {
            objective = Optional.of(low_priority_targets.get(0));
        }
        return objective;
    }

    public void reset() {
        SculkHorde.savedData.removeAreaOfInterestFromMemory(this.areaOfInterestEntry.getPosition());
        ChunkLoaderHelper.unloadChunksInRadius(this.level, this.getRaidLocation(), this.getRaidLocation().m_123341_() >> 4, this.getRaidLocation().m_123343_() >> 4, 5);
        this.blockSearcher = null;
        this.setRaidState(RaidState.INACTIVE);
        this.setRaidLocation(BlockPos.f_121853_);
        this.setObjectiveLocation(BlockPos.f_121853_);
        this.waveParticipants.clear();
        this.remainingWaveParticipants = 0;
        this.currentWave = 0;
    }

    public void raidTick() {
        switch (this.raidState) {
            case INACTIVE: {
                this.inactiveRaidTick();
                break;
            }
            case INVESTIGATING_LOCATION: {
                this.investigatingLocationTick();
                break;
            }
            case INITIALIZING_RAID: {
                this.initializingRaidTick();
                break;
            }
            case INITIALIZING_WAVE: {
                this.initializingWaveTick();
                break;
            }
            case ACTIVE_WAVE: {
                this.activeWaveTick();
                break;
            }
            case COMPLETE: {
                this.completeRaidTick();
                break;
            }
            case FAILED: {
                this.failureRaidTick();
            }
        }
    }

    private void inactiveRaidTick() {
        SculkHorde.savedData.incrementTicksSinceLastRaid();
        if (this.canRaidStart()) {
            this.setRaidState(RaidState.INVESTIGATING_LOCATION);
        }
    }

    private void investigatingLocationTick() {
        if (SculkHorde.savedData.getAreasOfInterestEntries().isEmpty()) {
            this.setRaidState(RaidState.FAILED);
            return;
        }
        if (this.blockSearcher == null) {
            this.areaOfInterestEntry = SculkHorde.savedData.getAreasOfInterestEntries().get(0);
            this.blockSearcher = new BlockSearcher(this.level, this.areaOfInterestEntry.getPosition());
            this.blockSearcher.setMaxDistance(this.getRaidRadius());
            this.blockSearcher.setDebugMode(SculkHorde.DEBUG_MODE);
            this.blockSearcher.searchIterationsPerTick = 100;
            this.blockSearcher.ignoreBlocksNearTargets = true;
            this.blockSearcher.setTargetBlockPredicate(new Predicate<BlockPos>(){

                @Override
                public boolean test(BlockPos blockPos) {
                    return RaidHandler.this.level.m_8055_(blockPos).m_204336_(BlockRegistry.Tags.SCULK_RAID_TARGET_HIGH_PRIORITY) || RaidHandler.this.level.m_8055_(blockPos).m_204336_(BlockRegistry.Tags.SCULK_RAID_TARGET_LOW_PRIORITY) || RaidHandler.this.level.m_8055_(blockPos).m_204336_(BlockRegistry.Tags.SCULK_RAID_TARGET_MEDIUM_PRIORITY);
                }
            });
            this.blockSearcher.setObstructionPredicate(new Predicate<BlockPos>(){

                @Override
                public boolean test(BlockPos blockPos) {
                    if (RaidHandler.this.level.m_8055_(blockPos).m_60713_(Blocks.f_50016_)) {
                        return true;
                    }
                    return !BlockAlgorithms.isExposedToAir(RaidHandler.this.level, blockPos);
                }
            });
            this.blockSearcher.MAX_TARGETS = 10;
        }
        this.blockSearcher.tick();
        if (!this.blockSearcher.isFinished) {
            return;
        }
        if (this.blockSearcher.isSuccessful) {
            high_priority_targets.clear();
            medium_priority_targets.clear();
            low_priority_targets.clear();
            for (BlockPos blockPos : this.blockSearcher.foundTargets) {
                if (this.level.m_8055_(blockPos).m_204336_(BlockRegistry.Tags.SCULK_RAID_TARGET_HIGH_PRIORITY)) {
                    high_priority_targets.add(blockPos);
                    continue;
                }
                if (this.level.m_8055_(blockPos).m_204336_(BlockRegistry.Tags.SCULK_RAID_TARGET_LOW_PRIORITY)) {
                    medium_priority_targets.add(blockPos);
                    continue;
                }
                if (!this.level.m_8055_(blockPos).m_204336_(BlockRegistry.Tags.SCULK_RAID_TARGET_LOW_PRIORITY)) continue;
                low_priority_targets.add(blockPos);
            }
            high_priority_targets.sort(new Comparator<BlockPos>(){

                @Override
                public int compare(BlockPos blockPos, BlockPos t1) {
                    return (int)(blockPos.m_123331_((Vec3i)RaidHandler.this.blockSearcher.origin) - t1.m_123331_((Vec3i)RaidHandler.this.getRaidLocation()));
                }
            });
            medium_priority_targets.sort(new Comparator<BlockPos>(){

                @Override
                public int compare(BlockPos blockPos, BlockPos t1) {
                    return (int)(blockPos.m_123331_((Vec3i)RaidHandler.this.blockSearcher.origin) - t1.m_123331_((Vec3i)RaidHandler.this.getRaidLocation()));
                }
            });
            low_priority_targets.sort(new Comparator<BlockPos>(){

                @Override
                public int compare(BlockPos blockPos, BlockPos t1) {
                    return (int)(blockPos.m_123331_((Vec3i)RaidHandler.this.blockSearcher.origin) - t1.m_123331_((Vec3i)RaidHandler.this.getRaidLocation()));
                }
            });
            this.maxWaves = high_priority_targets.size() + medium_priority_targets.size() + low_priority_targets.size();
            this.setRaidLocation(this.areaOfInterestEntry.getPosition());
            SculkHorde.LOGGER.debug("RaidHandler | Found " + this.maxWaves + " objective targets.");
            this.setRaidState(RaidState.INITIALIZING_RAID);
        } else {
            this.setRaidState(RaidState.FAILED);
            SculkHorde.LOGGER.debug("RaidHandler | Found no objective targets. Not Initializing Raid.");
        }
        this.blockSearcher = null;
    }

    private void initializingRaidTick() {
        SculkHorde.savedData.setTicksSinceLastRaid(0);
        int MAX_SEARCH_DISTANCE = this.getRaidRadius();
        if (this.blockSearcher == null) {
            ArrayList<BlockPos> allTargets = new ArrayList<BlockPos>();
            allTargets.addAll(high_priority_targets);
            allTargets.addAll(medium_priority_targets);
            allTargets.addAll(low_priority_targets);
            if (allTargets.size() == 0) {
                this.setRaidState(RaidState.FAILED);
                return;
            }
            this.raidCenter = BlockAlgorithms.getCentroid(allTargets);
            allTargets.clear();
            this.blockSearcher = new BlockSearcher(this.level, this.getRaidLocation());
            this.blockSearcher.setMaxDistance(MAX_SEARCH_DISTANCE);
            this.blockSearcher.setTargetBlockPredicate(this.isSpawnTarget);
            this.blockSearcher.setObstructionPredicate(this.isSpawnObstructed);
            this.blockSearcher.setMaxTargets(1);
            this.blockSearcher.setPositionToMoveAwayFrom(this.raidCenter);
            this.blockSearcher.setDebugMode(SculkHorde.DEBUG_MODE);
            ChunkLoaderHelper.forceLoadChunksInRadius(this.level, this.getRaidLocation(), this.getRaidLocation().m_123341_() >> 4, this.getRaidLocation().m_123343_() >> 4, 5);
        }
        this.blockSearcher.tick();
        if (this.blockSearcher.isFinished && this.blockSearcher.isSuccessful) {
            this.setRaidState(RaidState.INITIALIZING_WAVE);
            SculkHorde.LOGGER.debug("RaidHandler | Found Spawn Location. Initializing Raid.");
            this.level.m_6907_().forEach(player -> {
                if (BlockAlgorithms.getBlockDistanceXZ(this.getRaidLocation(), player.m_20183_()) <= (float)(this.raidRadius * 4) || SculkHorde.DEBUG_MODE) {
                    player.m_5661_((Component)Component.m_237113_((String)("Sculk Raid Commencing at: " + this.getRaidLocation())), false);
                }
            });
        } else if (this.blockSearcher.isFinished && !this.blockSearcher.isSuccessful) {
            this.setRaidState(RaidState.FAILED);
            SculkHorde.LOGGER.debug("RaidHandler | Unable to Find Spawn Location. Not Initializing Raid.");
        }
    }

    private void initializingWaveTick() {
        this.waveDuration = 0;
        this.currentWavePattern = this.getWavePattern();
        Optional<BlockPos> objectiveOptional = this.popObjectiveLocation();
        if (objectiveOptional.isPresent()) {
            this.objectiveLocation = objectiveOptional.get();
        } else {
            this.setRaidState(RaidState.FAILED);
        }
        BlockPos spawnLocation = this.blockSearcher.foundTargets.get(0);
        this.populateRaidParticipants(spawnLocation);
        this.level.m_6907_().forEach(player -> {
            if (BlockAlgorithms.getBlockDistanceXZ(this.getRaidLocation(), player.m_20183_()) <= (float)(this.raidRadius * 4) || SculkHorde.DEBUG_MODE) {
                player.m_5661_((Component)Component.m_237113_((String)("RaidHandler | Starting Wave " + this.currentWave + " out of " + this.maxWaves + ".")), false);
            }
        });
        this.waveParticipants.forEach(raidParticipant -> {
            raidParticipant.setParticipatingInRaid(true);
            ((Mob)raidParticipant).m_6034_((double)spawnLocation.m_123341_(), (double)(spawnLocation.m_123342_() + 1), (double)spawnLocation.m_123343_());
            this.level.m_7967_((Entity)raidParticipant);
            ((Mob)raidParticipant).m_7292_(new MobEffectInstance(MobEffects.f_19619_, TickUnits.convertHoursToTicks(1), 0));
        });
        this.level.m_6907_().forEach(player -> {
            if (BlockAlgorithms.getBlockDistanceXZ(this.getRaidLocation(), player.m_20183_()) <= (float)(this.raidRadius * 4) || SculkHorde.DEBUG_MODE) {
                this.level.m_5594_(null, player.m_20183_(), (SoundEvent)SoundRegistry.RAID_START_SOUND.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            }
        });
        SculkHorde.LOGGER.debug("RaidHandler | Spawning mobs at: " + this.blockSearcher.currentPosition);
        this.setRaidState(RaidState.ACTIVE_WAVE);
    }

    protected void endWave() {
        if (this.currentWave == this.maxWaves) {
            this.setRaidState(RaidState.COMPLETE);
            this.level.m_6907_().forEach(player -> {
                if (BlockAlgorithms.getBlockDistanceXZ(this.getRaidLocation(), player.m_20183_()) <= (float)(this.raidRadius * 4) || SculkHorde.DEBUG_MODE) {
                    player.m_5661_((Component)Component.m_237113_((String)"RaidHandler | Completed Final Wave."), false);
                }
            });
            return;
        }
        ++this.currentWave;
        this.level.m_6907_().forEach(player -> {
            if (BlockAlgorithms.getBlockDistanceXZ(this.getRaidLocation(), player.m_20183_()) <= (float)(this.raidRadius * 4) || SculkHorde.DEBUG_MODE) {
                player.m_5661_((Component)Component.m_237113_((String)("RaidHandler | Wave " + (this.currentWave - 1) + " complete.")), false);
            }
        });
        this.setRaidState(RaidState.INITIALIZING_WAVE);
    }

    protected void activeWaveTick() {
        this.updateRemainingWaveParticipantsAmount();
        ++this.waveDuration;
        if (this.waveDuration >= this.MAX_WAVE_DURATION) {
            this.endWave();
            this.removeWaveParticipantsFromList();
        }
        if (this.areWaveParticipantsDead()) {
            this.endWave();
        }
    }

    private void completeRaidTick() {
        this.reset();
    }

    private void failureRaidTick() {
        this.reset();
    }

    private Predicate<EntityFactoryEntry> isValidRaidParticipant(EntityFactory.StrategicValues strategicValue) {
        return entityFactoryEntry -> entityFactoryEntry.getCategory() == strategicValue;
    }

    public EntityFactory.StrategicValues[] getWavePattern() {
        EntityFactory.StrategicValues[][] possibleWavePatterns = new EntityFactory.StrategicValues[][]{DefaultRaidWavePatterns.FIVE_RANGED_FIVE_MELEE, DefaultRaidWavePatterns.TEN_RANGED, DefaultRaidWavePatterns.TEN_MELEE};
        Random random = new Random();
        return possibleWavePatterns[random.nextInt(possibleWavePatterns.length)];
    }

    private void populateRaidParticipants(BlockPos spawnLocation) {
        for (int i = 0; i < this.getWavePattern().length; ++i) {
            Optional<EntityFactoryEntry> randomEntry = EntityFactory.getRandomEntry(this.isValidRaidParticipant(this.getWavePattern()[i]));
            if (randomEntry.isEmpty()) {
                SculkHorde.LOGGER.debug("RaidHandler | Unable to find valid entity for raid.");
                this.setRaidState(RaidState.FAILED);
                return;
            }
            this.waveParticipants.add((ISculkSmartEntity)randomEntry.get().createEntity(this.level, spawnLocation));
        }
        if (this.currentWave == 0) {
            Mob boss = (Mob)((EntityType)EntityRegistry.SCULK_ENDERMAN.get()).m_20615_((Level)this.level);
            boss.m_6034_((double)spawnLocation.m_123341_(), (double)(spawnLocation.m_123342_() + 1), (double)spawnLocation.m_123343_());
            this.waveParticipants.add((ISculkSmartEntity)boss);
        }
    }

    public static enum RaidState {
        INACTIVE,
        INVESTIGATING_LOCATION,
        INITIALIZING_RAID,
        INITIALIZING_WAVE,
        ACTIVE_WAVE,
        COMPLETE,
        FAILED;

    }
}

