/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.core.gravemind.entity_factory;

import com.github.sculkhorde.core.gravemind.entity_factory.EntityFactory;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;

public class ReinforcementRequest {
    public int budget = -1;
    public int remaining_balance = -1;
    public boolean is_aggressor_nearby = false;
    public boolean is_non_sculk_mob_nearby = false;
    public BlockPos[] positions;
    public long creationTime;
    public senderType sender = null;
    public boolean isRequestViewed = false;
    public boolean isRequestApproved = false;
    public ArrayList<EntityFactory.StrategicValues> approvedMobTypes;
    public LivingEntity[] spawnedEntities;

    public ReinforcementRequest(BlockPos blockPosIn) {
        this.positions = new BlockPos[]{blockPosIn};
        this.spawnedEntities = new LivingEntity[this.positions.length];
        this.approvedMobTypes = new ArrayList();
        this.creationTime = System.nanoTime();
    }

    public ReinforcementRequest(BlockPos[] positions) {
        this.positions = positions;
        this.spawnedEntities = new LivingEntity[positions.length];
        this.approvedMobTypes = new ArrayList();
        this.creationTime = System.nanoTime();
    }

    public boolean equals(ReinforcementRequest context) {
        return this.budget == context.budget && this.is_aggressor_nearby == context.is_aggressor_nearby && this.is_non_sculk_mob_nearby == context.is_non_sculk_mob_nearby && this.positions.equals(context.positions) && this.sender == context.sender && this.isRequestViewed == context.isRequestViewed && this.isRequestApproved == context.isRequestApproved && this.approvedMobTypes.equals(context.approvedMobTypes);
    }

    public String toString() {
        return "ReinforcementContext{budget=" + this.budget + ", remaining_balance=" + this.remaining_balance + ", is_aggressor_nearby=" + this.is_aggressor_nearby + ", is_non_sculk_mob_nearby=" + this.is_non_sculk_mob_nearby + ", positions=" + this.positions.toString() + ", sender=" + this.sender + ", isRequestViewed=" + this.isRequestViewed + ", isRequestApproved=" + this.isRequestApproved + ", approvedMobTypes=" + this.approvedMobTypes + "}";
    }

    public static enum senderType {
        Developer,
        SculkMass,
        SculkCocoon;

    }
}

