/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.util;

import com.github.sculkhorde.common.block.SculkBeeNestBlock;
import com.github.sculkhorde.common.block.SculkFloraBlock;
import com.github.sculkhorde.common.block.SculkLivingRockRootBlock;
import com.github.sculkhorde.common.block.TendrilsBlock;
import com.github.sculkhorde.common.blockentity.SculkBeeNestBlockEntity;
import com.github.sculkhorde.common.procedural.structures.PlannedBlock;
import com.github.sculkhorde.core.BlockRegistry;
import com.github.sculkhorde.core.SculkHorde;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;

public class BlockAlgorithms {
    public static float getSudoRNGFromPosition(BlockPos position, int min, int max) {
        int range = max - min;
        long seed = (long)position.m_123341_() * (long)position.m_123342_() * (long)position.m_123343_() + (long)(position.m_123341_() + position.m_123342_() + position.m_123343_());
        int rng = (int)((double)seed % ((double)range + 1.0));
        return rng += min;
    }

    public static ArrayList<BlockPos> getNeighborsCube(BlockPos pos, boolean includeOrigin) {
        ArrayList<BlockPos> neighbors = new ArrayList<BlockPos>();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    if (i == 0 && j == 0 && k == 0 && !includeOrigin) continue;
                    neighbors.add(pos.m_7918_(i, j, k));
                }
            }
        }
        return neighbors;
    }

    public static ArrayList<BlockPos> getAdjacentNeighbors(BlockPos origin) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        list.addAll(BlockAlgorithms.getNeighborsXZPlane(origin, false));
        list.addAll(BlockAlgorithms.getNeighborsXZPlane(origin.m_7494_(), true));
        list.addAll(BlockAlgorithms.getNeighborsXZPlane(origin.m_7495_(), true));
        return list;
    }

    public static ArrayList<BlockPos> getNeighborsXZPlane(BlockPos origin, boolean includeOrigin) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        list.add(origin.m_122012_());
        list.add(origin.m_122012_().m_122029_());
        list.add(origin.m_122012_().m_122024_());
        list.add(origin.m_122029_());
        list.add(origin.m_122019_());
        list.add(origin.m_122019_().m_122029_());
        list.add(origin.m_122019_().m_122024_());
        list.add(origin.m_122024_());
        if (includeOrigin) {
            list.add(origin);
        }
        return list;
    }

    public static float getBlockDistance(BlockPos pos1, BlockPos pos2) {
        return (float)Math.sqrt(Math.pow(pos2.m_123341_() - pos1.m_123341_(), 2.0) + Math.pow(pos2.m_123342_() - pos1.m_123342_(), 2.0) + Math.pow(pos2.m_123343_() - pos1.m_123343_(), 2.0));
    }

    public static float getBlockDistanceXZ(BlockPos pos1, BlockPos pos2) {
        return (float)Math.sqrt(Math.pow(pos2.m_123341_() - pos1.m_123341_(), 2.0) + Math.pow(pos2.m_123343_() - pos1.m_123343_(), 2.0));
    }

    public static BlockPos getCentroid(ArrayList<BlockPos> positions) {
        if (positions.size() == 0) {
            return new BlockPos(0, 0, 0);
        }
        int x = 0;
        int y = 0;
        int z = 0;
        for (BlockPos pos : positions) {
            x += pos.m_123341_();
            y += pos.m_123342_();
            z += pos.m_123343_();
        }
        return new BlockPos(x /= positions.size(), y /= positions.size(), z /= positions.size());
    }

    public static ArrayList<BlockPos> getBlockPosInCube(BlockPos origin, int length, boolean includeOrigin) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        int center_x = origin.m_123341_();
        int center_y = origin.m_123342_();
        int center_z = origin.m_123343_();
        int start_pos_x = center_x - length / 2 - 1;
        int start_pos_y = center_y - length / 2 - 1;
        int start_pos_z = center_z - length / 2 - 1;
        for (int y_offset = 0; y_offset < length; ++y_offset) {
            int current_pos_y = start_pos_y + y_offset;
            for (int z_offset = 0; z_offset < length; ++z_offset) {
                int current_pos_z = start_pos_z + z_offset;
                for (int x_offset = 0; x_offset < length; ++x_offset) {
                    int current_pos_x = start_pos_x + x_offset;
                    boolean shouldWeAddThisPosition = true;
                    BlockPos targetPos = new BlockPos(current_pos_x, current_pos_y, current_pos_z);
                    if (!includeOrigin && targetPos.m_123341_() == origin.m_123341_() && targetPos.m_123342_() == origin.m_123342_() && targetPos.m_123343_() == origin.m_123343_()) {
                        shouldWeAddThisPosition = false;
                    }
                    if (!shouldWeAddThisPosition) continue;
                    positions.add(targetPos);
                }
            }
        }
        return positions;
    }

    public static ArrayList<BlockPos> getBlockPosInCircle(BlockPos origin, int radius, boolean includeOrigin) {
        if (radius <= 0) {
            throw new IllegalArgumentException("Radius must be greater than 0. Radius given was " + radius + ".");
        }
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        int center_x = origin.m_123341_();
        int center_y = origin.m_123342_();
        int center_z = origin.m_123343_();
        int start_pos_x = center_x - radius - 1;
        int start_pos_y = center_y - radius - 1;
        int start_pos_z = center_z - radius - 1;
        for (int y_offset = 0; y_offset < radius * 2 + 2; ++y_offset) {
            int current_pos_y = start_pos_y + y_offset;
            for (int z_offset = 0; z_offset < radius * 2 + 2; ++z_offset) {
                int current_pos_z = start_pos_z + z_offset;
                for (int x_offset = 0; x_offset < radius * 2 + 2; ++x_offset) {
                    int current_pos_x = start_pos_x + x_offset;
                    boolean shouldWeAddThisPosition = true;
                    BlockPos targetPos = new BlockPos(current_pos_x, current_pos_y, current_pos_z);
                    double distance = BlockAlgorithms.getBlockDistance(origin, targetPos);
                    if (distance > (double)radius) {
                        shouldWeAddThisPosition = false;
                    }
                    if (!includeOrigin && targetPos.m_123341_() == origin.m_123341_() && targetPos.m_123342_() == origin.m_123342_() && targetPos.m_123343_() == origin.m_123343_()) {
                        shouldWeAddThisPosition = false;
                    }
                    if (!shouldWeAddThisPosition) continue;
                    positions.add(targetPos);
                }
            }
        }
        return positions;
    }

    public static ArrayList<BlockPos> getBlocksInArea(ServerLevel level, BlockPos origin, Predicate<BlockState> predicate, int distance) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        BlockPos blockPos = origin;
        int minX = blockPos.m_123341_() - distance;
        int minY = blockPos.m_123342_() - distance;
        int minZ = blockPos.m_123343_() - distance;
        int maxX = blockPos.m_123341_() + distance;
        int maxY = blockPos.m_123342_() + distance;
        int maxZ = blockPos.m_123343_() + distance;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    mutableBlockPos.m_122178_(x, y, z);
                    if (level.m_8055_((BlockPos)mutableBlockPos).m_60713_(Blocks.f_50016_) || !predicate.test(level.m_8055_((BlockPos)mutableBlockPos))) continue;
                    list.add(mutableBlockPos.m_7949_());
                }
            }
        }
        return list;
    }

    public static ArrayList<BlockPos> getBlocksInAreaWithBlockPosPredicate(ServerLevel level, BlockPos origin, Predicate<BlockPos> predicate, int distance) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        BlockPos blockPos = origin;
        int minX = blockPos.m_123341_() - distance;
        int minY = blockPos.m_123342_() - distance;
        int minZ = blockPos.m_123343_() - distance;
        int maxX = blockPos.m_123341_() + distance;
        int maxY = blockPos.m_123342_() + distance;
        int maxZ = blockPos.m_123343_() + distance;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    mutableBlockPos.m_122178_(x, y, z);
                    if (level.m_8055_((BlockPos)mutableBlockPos).m_60713_(Blocks.f_50016_) || !predicate.test((BlockPos)mutableBlockPos)) continue;
                    list.add(mutableBlockPos.m_7949_());
                }
            }
        }
        return list;
    }

    public static Optional<BlockPos> findBlockInCube(ServerLevel level, BlockPos origin, Predicate<BlockState> predicate, int distance) {
        BlockPos blockPos = origin;
        int minX = blockPos.m_123341_() - distance;
        int minY = blockPos.m_123342_() - distance;
        int minZ = blockPos.m_123343_() - distance;
        int maxX = blockPos.m_123341_() + distance;
        int maxY = blockPos.m_123342_() + distance;
        int maxZ = blockPos.m_123343_() + distance;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    mutableBlockPos.m_122178_(x, y, z);
                    if (level.m_8055_((BlockPos)mutableBlockPos).m_60713_(Blocks.f_50016_) || !predicate.test(level.m_8055_((BlockPos)mutableBlockPos))) continue;
                    return Optional.of(mutableBlockPos.m_7949_());
                }
            }
        }
        return Optional.empty();
    }

    public static Optional<BlockPos> findBlockInCubeBlockPosPredicate(ServerLevel level, BlockPos origin, Predicate<BlockPos> predicate, int distance) {
        BlockPos blockPos = origin;
        int minX = blockPos.m_123341_() - distance;
        int minY = blockPos.m_123342_() - distance;
        int minZ = blockPos.m_123343_() - distance;
        int maxX = blockPos.m_123341_() + distance;
        int maxY = blockPos.m_123342_() + distance;
        int maxZ = blockPos.m_123343_() + distance;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    mutableBlockPos.m_122178_(x, y, z);
                    if (level.m_8055_((BlockPos)mutableBlockPos).m_60713_(Blocks.f_50016_) || !predicate.test((BlockPos)mutableBlockPos)) continue;
                    return Optional.of(mutableBlockPos.m_7949_());
                }
            }
        }
        return Optional.empty();
    }

    public static boolean isExposedToAir(ServerLevel serverWorld, BlockPos targetPos) {
        ArrayList<BlockPos> list = BlockAlgorithms.getAdjacentNeighbors(targetPos);
        for (BlockPos position : list) {
            if (serverWorld.m_8055_(position).m_60804_((BlockGetter)serverWorld, position)) continue;
            return true;
        }
        return false;
    }

    public static void tryPlaceSculkBeeHive(ServerLevel world, BlockPos targetPos) {
        if (new Random().nextInt(4000) <= 1 && world.m_8055_(targetPos).m_60795_() && world.m_8055_(targetPos.m_7494_()).m_60795_() && world.m_8055_(targetPos.m_7494_().m_7494_()).m_60795_()) {
            world.m_46597_(targetPos, ((SculkBeeNestBlock)((Object)BlockRegistry.SCULK_BEE_NEST_BLOCK.get())).m_49966_());
            SculkBeeNestBlockEntity nest = (SculkBeeNestBlockEntity)world.m_7702_(targetPos);
            nest.addFreshInfectorOccupant();
            nest.addFreshInfectorOccupant();
            nest.addFreshHarvesterOccupant();
            nest.addFreshHarvesterOccupant();
        }
    }

    public static void tryPlaceLivingRockRoot(BlockPos targetPos, ServerLevel world) {
        if (SculkHorde.savedData.isInRangeOfNode(targetPos, 100) && world.m_8055_(targetPos).m_60795_()) {
            world.m_46597_(targetPos, ((SculkLivingRockRootBlock)((Object)BlockRegistry.SCULK_LIVING_ROCK_ROOT_BLOCK.get())).m_49966_());
        }
    }

    public static void tryPlaceSculkFlora(BlockPos targetPos, ServerLevel world) {
        BlockState blockState = SculkHorde.randomSculkFlora.getRandomEntry().m_49966_();
        if (blockState.m_60710_((LevelReader)world, targetPos) && world.m_8055_(targetPos).m_60722_((Fluid)Fluids.f_76193_) && !world.m_8055_(targetPos).m_60713_(Blocks.f_49990_) && !world.m_8055_(targetPos).m_60713_(Blocks.f_49991_)) {
            world.m_46597_(targetPos, blockState);
        }
    }

    public static void placeFloraAroundLog(ServerLevel serverWorld, BlockPos origin) {
        BlockPos[] possiblePositions;
        TendrilsBlock vein = (TendrilsBlock)((Object)BlockRegistry.TENDRILS.get());
        for (BlockPos pos : possiblePositions = new BlockPos[]{origin.m_122012_(), origin.m_122029_(), origin.m_122019_(), origin.m_122024_()}) {
            if (serverWorld.f_46441_.m_188503_(10) >= 3 || !serverWorld.m_8055_(pos).m_60795_()) continue;
            vein.placeBlock((Level)serverWorld, pos);
        }
    }

    public static void placePatchesOfVeinAbove(ServerLevel serverWorld, BlockPos origin) {
        int OFFSET_MAX = 3;
        int LENGTH_MAX = 5;
        int LENGTH_MIN = 3;
        Random rng = new Random();
        int offset = rng.nextInt(OFFSET_MAX);
        int length = rng.nextInt(LENGTH_MAX - LENGTH_MIN) + LENGTH_MIN;
        TendrilsBlock vein = (TendrilsBlock)((Object)BlockRegistry.TENDRILS.get());
        BlockPos indexPos = origin.m_6630_(offset);
        for (int i = 0; i < length; ++i) {
            indexPos = indexPos.m_7494_();
            if (serverWorld.f_46441_.m_188503_(4) > 2) continue;
            vein.placeBlock((Level)serverWorld, indexPos);
        }
    }

    public static void replaceSculkFlora(ServerLevel serverWorld, BlockPos targetPos) {
        if (serverWorld.m_8055_(targetPos).m_60734_() instanceof SculkFloraBlock) {
            serverWorld.m_46597_(targetPos, Blocks.f_50034_.m_49966_());
        } else if (serverWorld.m_8055_(targetPos).m_60734_() instanceof TendrilsBlock) {
            serverWorld.m_7471_(targetPos, false);
        }
    }

    public static ArrayList<PlannedBlock> generate2DCirclePlan(BlockPos centerPos, int diameter, ServerLevel world, BlockState plannedBlock) {
        ArrayList<PlannedBlock> circleBlocks = new ArrayList<PlannedBlock>();
        int radius = diameter / 2;
        for (int x = centerPos.m_123341_() - radius; x <= centerPos.m_123341_() + radius; ++x) {
            for (int z = centerPos.m_123343_() - radius; z <= centerPos.m_123343_() + radius; ++z) {
                double distance = Math.sqrt((x - centerPos.m_123341_()) * (x - centerPos.m_123341_()) + (z - centerPos.m_123343_()) * (z - centerPos.m_123343_()));
                if (!(distance <= (double)radius)) continue;
                BlockPos pos = new BlockPos(x, centerPos.m_123342_(), z);
                circleBlocks.add(new PlannedBlock(world, plannedBlock, pos));
            }
        }
        return circleBlocks;
    }

    public static ArrayList<BlockPos> getPointsOnCircumference(BlockPos origin, int numPoints, int radius) {
        ArrayList<BlockPos> points = new ArrayList<BlockPos>();
        double angleIncrement = Math.PI * 2 / (double)numPoints;
        for (int i = 0; i < numPoints; ++i) {
            double angle = (double)i * angleIncrement;
            int x = (int)((double)origin.m_123341_() + (double)radius * Math.cos(angle));
            int z = (int)((double)origin.m_123343_() + (double)radius * Math.sin(angle));
            points.add(new BlockPos(x, origin.m_123342_(), z));
        }
        return points;
    }

    public static Vec3 scalarMultiply(Vec3 vector, double t) {
        return new Vec3(vector.f_82479_ + t, vector.f_82480_ * t, vector.f_82481_ + t);
    }
}

