/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.util;

import com.github.sculkhorde.core.BlockRegistry;
import com.github.sculkhorde.core.ModSavedData;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.core.gravemind.Gravemind;
import com.github.sculkhorde.util.BlockSearcher;
import com.github.sculkhorde.util.TickUnits;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;

public class DeathAreaInvestigator {
    private BlockSearcher blockSearcher;
    private ServerLevel level;
    private Optional<ModSavedData.DeathAreaEntry> searchEntry;
    private int ticksSinceLastSuccessfulFind = 0;
    private final int tickIntervalsBetweenSuccessfulFinds = TickUnits.convertMinutesToTicks(1);
    private int ticksSinceLastSearch = 0;
    private final int tickIntervalsBetweenSearches = TickUnits.convertMinutesToTicks(1);
    State state = State.IDLE;

    public DeathAreaInvestigator(ServerLevel level) {
        this.level = level;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state2) {
        this.state = state2;
    }

    public void idleTick() {
        if (SculkHorde.gravemind.getEvolutionState() == Gravemind.evolution_states.Undeveloped) {
            return;
        }
        if (this.ticksSinceLastSuccessfulFind >= this.tickIntervalsBetweenSuccessfulFinds && this.ticksSinceLastSearch >= this.tickIntervalsBetweenSearches && !SculkHorde.raidHandler.isRaidActive()) {
            this.ticksSinceLastSearch = 0;
            this.searchEntry = SculkHorde.savedData.getDeathAreaWithHighestDeaths();
            if (this.searchEntry.isPresent()) {
                this.setState(State.INITIALIZING);
            }
        }
    }

    public void initializeTick() {
        this.blockSearcher = new BlockSearcher(this.level, this.searchEntry.get().getPosition());
        this.blockSearcher.setMaxDistance(25);
        this.blockSearcher.setObstructionPredicate(pos -> this.level.m_8055_(pos).m_60795_());
        this.blockSearcher.setTargetBlockPredicate(pos -> this.level.m_8055_(pos).m_204336_(BlockRegistry.Tags.SCULK_RAID_TARGET_HIGH_PRIORITY) || this.level.m_8055_(pos).m_204336_(BlockRegistry.Tags.SCULK_RAID_TARGET_LOW_PRIORITY) || this.level.m_8055_(pos).m_204336_(BlockRegistry.Tags.SCULK_RAID_TARGET_MEDIUM_PRIORITY));
        this.setState(State.SEARCHING);
    }

    public void searchTick() {
        this.blockSearcher.tick();
        if (this.blockSearcher.isFinished && this.blockSearcher.isSuccessful) {
            this.ticksSinceLastSuccessfulFind = 0;
            this.setState(State.FINISHED);
            SculkHorde.LOGGER.debug("DeathAreaInvestigator | Located Important Blocks at " + this.searchEntry.get().getPosition());
            SculkHorde.savedData.addAreaOfInterestToMemory(this.searchEntry.get().getPosition());
        } else if (this.blockSearcher.isFinished && !this.blockSearcher.isSuccessful) {
            this.setState(State.FINISHED);
            this.blockSearcher = null;
            SculkHorde.LOGGER.debug("DeathAreaInvestigator | Unable to Locate Important Blocks at " + this.searchEntry.get().getPosition());
        }
    }

    public void finishedTick() {
        SculkHorde.savedData.removeDeathAreaFromMemory(this.searchEntry.get().getPosition());
        this.ticksSinceLastSearch = 0;
        this.setState(State.IDLE);
        this.blockSearcher = null;
        this.searchEntry = Optional.empty();
    }

    public void tick() {
        ++this.ticksSinceLastSuccessfulFind;
        ++this.ticksSinceLastSearch;
        switch (this.state) {
            case IDLE: {
                this.idleTick();
                break;
            }
            case INITIALIZING: {
                this.initializeTick();
                break;
            }
            case SEARCHING: {
                this.searchTick();
                break;
            }
            case FINISHED: {
                this.finishedTick();
            }
        }
    }

    static enum State {
        IDLE,
        INITIALIZING,
        SEARCHING,
        FINISHED;

    }
}

