/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.util;

import com.github.sculkhorde.common.entity.SculkBeeHarvesterEntity;
import com.github.sculkhorde.common.entity.SculkBeeInfectorEntity;
import com.github.sculkhorde.common.entity.SculkCreeperEntity;
import com.github.sculkhorde.common.entity.SculkEndermanEntity;
import com.github.sculkhorde.common.entity.SculkHatcherEntity;
import com.github.sculkhorde.common.entity.SculkMiteAggressorEntity;
import com.github.sculkhorde.common.entity.SculkMiteEntity;
import com.github.sculkhorde.common.entity.SculkRavagerEntity;
import com.github.sculkhorde.common.entity.SculkSpitterEntity;
import com.github.sculkhorde.common.entity.SculkSporeSpewerEntity;
import com.github.sculkhorde.common.entity.SculkVindicatorEntity;
import com.github.sculkhorde.common.entity.SculkZombieEntity;
import com.github.sculkhorde.core.EffectRegistry;
import com.github.sculkhorde.core.SculkHorde;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class EntityAlgorithms {
    public static Predicate<LivingEntity> isSculkLivingEntity = e -> e instanceof SculkMiteEntity || e instanceof SculkMiteAggressorEntity || e instanceof SculkZombieEntity || e instanceof SculkSpitterEntity || e instanceof SculkSporeSpewerEntity || e instanceof SculkBeeHarvesterEntity || e instanceof SculkBeeInfectorEntity || e instanceof SculkHatcherEntity || e instanceof SculkRavagerEntity || e instanceof SculkVindicatorEntity || e instanceof SculkCreeperEntity || e instanceof SculkEndermanEntity;

    @Nullable
    public static BlockPos playerTargetBlockPos(Player player, boolean isFluid) {
        HitResult block = player.m_19907_(200.0, 0.0f, isFluid);
        if (block.m_6662_() == HitResult.Type.BLOCK) {
            return ((BlockHitResult)block).m_82425_();
        }
        return null;
    }

    public static AABB getSearchAreaRectangle(double originX, double originY, double originZ, double w, double h, double l) {
        double x1 = originX - w;
        double y1 = originY - h;
        double z1 = originZ - l;
        double x2 = originX + w;
        double y2 = originY + h;
        double z2 = originZ + l;
        return new AABB(x1, y1, z1, x2, y2, z2);
    }

    public static boolean isLivingEntityInfected(LivingEntity e) {
        return e.m_21023_((MobEffect)EffectRegistry.SCULK_INFECTION.get());
    }

    public static boolean isLivingEntityHostile(LivingEntity entity) {
        return SculkHorde.savedData.getHostileEntries().get(entity.m_6095_().toString()) != null;
    }

    public static boolean isLivingEntitySwimmer(LivingEntity entity) {
        return entity instanceof WaterAnimal;
    }

    public static List<LivingEntity> getLivingEntitiesInBoundingBox(ServerLevel serverLevel, AABB boundingBox) {
        List livingEntitiesInRange = serverLevel.m_6443_(LivingEntity.class, boundingBox, (Predicate)new Predicate<LivingEntity>(){

            @Override
            public boolean test(LivingEntity livingEntity) {
                return true;
            }
        });
        return livingEntitiesInRange;
    }
}

