/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.util;

import com.github.sculkhorde.common.block.SculkMassBlock;
import com.github.sculkhorde.core.BlockRegistry;
import com.github.sculkhorde.core.EffectRegistry;
import com.github.sculkhorde.core.EntityRegistry;
import com.github.sculkhorde.core.ModSavedData;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.core.gravemind.Gravemind;
import com.github.sculkhorde.core.gravemind.RaidHandler;
import com.github.sculkhorde.util.DeathAreaInvestigator;
import com.github.sculkhorde.util.EntityAlgorithms;
import com.github.sculkhorde.util.TickUnits;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="sculkhorde", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEventSubscriber {
    private static long time_save_point;
    private static int sculkMassCheck;

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        if (!event.getLevel().m_5776_() && event.getLevel().equals(ServerLifecycleHooks.getCurrentServer().m_129783_())) {
            SculkHorde.savedData = (ModSavedData)ServerLifecycleHooks.getCurrentServer().m_129783_().m_8895_().m_164861_(ModSavedData::load, ModSavedData::new, "sculkhorde_gravemind_memory");
            SculkHorde.gravemind = new Gravemind();
            SculkHorde.deathAreaInvestigator = new DeathAreaInvestigator((ServerLevel)event.getLevel());
            SculkHorde.raidHandler = new RaidHandler((ServerLevel)event.getLevel());
            time_save_point = 0L;
            sculkMassCheck = 0;
        }
    }

    @SubscribeEvent
    public static void WorldTickEvent(TickEvent.LevelTickEvent event) {
        if (!event.level.m_5776_() && SculkHorde.gravemind != null && event.level.equals(ServerLifecycleHooks.getCurrentServer().m_129783_())) {
            SculkHorde.savedData.incrementTicksSinceSculkNodeDestruction();
            SculkHorde.infestationConversionTable.processDeInfectionQueue((ServerLevel)event.level);
            if (event.level.m_46467_() - time_save_point > (long)TickUnits.convertMinutesToTicks(5)) {
                time_save_point = event.level.m_46467_();
                SculkHorde.gravemind.enableAmountOfBeeHives((ServerLevel)event.level, 20);
                SculkHorde.savedData.validateNodeEntries();
                SculkHorde.savedData.validateBeeNestEntries();
                SculkHorde.savedData.validatePriorityBlockEntries();
                SculkHorde.gravemind.calulateCurrentState();
                if (SculkHorde.DEBUG_MODE) {
                    System.out.println("Gravemind Evolution State: " + SculkHorde.gravemind.getEvolutionState().toString());
                }
                if (SculkHorde.DEBUG_MODE) {
                    System.out.println("Able to Spawn Node?: " + SculkHorde.savedData.isSculkNodeCooldownOver());
                }
                if (SculkHorde.DEBUG_MODE) {
                    System.out.println("Accumulated Mass Since Last Check: " + (SculkHorde.savedData.getSculkAccumulatedMass() - sculkMassCheck));
                }
                sculkMassCheck = SculkHorde.savedData.getSculkAccumulatedMass();
                if (SculkHorde.DEBUG_MODE) {
                    System.out.println("\n Known Nodes: " + SculkHorde.savedData.getNodeEntries().size() + "\n Known Nests: " + SculkHorde.savedData.getBeeNestEntries().size() + "\n Known Hostiles: " + SculkHorde.savedData.getHostileEntries().size() + "\n");
                }
                if (SculkHorde.DEBUG_MODE) {
                    System.out.println("Accumulated Mass Since Last Check: " + (SculkHorde.savedData.getSculkAccumulatedMass() - sculkMassCheck));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingEntityDeathEvent(LivingDeathEvent event) {
        if (event.getEntity().f_19853_.m_5776_()) {
            return;
        }
        if (EntityAlgorithms.isSculkLivingEntity.test(event.getEntity())) {
            SculkHorde.savedData.reportDeath(event.getEntity().m_20183_());
            SculkHorde.savedData.addHostileToMemory(event.getEntity().m_21188_());
        }
    }

    @SubscribeEvent
    public static void onPotionExpireEvent(MobEffectEvent.Expired event) {
        if (!event.getEntity().f_19853_.m_5776_() && SculkHorde.gravemind != null && event.getEntity().f_19853_.equals(ServerLifecycleHooks.getCurrentServer().m_129783_())) {
            LivingEntity entity;
            MobEffectInstance effectInstance = event.getEffectInstance();
            assert (effectInstance != null);
            if (effectInstance.m_19544_() == EffectRegistry.SCULK_INFECTION.get() && (entity = event.getEntity()) != null && entity instanceof LivingEntity) {
                int infectionDamage = 4;
                Level entityLevel = entity.f_19853_;
                BlockPos entityPosition = entity.m_20183_();
                float entityHealth = entity.m_21233_();
                ((EntityType)EntityRegistry.SCULK_MITE.get()).m_262496_((ServerLevel)event.getEntity().f_19853_, entityPosition, MobSpawnType.SPAWNER);
                SculkMassBlock sculkMass = (SculkMassBlock)((Object)BlockRegistry.SCULK_MASS.get());
                sculkMass.spawn(entityLevel, entityPosition, entityHealth);
                entity.m_6469_(entity.m_269291_().m_269425_(), (float)infectionDamage);
            }
        }
    }
}

