/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.util;

import com.github.sculkhorde.common.entity.InfestationPurifierEntity;
import com.github.sculkhorde.util.EntityAlgorithms;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;

public class TargetParameters {
    private Mob mob;
    private boolean targetHostiles = false;
    private boolean targetPassives = false;
    private boolean targetInfected = false;
    private boolean targetBelow50PercentHealth = true;
    private boolean targetSwimmers = false;
    private boolean mustSeeTarget = false;
    private long lastTargetSeenTime = System.currentTimeMillis();
    private long MAX_TARGET_UNSEEN_TIME_MILLIS = TimeUnit.SECONDS.toMillis(30L);
    private boolean mustReachTarget = false;
    private HashMap<UUID, Long> blacklist = new HashMap();
    private boolean canBlackListMobs = true;
    public final Predicate<LivingEntity> isPossibleNewTargetValid = e -> this.isEntityValidTarget((LivingEntity)e, false);

    public TargetParameters() {
        this.mob = null;
    }

    public TargetParameters(Mob mob) {
        this.mob = mob;
    }

    public boolean isEntityValidTarget(LivingEntity e, boolean validatingExistingTarget) {
        if (e == null) {
            return false;
        }
        if (!(e instanceof Mob) && !(e instanceof Player)) {
            return false;
        }
        if (EntityAlgorithms.isSculkLivingEntity.test(e)) {
            return false;
        }
        if (e instanceof Creeper) {
            return false;
        }
        if (e instanceof InfestationPurifierEntity) {
            return true;
        }
        if (!e.m_6097_() || e.m_20147_() || !e.m_6084_() || e.m_5833_()) {
            return false;
        }
        if (e instanceof Player && (((Player)e).m_7500_() || ((Player)e).m_5833_())) {
            return false;
        }
        if (e instanceof Player) {
            return true;
        }
        if (this.isOnBlackList((Mob)e)) {
            return false;
        }
        if (!this.targetInfected && EntityAlgorithms.isLivingEntityInfected(e)) {
            return false;
        }
        if (!this.targetPassives && !EntityAlgorithms.isLivingEntityHostile(e)) {
            return false;
        }
        if (!this.targetHostiles && EntityAlgorithms.isLivingEntityHostile(e)) {
            return false;
        }
        if (!this.targetSwimmers && EntityAlgorithms.isLivingEntitySwimmer(e)) {
            return false;
        }
        if (!this.targetBelow50PercentHealth && e.m_21223_() < e.m_21233_() / 2.0f) {
            return false;
        }
        return validatingExistingTarget || !this.mustReachTarget() || this.canReach(e);
    }

    public TargetParameters enableBlackListMobs() {
        this.canBlackListMobs = true;
        return this;
    }

    public TargetParameters disableBlackListMobs() {
        this.canBlackListMobs = false;
        return this;
    }

    public boolean canBlackListMobs() {
        return this.canBlackListMobs;
    }

    public TargetParameters enableTargetHostiles() {
        this.targetHostiles = true;
        return this;
    }

    public boolean isTargetingHostiles() {
        return this.targetHostiles;
    }

    public TargetParameters enableTargetPassives() {
        this.targetPassives = true;
        return this;
    }

    public boolean isTargetingPassives() {
        return this.targetPassives;
    }

    public TargetParameters enableTargetInfected() {
        this.targetInfected = true;
        return this;
    }

    public boolean isTargetingInfected() {
        return this.targetInfected;
    }

    public TargetParameters ignoreTargetBelow50PercentHealth() {
        this.targetBelow50PercentHealth = false;
        return this;
    }

    public boolean isIgnoringTargetBelow50PercentHealth() {
        return this.targetBelow50PercentHealth;
    }

    public TargetParameters enableTargetSwimmers() {
        this.targetSwimmers = true;
        return this;
    }

    public boolean isTargetingSwimmers() {
        return this.targetSwimmers;
    }

    public TargetParameters enableMustReachTarget() {
        if (this.mob == null) {
            throw new IllegalStateException("Cannot enable must reach target without a mob");
        }
        this.mustReachTarget = true;
        return this;
    }

    public boolean mustReachTarget() {
        return this.mustReachTarget;
    }

    private boolean canReach(LivingEntity pTarget) {
        int j;
        Path path = this.mob.m_21573_().m_6570_((Entity)pTarget, 0);
        if (path == null) {
            return false;
        }
        Node pathpoint = path.m_77395_();
        if (pathpoint == null) {
            return false;
        }
        int i = pathpoint.f_77271_ - Mth.m_14107_((double)pTarget.m_20185_());
        return (double)(i * i + (j = pathpoint.f_77273_ - Mth.m_14107_((double)pTarget.m_20189_())) * j) <= 50.0;
    }

    public void addToBlackList(Mob entity) {
        this.blacklist.put(entity.m_20148_(), System.currentTimeMillis());
    }

    public boolean isOnBlackList(Mob entity) {
        return this.blacklist.containsKey(entity.m_20148_());
    }
}

