/*
 * Decompiled with CFR 0.152.
 */
package com.insane96mcp.shieldsplus.world.item;

import com.insane96mcp.shieldsplus.render.ShieldBlockEntityWithoutLevelRenderer;
import com.insane96mcp.shieldsplus.setup.SPEnchantments;
import com.insane96mcp.shieldsplus.world.item.SPShieldMaterial;
import com.insane96mcp.shieldsplus.world.item.enchantment.ShieldReflectionEnchantment;
import com.insane96mcp.shieldsplus.world.item.enchantment.ShieldReinforcedEnchantment;
import java.text.DecimalFormat;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IItemRenderProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SPShieldItem
extends ShieldItem {
    public static final EnchantmentCategory SHIELD = EnchantmentCategory.create((String)"shield", s -> s instanceof ShieldItem);
    public static final ResourceLocation BLOCKING = new ResourceLocation("minecraft:blocking");
    public final SPShieldMaterial material;
    @OnlyIn(value=Dist.CLIENT)
    public Material clientMaterial;
    @OnlyIn(value=Dist.CLIENT)
    public Material clientMaterialNoPattern;

    public SPShieldItem(SPShieldMaterial material, Item.Properties p_43089_) {
        super(p_43089_);
        this.material = material;
    }

    @NotNull
    public String m_5671_(@NotNull ItemStack itemStack) {
        return super.m_5524_();
    }

    public double getBlockedDamage() {
        return this.material.damageBlocked;
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return ShieldBlockEntityWithoutLevelRenderer.instance;
            }
        });
    }

    public int m_6473_() {
        return this.material.enchantmentValue;
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, components, tooltipFlag);
        SPShieldItem.addDamageBlockedText(itemStack, components, this.getBlockedDamage());
    }

    public static void addDamageBlockedText(ItemStack itemStack, List<Component> components, double blockedDamage) {
        int reinforced = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)SPEnchantments.REINFORCED.get()), (ItemStack)itemStack);
        float finalBlockedDamage = (float)(blockedDamage + ShieldReinforcedEnchantment.getDamageBlocked(reinforced));
        int reflection = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)SPEnchantments.REFLECTION.get()), (ItemStack)itemStack);
        float reflectedDamage = ShieldReflectionEnchantment.getReflectedDamage(reflection);
        float blockedDamageReduction = (float)((double)ShieldReflectionEnchantment.getBlockedDamageReduction(reflection) * blockedDamage);
        components.add((Component)new TranslatableComponent("shieldsplus:damage_blocked", new Object[]{new DecimalFormat("#.#").format(finalBlockedDamage -= blockedDamageReduction)}).m_130940_(ChatFormatting.BLUE));
        if (reinforced > 0) {
            components.add((Component)new TranslatableComponent("shieldsplus:reinforced_bonus", new Object[]{new DecimalFormat("#.#").format(ShieldReinforcedEnchantment.getDamageBlocked(reinforced))}).m_130940_(ChatFormatting.DARK_GRAY));
        }
        if (reflection > 0) {
            components.add((Component)new TranslatableComponent("shieldsplus:reflection_malus", new Object[]{new DecimalFormat("#.#").format(blockedDamageReduction)}).m_130940_(ChatFormatting.DARK_GRAY));
        }
        if (reflection > 0) {
            components.add((Component)new TranslatableComponent("shieldsplus:damage_reflected", new Object[]{new DecimalFormat("#.#").format(reflectedDamage * 100.0f)}).m_130940_(ChatFormatting.BLUE));
            components.add((Component)new TranslatableComponent("shieldsplus:capped_damage_reflected", new Object[]{new DecimalFormat("#.#").format(ShieldReflectionEnchantment.getCappedReflectedDamage(reflection))}).m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    public boolean m_6832_(@NotNull ItemStack repaired, @NotNull ItemStack repairingMaterial) {
        if (this.material.repairItem != null) {
            return repairingMaterial.m_150930_(this.material.repairItem);
        }
        return repairingMaterial.m_204117_(this.material.repairTag);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initClientMaterial() {
        this.clientMaterial = new Material(InventoryMenu.f_39692_, new ResourceLocation("shieldsplus", "entity/%s_shield".formatted(this.material.materialName)));
        this.clientMaterialNoPattern = new Material(InventoryMenu.f_39692_, new ResourceLocation("shieldsplus", "entity/%s_shield_nopattern".formatted(this.material.materialName)));
    }
}

