/*
 * Decompiled with CFR 0.152.
 */
package com.insane96mcp.shieldsplus.world.item.enchantment;

import com.insane96mcp.shieldsplus.setup.SPEnchantments;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class ShieldReflectionEnchantment
extends Enchantment {
    public static final float REFLECTED_DAMAGE = 0.15f;
    public static final float CAPPED_REFLECTED_DAMAGE = 2.0f;
    public static final float BLOCKED_DAMAGE_REDUCTION = 0.1f;

    public ShieldReflectionEnchantment() {
        super(Enchantment.Rarity.RARE, EnchantmentCategory.BREAKABLE, new EquipmentSlot[]{EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND});
    }

    public int m_6183_(int p_44598_) {
        return 9 + (p_44598_ - 1) * 14;
    }

    public int m_6175_(int p_44600_) {
        return this.m_6183_(p_44600_) + 14;
    }

    public int m_6586_() {
        return 3;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return stack.m_41720_() instanceof ShieldItem;
    }

    public static float getReflectedDamage(int level) {
        return (float)level * 0.15f;
    }

    public static float getReflectedDamage(ItemStack stack) {
        return ShieldReflectionEnchantment.getReflectedDamage(EnchantmentHelper.m_44843_((Enchantment)((Enchantment)SPEnchantments.REINFORCED.get()), (ItemStack)stack));
    }

    public static float getCappedReflectedDamage(int level) {
        return (float)level * 2.0f;
    }

    public static float getCappedReflectedDamage(ItemStack stack) {
        return ShieldReflectionEnchantment.getReflectedDamage(EnchantmentHelper.m_44843_((Enchantment)((Enchantment)SPEnchantments.REINFORCED.get()), (ItemStack)stack));
    }

    public static float getBlockedDamageReduction(int level) {
        return (float)level * 0.1f;
    }

    public static float getBlockedDamageReduction(ItemStack stack) {
        return ShieldReflectionEnchantment.getBlockedDamageReduction(EnchantmentHelper.m_44843_((Enchantment)((Enchantment)SPEnchantments.REINFORCED.get()), (ItemStack)stack));
    }

    public static void onBlocked(LivingEntity blockingEntity, DamageSource source, float amount) {
        LivingEntity sourceEntity;
        block5: {
            block4: {
                Entity entity = source.m_7639_();
                if (!(entity instanceof LivingEntity)) break block4;
                sourceEntity = (LivingEntity)entity;
                if (source.m_7639_() == source.m_7640_()) break block5;
            }
            return;
        }
        ItemStack shield = blockingEntity.m_21211_();
        int reflection = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)SPEnchantments.REFLECTION.get()), (ItemStack)shield);
        if (reflection > 0) {
            sourceEntity.m_6469_(DamageSource.m_19335_((Entity)blockingEntity), Math.min(ShieldReflectionEnchantment.getReflectedDamage(reflection) * amount, ShieldReflectionEnchantment.getCappedReflectedDamage(reflection)));
        }
    }
}

