/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.insanelib.util;

import insane96mcp.insanelib.util.LogHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.tags.ITag;

public class IdTagMatcher {
    public Type type;
    public ResourceLocation location;
    @Nullable
    public ResourceLocation dimension;

    public IdTagMatcher(Type type, ResourceLocation location, @Nullable ResourceLocation dimension) {
        Objects.requireNonNull(type, "type can't be null");
        Objects.requireNonNull(location, "location can't be null");
        this.type = type;
        this.location = location;
        this.dimension = dimension;
    }

    public IdTagMatcher(Type type, ResourceLocation location) {
        this(type, location, null);
    }

    @Nullable
    public static IdTagMatcher parseLine(String line) {
        String[] split = line.split(",");
        if (split.length < 1 || split.length > 2) {
            LogHelper.warn("Invalid line \"%s\". Format must be modid:entry_or_tag,modid:dimension", line);
            return null;
        }
        ResourceLocation dimension = null;
        if (split.length == 2 && (dimension = ResourceLocation.m_135820_((String)split[1])) == null) {
            LogHelper.warn(String.format("Invalid dimension. Ignoring it. '%s'", line), new Object[0]);
        }
        if (split[0].startsWith("#")) {
            ResourceLocation tag = ResourceLocation.m_135820_((String)split[0].substring(1));
            if (tag == null) {
                LogHelper.warn("Tag is not valid. '%s'", line);
                return null;
            }
            return new IdTagMatcher(Type.TAG, tag, dimension);
        }
        ResourceLocation id = ResourceLocation.m_135820_((String)split[0]);
        if (id == null) {
            LogHelper.warn("Id is not valid. '%s'", line);
            return null;
        }
        return new IdTagMatcher(Type.ID, id, dimension);
    }

    public static ArrayList<? extends IdTagMatcher> parseStringList(List<? extends String> list) {
        ArrayList<IdTagMatcher> idTagMatchers = new ArrayList<IdTagMatcher>();
        for (String string : list) {
            IdTagMatcher idTagMatcher = IdTagMatcher.parseLine(string);
            if (idTagMatcher == null) continue;
            idTagMatchers.add(idTagMatcher);
        }
        return idTagMatchers;
    }

    public boolean matchesBlock(Block block) {
        return this.matchesBlock(block, null);
    }

    public boolean matchesBlock(Block block, @Nullable ResourceLocation dimensionId) {
        if (this.type == Type.TAG) {
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)this.location);
            ITag tag = ForgeRegistries.BLOCKS.tags().getTag(tagKey);
            if (!tag.contains((Object)block)) {
                return false;
            }
            return dimensionId == null || dimensionId.equals((Object)this.dimension);
        }
        ResourceLocation id = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block);
        if (id != null && id.equals((Object)this.location)) {
            return dimensionId == null || dimensionId.equals((Object)this.dimension);
        }
        return false;
    }

    public boolean matchesItem(Item item) {
        return this.matchesItem(item, null);
    }

    public boolean matchesItem(Item item, @Nullable ResourceLocation dimensionId) {
        if (this.type == Type.TAG) {
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)this.location);
            ITag tag = ForgeRegistries.ITEMS.tags().getTag(tagKey);
            if (!tag.contains((Object)item)) {
                return false;
            }
            return dimensionId == null || dimensionId.equals((Object)this.dimension);
        }
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item);
        if (id != null && id.equals((Object)this.location)) {
            return dimensionId == null || dimensionId.equals((Object)this.dimension);
        }
        return false;
    }

    public boolean matchesFluid(Fluid fluid) {
        return this.matchesFluid(fluid, null);
    }

    public boolean matchesFluid(Fluid fluid, @Nullable ResourceLocation dimensionId) {
        if (this.type == Type.TAG) {
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registry.f_122899_, (ResourceLocation)this.location);
            ITag fluidTag = ForgeRegistries.FLUIDS.tags().getTag(tagKey);
            if (!fluidTag.contains((Object)fluid)) {
                return false;
            }
            return dimensionId == null || dimensionId.equals((Object)this.dimension);
        }
        ResourceLocation id = ForgeRegistries.FLUIDS.getKey((IForgeRegistryEntry)fluid);
        if (id != null && id.equals((Object)this.location)) {
            return dimensionId == null || dimensionId.equals((Object)this.dimension);
        }
        return false;
    }

    public boolean matchesEntity(Entity entity) {
        return this.matchesEntity(entity.m_6095_(), null);
    }

    public boolean matchesEntity(Entity entity, @Nullable ResourceLocation dimensionId) {
        return this.matchesEntity(entity.m_6095_(), dimensionId);
    }

    public boolean matchesEntity(EntityType<?> entityType) {
        return this.matchesEntity(entityType, null);
    }

    public boolean matchesEntity(EntityType<?> entityType, @Nullable ResourceLocation dimensionId) {
        if (this.type == Type.TAG) {
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registry.f_122903_, (ResourceLocation)this.location);
            ITag tag = ForgeRegistries.ENTITIES.tags().getTag(tagKey);
            if (!tag.contains(entityType)) {
                return false;
            }
            return dimensionId == null || dimensionId.equals((Object)this.dimension);
        }
        ResourceLocation id = ForgeRegistries.ENTITIES.getKey(entityType);
        if (id != null && id.equals((Object)this.location)) {
            return dimensionId == null || dimensionId.equals((Object)this.dimension);
        }
        return false;
    }

    public List<Block> getAllBlocks() {
        ArrayList<Block> blocks = new ArrayList<Block>();
        if (this.type == Type.ID) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(this.location);
            if (block != null) {
                blocks.add(block);
            }
        } else {
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)this.location);
            ITag blockTag = ForgeRegistries.BLOCKS.tags().getTag(tagKey);
            blocks.addAll(blockTag.stream().toList());
        }
        return blocks;
    }

    public List<Item> getAllItems() {
        ArrayList<Item> items = new ArrayList<Item>();
        if (this.type == Type.ID) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(this.location);
            if (item != null) {
                items.add(item);
            }
        } else {
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)this.location);
            ITag itemTag = ForgeRegistries.ITEMS.tags().getTag(tagKey);
            items.addAll(itemTag.stream().toList());
        }
        return items;
    }

    public List<ItemStack> getAllItemStacks() {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        this.getAllItems().forEach(item -> itemStacks.add(new ItemStack((ItemLike)item)));
        return itemStacks;
    }

    public List<Fluid> getAllFluids() {
        ArrayList<Fluid> fluids = new ArrayList<Fluid>();
        if (this.type == Type.ID) {
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(this.location);
            if (fluid != null) {
                fluids.add(fluid);
            }
        } else {
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registry.f_122899_, (ResourceLocation)this.location);
            ITag fluidTag = ForgeRegistries.FLUIDS.tags().getTag(tagKey);
            fluids.addAll(fluidTag.stream().toList());
        }
        return fluids;
    }

    public List<FluidStack> getAllFluidStacks() {
        ArrayList<FluidStack> fluidStacks = new ArrayList<FluidStack>();
        this.getAllFluids().forEach(item -> fluidStacks.add(new FluidStack(item, 1000)));
        return fluidStacks;
    }

    public List<EntityType<?>> getAllEntityTypes() {
        ArrayList entityTypes = new ArrayList();
        if (this.type == Type.ID) {
            EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(this.location);
            if (entityType != null) {
                entityTypes.add(entityType);
            }
        } else {
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registry.f_122903_, (ResourceLocation)this.location);
            ITag entityTag = ForgeRegistries.ENTITIES.tags().getTag(tagKey);
            entityTypes.addAll(entityTag.stream().toList());
        }
        return entityTypes;
    }

    public static enum Type {
        ID,
        TAG;

    }
}

