/*
 * Decompiled with CFR 0.152.
 */
package com.insane96mcp.shieldsplus.module.base.feature;

import com.insane96mcp.shieldsplus.setup.SPShieldMaterials;
import com.insane96mcp.shieldsplus.world.item.SPShieldItem;
import com.insane96mcp.shieldsplus.world.item.enchantment.ShieldAblazeEnchantment;
import com.insane96mcp.shieldsplus.world.item.enchantment.ShieldBashEnchantment;
import com.insane96mcp.shieldsplus.world.item.enchantment.ShieldLightweightEnchantment;
import com.insane96mcp.shieldsplus.world.item.enchantment.ShieldRecoilEnchantment;
import com.insane96mcp.shieldsplus.world.item.enchantment.ShieldReflectionEnchantment;
import com.insane96mcp.shieldsplus.world.item.enchantment.ShieldReinforcedEnchantment;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Shields+")
@LoadFeature(module="shieldsplus:base", canBeDisabled=false)
public class BaseFeature
extends Feature {
    @Config
    @Label(name="Remove Shield Windup", description="In vanilla when you start blocking with a shield, there's a 0.25 seconds window where you are still not blocking. If true this (stupid) windup time is removed.")
    public static Boolean removeShieldWindup = true;
    @Config
    @Label(name="Shields Block Fixed Damage Amount", description="If true shields will block only a certain amount of damage. If false the vanilla behaviour is used.")
    public static Boolean shieldBlockFixedDamageAmount = true;
    @Config(min=0.0, max=3.4028234663852886E38)
    @Label(name="Min Shield Hurt Damage", description="The minimum damage dealt to the player for the shield to take damage (reduce durability). Vanilla is 3.")
    public static Double minShieldHurtDamage = 0.0;
    @Config
    @Label(name="Combat Test shield disabling", description="Makes shields always disable for 1.6 seconds like Combat Test snapshots.")
    public static Boolean combatTestShieldDisabling = true;

    public BaseFeature(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onShieldBlock(ShieldBlockEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (shieldBlockFixedDamageAmount.booleanValue()) {
            double baseBlockedDamage;
            if (event.getEntity().m_21211_().m_150930_(Items.f_42740_)) {
                baseBlockedDamage = SPShieldMaterials.IRON.damageBlocked;
            } else if (event.getEntity().m_21211_().m_41720_() instanceof SPShieldItem) {
                baseBlockedDamage = ((SPShieldItem)event.getEntity().m_21211_().m_41720_()).getBlockedDamage();
            } else {
                return;
            }
            float blockedDamage = (float)(baseBlockedDamage + ShieldReinforcedEnchantment.getDamageBlocked(event.getEntity().m_21211_()));
            event.setBlockedDamage(blockedDamage);
        }
        this.processEnchantments(event.getEntity(), event.getDamageSource(), event.getOriginalBlockedDamage());
    }

    private void processEnchantments(LivingEntity blockingEntity, DamageSource source, float amount) {
        if (blockingEntity.m_21211_().m_41720_() instanceof ShieldItem) {
            ShieldRecoilEnchantment.onBlocked(blockingEntity, source);
            ShieldReflectionEnchantment.onBlocked(blockingEntity, source, amount);
            ShieldAblazeEnchantment.onBlocked(blockingEntity, source);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!this.isEnabled() || event.phase != TickEvent.Phase.END) {
            return;
        }
        ShieldLightweightEnchantment.onTick(event.player);
        ShieldBashEnchantment.onTick(event.player);
    }

    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        if (!this.isEnabled() || !shieldBlockFixedDamageAmount.booleanValue()) {
            return;
        }
        if (event.getItemStack().m_150930_(Items.f_42740_)) {
            SPShieldItem.addDamageBlockedText(event.getItemStack(), event.getToolTip(), SPShieldMaterials.IRON.damageBlocked);
        }
    }

    public static boolean shouldRemoveShieldWindup() {
        return BaseFeature.isEnabled(BaseFeature.class) && removeShieldWindup != false;
    }

    public static boolean combatTestShieldDisabling() {
        return BaseFeature.isEnabled(BaseFeature.class) && combatTestShieldDisabling != false;
    }
}

